/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.plume.RegexUtil;
import afu.plume.UtilMDE;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntryReader
extends LineNumberReader
implements Iterable<String>,
Iterator<String> {
    private final Pattern include_re;
    private final Pattern comment_re;
    public Pattern entry_start_re = null;
    public Pattern entry_stop_re = null;
    private final Stack<FlnReader> readers = new Stack();
    String pushback_line = null;
    private static final String lineSep = System.getProperty("line.separator");

    public EntryReader(InputStream in, String charsetName, String filename, String comment_re_string, String include_re_string) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, charsetName), filename, comment_re_string, include_re_string);
    }

    public EntryReader(InputStream in, String charsetName, String filename) throws UnsupportedEncodingException {
        this(in, charsetName, filename, null, null);
    }

    public EntryReader(InputStream in, String filename, String comment_re_string, String include_re_string) {
        this(new InputStreamReader(in), filename, comment_re_string, include_re_string);
    }

    public EntryReader(InputStream in, String filename) {
        this(in, filename, null, null);
    }

    public EntryReader(InputStream in) {
        this(in, "(InputStream)", null, null);
    }

    public EntryReader(Reader reader, String filename, String comment_re_string, String include_re_string) {
        super(new DummyReader());
        this.readers.push(new FlnReader(reader, filename));
        this.comment_re = comment_re_string == null ? null : Pattern.compile(comment_re_string);
        this.include_re = include_re_string == null ? null : Pattern.compile(include_re_string);
    }

    public EntryReader(Reader reader) {
        this(reader, reader.toString(), null, null);
    }

    public EntryReader(File file, String comment_re, String include_re) throws IOException {
        this(UtilMDE.fileReader(file), file.toString(), comment_re, include_re);
    }

    public EntryReader(File file) throws IOException {
        this(file, null, null);
    }

    public EntryReader(File file, String charsetName) throws IOException {
        this(UtilMDE.fileInputStream(file), charsetName, file.toString(), null, null);
    }

    public EntryReader(String filename, String comment_re, String include_re) throws IOException {
        this(new File(filename), comment_re, include_re);
    }

    public EntryReader(String filename) throws IOException {
        this(filename, null, null);
    }

    public EntryReader(String filename, String charsetName) throws IOException {
        this(new FileInputStream(filename), charsetName, filename, null, null);
    }

    @Override
    public String readLine() throws IOException {
        Matcher m3;
        if (this.pushback_line != null) {
            String line = this.pushback_line;
            this.pushback_line = null;
            return line;
        }
        String line = this.get_next_line();
        if (this.comment_re != null) {
            Matcher cmatch;
            while (line != null && (cmatch = this.comment_re.matcher(line)).find() && (line = cmatch.replaceFirst("")).length() <= 0) {
                line = this.get_next_line();
            }
        }
        if (line == null) {
            return null;
        }
        if (this.include_re != null && (m3 = this.include_re.matcher(line)).matches()) {
            String filename_string = m3.group(1);
            if (filename_string == null) {
                throw new Error(String.format("include_re (%s) does not capture group 1 in %s", this.include_re, line));
            }
            File filename = new File(UtilMDE.expandFilename(filename_string));
            if (!filename.isAbsolute()) {
                FlnReader reader = this.readers.peek();
                File current_filename = new File(reader.filename);
                File current_parent = current_filename.getParentFile();
                filename = new File(current_parent, filename.toString());
            }
            this.readers.push(new FlnReader(filename.getAbsolutePath()));
            return this.readLine();
        }
        return line;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.pushback_line != null) {
            return true;
        }
        String line = null;
        try {
            line = this.readLine();
        }
        catch (IOException e) {
            throw new Error("unexpected IOException: ", e);
        }
        if (line == null) {
            return false;
        }
        this.putback(line);
        return true;
    }

    @Override
    public String next() {
        try {
            String result = this.readLine();
            if (result != null) {
                return result;
            }
            throw new NoSuchElementException();
        }
        catch (IOException e) {
            throw new Error("unexpected IOException", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove lines from file");
    }

    public Entry get_entry() throws IOException {
        String line = this.readLine();
        while (line != null && line.trim().length() == 0) {
            line = this.readLine();
        }
        if (line == null) {
            return null;
        }
        StringBuilder body = new StringBuilder(10000);
        Entry entry = null;
        String filename = this.getFileName();
        long line_number = this.getLineNumber();
        Matcher entry_match = null;
        if (this.entry_start_re != null) {
            entry_match = this.entry_start_re.matcher(line);
        }
        if (entry_match != null && entry_match.find()) {
            assert (this.entry_start_re != null) : "@AssumeAssertion(nullness): dependent: entry_match != null";
            assert (this.entry_stop_re != null) : "@AssumeAssertion(nullness): dependent: entry_start_re != null";
            if (entry_match.groupCount() > 0) {
                String match_group_1 = entry_match.group(1);
                line = entry_match.replaceFirst(match_group_1);
            }
            String description = line;
            Matcher end_entry_match = this.entry_stop_re.matcher(line);
            while (line != null && !entry_match.find() && !end_entry_match.find() && filename.equals(this.getFileName())) {
                body.append(line);
                body.append(lineSep);
                line = this.readLine();
                if (line == null) break;
                entry_match = this.entry_start_re.matcher(line);
                end_entry_match = this.entry_stop_re.matcher(line);
            }
            if (line != null && (entry_match.find(0) || !filename.equals(this.getFileName()))) {
                this.putback(line);
            }
            entry = new Entry(description, body.toString(), filename, line_number, false);
        } else {
            String description = line;
            while (line != null && line.trim().length() != 0 && filename.equals(this.getFileName())) {
                body.append(line);
                body.append(lineSep);
                line = this.readLine();
            }
            if (line != null && !filename.equals(this.getFileName())) {
                this.putback(line);
            }
            entry = new Entry(description, body.toString(), filename, line_number, true);
        }
        return entry;
    }

    private String get_next_line() throws IOException {
        if (this.readers.size() == 0) {
            return null;
        }
        FlnReader ri1 = this.readers.peek();
        String line = ri1.readLine();
        while (line == null) {
            this.readers.pop();
            if (this.readers.empty()) {
                return null;
            }
            FlnReader ri2 = this.readers.peek();
            line = ri2.readLine();
        }
        return line;
    }

    public String getFileName() {
        FlnReader ri = this.readers.peek();
        if (ri == null) {
            throw new Error("Past end of input");
        }
        return ri.filename;
    }

    @Override
    public int getLineNumber() {
        FlnReader ri = this.readers.peek();
        if (ri == null) {
            throw new Error("Past end of input");
        }
        return ri.getLineNumber();
    }

    @Override
    public void setLineNumber(int lineNumber) {
        FlnReader ri = this.readers.peek();
        if (ri == null) {
            throw new Error("Past end of input");
        }
        ri.setLineNumber(lineNumber);
    }

    public void set_entry_start_stop(String entry_start_re, String entry_stop_re) {
        this.entry_start_re = Pattern.compile(entry_start_re);
        this.entry_stop_re = Pattern.compile(entry_stop_re);
    }

    public void set_entry_start_stop(Pattern entry_start_re, Pattern entry_stop_re) {
        this.entry_start_re = entry_start_re;
        this.entry_stop_re = entry_stop_re;
    }

    public void putback(String line) {
        assert (this.pushback_line == null) : "push back '" + line + "' when '" + this.pushback_line + "' already back";
        this.pushback_line = line;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new Error("not yet implemented");
    }

    @Override
    public int read() {
        throw new Error("not yet implemented");
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        throw new Error("not yet implemented");
    }

    @Override
    public void reset() {
        throw new Error("not yet implemented");
    }

    @Override
    public long skip(long n) {
        throw new Error("not yet implemented");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || args.length > 3) {
            System.err.println("EntryReader sample program requires 1-3 args: filename [comment_re [include_re]]");
            System.exit(1);
        }
        String filename = args[0];
        String comment_re = null;
        String include_re = null;
        if (args.length >= 2 && !RegexUtil.isRegex(comment_re = args[1])) {
            System.err.println("Error parsing comment regex \"" + comment_re + "\": " + RegexUtil.regexError(comment_re));
            System.exit(1);
        }
        if (args.length >= 3 && !RegexUtil.isRegex(include_re = args[2], 1)) {
            System.err.println("Error parsing include regex \"" + include_re + "\": " + RegexUtil.regexError(include_re));
            System.exit(1);
        }
        EntryReader reader = new EntryReader(filename, comment_re, include_re);
        String line = reader.readLine();
        while (line != null) {
            System.out.printf("%s: %d: %s%n", reader.getFileName(), reader.getLineNumber(), line);
            line = reader.readLine();
        }
    }

    private static class DummyReader
    extends Reader {
        private DummyReader() {
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int readAheadLimit) {
            throw new Error("DummyReader");
        }

        @Override
        public boolean markSupported() {
            throw new Error("DummyReader");
        }

        @Override
        public int read() {
            throw new Error("DummyReader");
        }

        @Override
        public int read(char[] cbuf) {
            throw new Error("DummyReader");
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            throw new Error("DummyReader");
        }

        @Override
        public int read(CharBuffer target) {
            throw new Error("DummyReader");
        }

        @Override
        public boolean ready() {
            throw new Error("DummyReader");
        }

        @Override
        public void reset() {
            throw new Error("DummyReader");
        }

        @Override
        public long skip(long n) {
            throw new Error("DummyReader");
        }
    }

    public static class Entry {
        public String first_line;
        public String body;
        boolean short_entry;
        String filename;
        long line_number;

        Entry(String first_line, String body, String filename, long line_number, boolean short_entry) {
            this.first_line = first_line;
            this.body = body;
            this.filename = filename;
            this.line_number = line_number;
            this.short_entry = short_entry;
        }

        String get_description(Pattern re) {
            if (re == null) {
                return this.first_line;
            }
            Matcher descr = re.matcher(this.body);
            if (descr.find()) {
                return descr.group();
            }
            return this.first_line;
        }
    }

    private static class FlnReader
    extends LineNumberReader {
        public String filename;

        public FlnReader(Reader reader, String filename) {
            super(reader);
            this.filename = filename;
        }

        public FlnReader(String filename) throws IOException {
            super(UtilMDE.fileReader(filename));
            this.filename = filename;
        }
    }
}

