/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc2;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import afu.org.tmatesoft.svn.core.wc2.SvnOperation;
import afu.org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import java.util.Collection;
import java.util.LinkedList;

public class SvnReceivingOperation<T>
extends SvnOperation<T>
implements ISvnObjectReceiver<T> {
    private ISvnObjectReceiver<T> receiver;
    private T first;
    private T last;
    private Collection<T> receivedObjects;

    protected SvnReceivingOperation(SvnOperationFactory factory) {
        super(factory);
    }

    public void setReceiver(ISvnObjectReceiver<T> receiver) {
        this.receiver = receiver;
    }

    public ISvnObjectReceiver<T> getReceiver() {
        return this.receiver;
    }

    @Override
    public void receive(SvnTarget target, T object) throws SVNException {
        if (this.first == null) {
            this.first = object;
        }
        this.last = object;
        if (this.getReceivedObjects() != null) {
            this.getReceivedObjects().add(object);
        }
        if (this.getReceiver() != null) {
            this.getReceiver().receive(target, object);
        }
    }

    public T first() {
        return this.first;
    }

    public T last() {
        return this.last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> run(Collection<T> objects) throws SVNException {
        this.setReceivingContainer(objects != null ? objects : new LinkedList());
        try {
            this.run();
            Collection<T> collection = this.getReceivedObjects();
            return collection;
        }
        finally {
            this.setReceivingContainer(null);
        }
    }

    @Override
    protected void initDefaults() {
        super.initDefaults();
        this.first = null;
    }

    private void setReceivingContainer(Collection<T> receivingContainer) {
        this.receivedObjects = receivingContainer;
    }

    private Collection<T> getReceivedObjects() {
        return this.receivedObjects;
    }
}

