/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc.xml;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import afu.org.tmatesoft.svn.core.wc.SVNStatus;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import afu.org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import afu.org.tmatesoft.svn.util.ISVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import afu.org.xml.sax.ContentHandler;
import afu.org.xml.sax.SAXException;
import java.io.File;

public class SVNXMLStatusHandler
extends AbstractXMLHandler
implements ISVNStatusHandler {
    private static final String AGAINST_TAG = "against";
    private static final String TARGET_TAG = "target";
    public static final String EXPIRES_TAG = "expires";
    public static final String CREATED_TAG = "created";
    public static final String COMMENT_TAG = "comment";
    public static final String OWNER_TAG = "owner";
    public static final String TOKEN_TAG = "token";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String REMOTE_STATUS_TAG = "repos-status";
    public static final String LOCK_TAG = "lock";
    public static final String COMMIT_TAG = "commit";
    public static final String WC_STATUS_TAG = "wc-status";
    public static final String ENTRY_TAG = "entry";
    public static final String STATUS_TAG = "status";
    public static final String REVISION_ATTR = "revision";
    public static final String SWITCHED_ATTR = "switched";
    public static final String COPIED_ATTR = "copied";
    public static final String WC_LOCKED_ATTR = "wc-locked";
    public static final String PROPS_ATTR = "props";
    public static final String ITEM_ATTR = "item";
    public static final String PATH_ATTR = "path";
    private static final String TRUE = "true";
    private File myTargetPath;

    public SVNXMLStatusHandler(ContentHandler saxHandler) {
        this(saxHandler, null);
    }

    public SVNXMLStatusHandler(ContentHandler saxHandler, ISVNDebugLog log) {
        super(saxHandler, log);
    }

    public void startTarget(File path) {
        try {
            this.myTargetPath = path;
            this.addAttribute(PATH_ATTR, path.getPath());
            this.openTag(TARGET_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    @Override
    public void handleStatus(SVNStatus status) throws SVNException {
        try {
            this.sendToHandler(status);
        }
        catch (SAXException th) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, th);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, th.getLocalizedMessage());
            SVNErrorManager.error(err, th, SVNLogType.DEFAULT);
        }
    }

    public void endTarget(long revision) {
        try {
            this.myTargetPath = null;
            if (revision >= 0L) {
                this.addAttribute(REVISION_ATTR, revision + "");
                this.openTag(AGAINST_TAG);
                this.closeTag(AGAINST_TAG);
            }
            this.closeTag(TARGET_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    private void sendToHandler(SVNStatus status) throws SAXException {
        this.addAttribute(PATH_ATTR, this.getRelativePath(status.getFile()));
        this.openTag(ENTRY_TAG);
        this.addAttribute(PROPS_ATTR, status.getPropertiesStatus().toString());
        this.addAttribute(ITEM_ATTR, status.getContentsStatus().toString());
        if (status.isLocked()) {
            this.addAttribute(WC_LOCKED_ATTR, TRUE);
        }
        if (status.isCopied()) {
            this.addAttribute(COPIED_ATTR, TRUE);
        }
        if (status.isSwitched()) {
            this.addAttribute(SWITCHED_ATTR, TRUE);
        }
        if (!status.isCopied() && status.getRevision() != null && status.getRevision().getNumber() >= 0L) {
            this.addAttribute(REVISION_ATTR, status.getRevision().toString());
        }
        this.openTag(WC_STATUS_TAG);
        if (status.getCommittedRevision() != null && status.getCommittedRevision().getNumber() >= 0L) {
            this.addAttribute(REVISION_ATTR, status.getCommittedRevision().toString());
            this.openTag(COMMIT_TAG);
            this.addTag(AUTHOR_TAG, status.getAuthor());
            if (status.getCommittedDate() != null) {
                this.addTag(DATE_TAG, SVNDate.formatDate(status.getCommittedDate()));
            }
            this.closeTag(COMMIT_TAG);
        }
        if (status.getLocalLock() != null) {
            this.openTag(LOCK_TAG);
            this.addTag(TOKEN_TAG, status.getLocalLock().getID());
            this.addTag(OWNER_TAG, status.getLocalLock().getOwner());
            this.addTag(COMMENT_TAG, status.getLocalLock().getComment());
            this.addTag(CREATED_TAG, SVNDate.formatDate(status.getLocalLock().getCreationDate()));
            this.closeTag(LOCK_TAG);
        }
        this.closeTag(WC_STATUS_TAG);
        if (status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE || status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || status.getRemoteLock() != null) {
            this.addAttribute(PROPS_ATTR, status.getRemotePropertiesStatus().toString());
            this.addAttribute(ITEM_ATTR, status.getRemoteContentsStatus().toString());
            this.openTag(REMOTE_STATUS_TAG);
            if (status.getRemoteLock() != null) {
                this.openTag(LOCK_TAG);
                this.addTag(TOKEN_TAG, status.getRemoteLock().getID());
                this.addTag(OWNER_TAG, status.getRemoteLock().getOwner());
                this.addTag(COMMENT_TAG, status.getRemoteLock().getComment());
                this.addTag(CREATED_TAG, SVNDate.formatDate(status.getRemoteLock().getCreationDate()));
                if (status.getRemoteLock().getExpirationDate() != null) {
                    this.addTag(EXPIRES_TAG, SVNDate.formatDate(status.getRemoteLock().getExpirationDate()));
                }
                this.closeTag(LOCK_TAG);
            }
            this.closeTag(REMOTE_STATUS_TAG);
        }
        this.closeTag(ENTRY_TAG);
    }

    protected String getRelativePath(File path) {
        String fullPath = path.getAbsoluteFile().getAbsolutePath();
        if (this.myTargetPath == null) {
            return fullPath;
        }
        StringBuffer relativePath = new StringBuffer();
        char pathSeparator = File.separatorChar;
        boolean targetMeet = false;
        if (!path.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile())) {
            do {
                if (relativePath.length() > 0) {
                    relativePath.insert(0, pathSeparator);
                }
                relativePath = relativePath.insert(0, path.getName());
                if ((path = path.getParentFile()) == null) continue;
                targetMeet = path.getAbsoluteFile().equals(this.myTargetPath.getAbsoluteFile());
            } while (path != null && !targetMeet);
        } else {
            return this.myTargetPath.getPath();
        }
        if (path != null) {
            if (relativePath.length() > 0) {
                relativePath.insert(0, pathSeparator);
            }
        } else {
            return fullPath;
        }
        relativePath = relativePath.insert(0, this.myTargetPath.getPath());
        return relativePath.toString();
    }

    protected String getTargetPath() {
        return this.getRelativePath(this.myTargetPath);
    }

    @Override
    protected String getHeaderName() {
        return STATUS_TAG;
    }
}

