/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import afu.org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import afu.org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import afu.org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import afu.org.tmatesoft.svn.core.wc.SVNBasicClient;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNStatus;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import afu.org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import afu.org.tmatesoft.svn.core.wc2.SvnGetStatus;
import afu.org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import afu.org.tmatesoft.svn.core.wc2.SvnStatus;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import java.io.File;
import java.util.Collection;

public class SVNStatusClient
extends SVNBasicClient {
    private ISVNStatusFileProvider myFilesProvider;

    public SVNStatusClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNStatusClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNStatusClient(SvnOperationFactory of) {
        super(of);
    }

    @Override
    protected void initDefaults() {
        this.setFilesProvider(null);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, SVNRevision.HEAD, SVNDepth.fromRecurse(recursive), remote, reportAll, includeIgnored, false, handler, null);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, SVNRevision.HEAD, SVNDepth.fromRecurse(recursive), remote, reportAll, includeIgnored, collectParentExternals, handler, null);
    }

    public long doStatus(File path, SVNRevision revision, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, revision, SVNDepth.fromRecurse(recursive), remote, reportAll, includeIgnored, collectParentExternals, handler, null);
    }

    public long doStatus(File path, SVNRevision revision, SVNDepth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, final ISVNStatusHandler handler, Collection<String> changeLists) throws SVNException {
        final SvnGetStatus getStatus = this.getOperationsFactory().createGetStatus();
        getStatus.setReportExternals(!this.isIgnoreExternals());
        getStatus.setFileListHook(SvnCodec.fileListHook(this.myFilesProvider));
        getStatus.setApplicalbeChangelists(changeLists);
        getStatus.setCollectParentExternals(collectParentExternals);
        getStatus.setDepth(depth);
        getStatus.setRevision(revision);
        getStatus.setRemote(remote);
        getStatus.setReportAll(reportAll);
        getStatus.setReportIgnored(includeIgnored);
        getStatus.setSingleTarget(SvnTarget.fromFile(path));
        getStatus.setReceiver(new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                SVNWCContext context = getStatus.getOperationFactory().getWcContext();
                handler.handleStatus(SvnCodec.status(context, status));
            }
        });
        getStatus.run();
        return getStatus.getRemoteRevision();
    }

    public SVNStatus doStatus(File path, boolean remote) throws SVNException {
        return this.doStatus(path, remote, false);
    }

    public SVNStatus doStatus(File path, boolean remote, boolean collectParentExternals) throws SVNException {
        final SVNStatus[] result = new SVNStatus[]{null};
        final File absPath = path.getAbsoluteFile();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            @Override
            public void handleStatus(SVNStatus status) {
                if (absPath.equals(status.getFile())) {
                    if (result[0] != null && result[0].getContentsStatus() == SVNStatusType.STATUS_EXTERNAL && absPath.isDirectory()) {
                        result[0] = status;
                        result[0].markExternal();
                    } else if (result[0] == null) {
                        result[0] = status;
                    }
                }
            }
        };
        this.doStatus(absPath, SVNRevision.HEAD, SVNDepth.EMPTY, remote, true, true, collectParentExternals, handler, null);
        return result[0];
    }

    public void setFilesProvider(ISVNStatusFileProvider filesProvider) {
        this.myFilesProvider = filesProvider;
    }
}

