/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc;

import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;

public class SVNPropertyData {
    private SVNPropertyValue myValue;
    private String myName;

    public SVNPropertyData(String name, SVNPropertyValue data, ISVNOptions options) {
        this.myName = name;
        this.myValue = data;
        if (this.myValue != null && SVNProperty.isSVNProperty(this.myName) && this.myValue.isString()) {
            String nativeEOL;
            String string = nativeEOL = options == null ? System.getProperty("line.separator") : new String(options.getNativeEOL());
            if (this.myValue.getString().indexOf(nativeEOL) < 0) {
                this.myValue = SVNPropertyValue.create(this.myValue.getString().replaceAll("\n", nativeEOL));
            }
        }
    }

    public String getName() {
        return this.myName;
    }

    public SVNPropertyValue getValue() {
        return this.myValue;
    }

    public int hashCode() {
        int result = 17 + (this.myName == null ? 0 : this.myName.hashCode());
        return 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SVNPropertyData other = (SVNPropertyData)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }
}

