/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc;

import java.util.HashSet;
import java.util.Set;

public class SVNConflictStats {
    private Set<String> textConflicts = new HashSet<String>();
    private Set<String> propConflicts = new HashSet<String>();
    private Set<String> treeConflicts = new HashSet<String>();
    private int resolvedTextConflictsCount = 0;
    private int resolvedPropConflictsCount = 0;
    private int resolvedTreeConflictsCount = 0;
    private int skippedPathsCount = 0;

    public void incrementTextConflictsResolved(String path) {
        if (this.textConflicts.contains(path)) {
            this.textConflicts.remove(path);
            ++this.resolvedTextConflictsCount;
        }
    }

    public void incrementPropConflictsResolved(String path) {
        if (this.propConflicts.contains(path)) {
            this.propConflicts.remove(path);
            ++this.resolvedPropConflictsCount;
        }
    }

    public void incrementTreeConflictsResolved(String path) {
        if (this.treeConflicts.contains(path)) {
            this.treeConflicts.remove(path);
            ++this.resolvedTreeConflictsCount;
        }
    }

    public int getResolvedTextConflictsCount() {
        return this.resolvedTextConflictsCount;
    }

    public int getResolvedPropConflictsCount() {
        return this.resolvedPropConflictsCount;
    }

    public int getResolvedTreeConflictsCount() {
        return this.resolvedTreeConflictsCount;
    }

    public void incrementSkippedPaths() {
        ++this.skippedPathsCount;
    }

    public void storeTextConflict(String path) {
        this.textConflicts.add(path);
    }

    public void storePropConflict(String path) {
        this.propConflicts.add(path);
    }

    public void storeTreeConflict(String path) {
        this.treeConflicts.add(path);
    }

    public int getTextConflictsCount() {
        return this.textConflicts.size();
    }

    public int getPropConflictsCount() {
        return this.propConflicts.size();
    }

    public int getTreeConflictsCount() {
        return this.treeConflicts.size();
    }

    public int getSkippedPathsCount() {
        return this.skippedPathsCount;
    }
}

