/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.javahl17;

import afu.org.apache.subversion.javahl.ClientNotifyInformation;
import afu.org.apache.subversion.javahl.callback.ClientNotifyCallback;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.javahl17.SVNClientImpl;
import afu.org.tmatesoft.svn.core.wc.ISVNEventHandler;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;

public class JavaHLEventHandler
implements ISVNEventHandler {
    private ClientNotifyCallback notifyCallback;
    private boolean cancelOperation = false;
    private String pathPrefix;

    public JavaHLEventHandler() {
        this.resetPathPrefix();
    }

    public void setNotifyCallback(ClientNotifyCallback notifyCallback) {
        this.notifyCallback = notifyCallback;
    }

    public void setCancelOperation(boolean cancelOperation) {
        this.cancelOperation = cancelOperation;
    }

    public void cancelOperation() {
        this.setCancelOperation(true);
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public void resetPathPrefix() {
        this.setPathPrefix(null);
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) {
        String pathPrefix;
        ClientNotifyInformation ni;
        if (event.getAction() == SVNEventAction.UPGRADE) {
            return;
        }
        String path = null;
        if (event.getFile() != null && (path = event.getFile().getAbsolutePath()) != null) {
            path = path.replace(File.separatorChar, '/');
        }
        if (path == null) {
            path = "";
        }
        if (this.notifyCallback != null && (ni = SVNClientImpl.getClientNotifyInformation(pathPrefix = this.pathPrefix == null ? "" : this.pathPrefix, event, path)) != null) {
            this.notifyCallback.onNotify(ni);
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        if (this.cancelOperation) {
            this.cancelOperation = false;
            SVNErrorManager.cancel("operation cancelled", SVNLogType.DEFAULT);
        }
    }
}

