/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.remote;

import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashSet;
import afu.org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.io.ISVNLockHandler;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc2.SvnSetLock;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import java.io.File;

public class SvnRemoteSetLock
extends SvnRemoteOperationRunner<SVNLock, SvnSetLock>
implements ISVNLockHandler {
    @Override
    public boolean isApplicable(SvnSetLock operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.hasRemoteTargets();
    }

    @Override
    protected SVNLock run() throws SVNException {
        int i = 0;
        SVNURL[] urls = new SVNURL[((SvnSetLock)this.getOperation()).getTargets().size()];
        for (SvnTarget target : ((SvnSetLock)this.getOperation()).getTargets()) {
            urls[i++] = target.getURL();
        }
        SVNHashSet paths = new SVNHashSet();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        SVNHashMap pathsToRevisions = new SVNHashMap();
        for (String path : paths) {
            path = SVNEncodingUtil.uriDecode(path);
            pathsToRevisions.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.getRepositoryAccess().createRepository(topURL, null, true);
        repository.lock(pathsToRevisions, ((SvnSetLock)this.getOperation()).getLockMessage(), ((SvnSetLock)this.getOperation()).isStealLock(), this);
        return (SVNLock)((SvnSetLock)this.getOperation()).first();
    }

    @Override
    public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
        if (error != null) {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
        } else {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCKED, lock, null), -1.0);
        }
    }

    @Override
    public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
    }
}

