/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.remote;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc2.SvnGetProperties;
import afu.org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteGetRevisionProperties
extends SvnRemoteOperationRunner<SVNProperties, SvnGetProperties> {
    @Override
    public boolean isApplicable(SvnGetProperties operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.isRevisionProperties();
    }

    @Override
    protected SVNProperties run() throws SVNException {
        SVNRevision revision = ((SvnGetProperties)this.getOperation()).getRevision();
        if (!revision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SvnRepositoryAccess access = this.getRepositoryAccess();
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = access.createRepositoryFor(((SvnGetProperties)this.getOperation()).getFirstTarget(), SVNRevision.HEAD, SVNRevision.HEAD, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        Structure<SvnRepositoryAccess.RevisionsPair> revPair = access.getRevisionNumber(repository, ((SvnGetProperties)this.getOperation()).getFirstTarget(), ((SvnGetProperties)this.getOperation()).getRevision(), null);
        long revNumber = revPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        ((SvnGetProperties)this.getOperation()).setRevisionNumber(revNumber);
        SVNProperties revisionProperties = repository.getRevisionProperties(revNumber, null);
        if (revisionProperties != null) {
            ((SvnGetProperties)this.getOperation()).receive(((SvnGetProperties)this.getOperation()).getFirstTarget(), revisionProperties);
        }
        return revisionProperties;
    }
}

