/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.remote;

import afu.org.tmatesoft.svn.core.ISVNDirEntryHandler;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNDirEntry;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc2.SvnGetProperties;
import afu.org.tmatesoft.svn.core.wc2.SvnInheritedProperties;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class SvnRemoteGetProperties
extends SvnRemoteOperationRunner<SVNProperties, SvnGetProperties> {
    @Override
    public boolean isApplicable(SvnGetProperties operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (operation.isRevisionProperties()) {
            return false;
        }
        if (super.isApplicable(operation, wcGeneration)) {
            return true;
        }
        return !operation.getRevision().isLocal();
    }

    @Override
    protected SVNProperties run() throws SVNException {
        SVNErrorMessage err;
        long revnum;
        SVNURL url;
        SvnTarget target;
        SvnTarget reposTarget = target = ((SvnGetProperties)this.getOperation()).getFirstTarget();
        SVNRevision revision = ((SvnGetProperties)this.getOperation()).getRevision();
        SVNRevision pegRevision = target.getResolvedPegRevision();
        if (pegRevision.isLocal() && target.isFile()) {
            File localAbsPath = ((SvnGetProperties)this.getOperation()).getFirstTarget().getFile();
            Structure<StructureFields.NodeOriginInfo> origin = this.getWcContext().getNodeOrigin(localAbsPath, false, StructureFields.NodeOriginInfo.isCopy, StructureFields.NodeOriginInfo.copyRootAbsPath, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.reposUuid, StructureFields.NodeOriginInfo.revision);
            File reposRelPath = (File)origin.get(StructureFields.NodeOriginInfo.reposRelpath);
            if (reposRelPath != null) {
                SVNURL rootURL = (SVNURL)origin.get(StructureFields.NodeOriginInfo.reposRootUrl);
                url = rootURL.appendPath(SVNFileUtil.getFilePath(reposRelPath), false);
                reposTarget = SvnTarget.fromURL(url);
                Structure<SvnRepositoryAccess.RevisionsPair> revisionPair = null;
                revisionPair = this.getRepositoryAccess().getRevisionNumber(null, target, target.getResolvedPegRevision(), revisionPair);
                long pegrevnum = revisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
                pegRevision = SVNRevision.create(pegrevnum);
                if (((SvnGetProperties)this.getOperation()).getRevision().isLocal()) {
                    revisionPair = this.getRepositoryAccess().getRevisionNumber(null, target, ((SvnGetProperties)this.getOperation()).getRevision(), revisionPair);
                    revnum = revisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
                    revision = SVNRevision.create(revnum);
                }
            }
        }
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(reposTarget, revision, pegRevision, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        revnum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        url = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
        repositoryInfo.release();
        SVNNodeKind kind = repository.checkPath("", revnum);
        if (kind == SVNNodeKind.UNKNOWN) {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown node kind for ''{0}''", (Object)repository.getLocation());
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (kind == null || kind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' does not exist in revision {1}", repository.getLocation(), revnum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (((SvnGetProperties)this.getOperation()).getTargetInheritedPropertiesReceiver() != null) {
            SVNURL repositoryRoot = repository.getRepositoryRoot(true);
            Map<String, SVNProperties> inheritedProperties = repository.getInheritedProperties("", revnum, null);
            ArrayList<SvnInheritedProperties> result = new ArrayList<SvnInheritedProperties>();
            for (String path : inheritedProperties.keySet()) {
                SvnInheritedProperties propItem = new SvnInheritedProperties();
                propItem.setTarget(SvnTarget.fromURL(repositoryRoot.appendPath(path, false)));
                propItem.setProperties(inheritedProperties.get(path));
                result.add(propItem);
            }
            if (!result.isEmpty()) {
                ((SvnGetProperties)this.getOperation()).getTargetInheritedPropertiesReceiver().receive(target, result);
            }
        }
        this.remotePropertyGet(url, kind, "", repository, revnum, ((SvnGetProperties)this.getOperation()).getDepth());
        return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
    }

    private void remotePropertyGet(SVNURL url, SVNNodeKind kind, String path, SVNRepository repos, long revNumber, SVNDepth depth) throws SVNException {
        SVNURL fullURL = url.appendPath(path, false);
        SVNProperties props = new SVNProperties();
        final LinkedList dirEntries = new LinkedList();
        if (kind == SVNNodeKind.DIR) {
            ISVNDirEntryHandler handler = SVNDepth.FILES.compareTo(depth) <= 0 ? new ISVNDirEntryHandler(){

                @Override
                public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                    dirEntries.add(dirEntry);
                }
            } : null;
            repos.getDir(path, revNumber, props, 1, handler);
        } else if (kind == SVNNodeKind.FILE) {
            repos.getFile(path, revNumber, props, null);
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown node kind for ''{0}''", (Object)fullURL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (props != null) {
            for (String name : new HashSet<String>(props.nameSet())) {
                if (SVNProperty.isRegularProperty(name)) continue;
                props.remove(name);
            }
            if (!props.isEmpty()) {
                ((SvnGetProperties)this.getOperation()).receive(SvnTarget.fromURL(fullURL), props);
            }
        }
        if (depth.compareTo(SVNDepth.EMPTY) > 0 && dirEntries != null && kind == SVNNodeKind.DIR) {
            for (SVNDirEntry entry : dirEntries) {
                if (entry.getKind() != SVNNodeKind.FILE && depth.compareTo(SVNDepth.FILES) <= 0) continue;
                String entryPath = SVNPathUtil.append(path, entry.getName());
                SVNDepth depthBelow = depth;
                if (depth == SVNDepth.IMMEDIATES) {
                    depthBelow = SVNDepth.EMPTY;
                }
                this.remotePropertyGet(url, entry.getKind(), entryPath, repos, revNumber, depthBelow);
            }
        }
    }
}

