/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.remote;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNDirEntry;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc2.SvnGetInfo;
import afu.org.tmatesoft.svn.core.wc2.SvnInfo;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SvnRemoteGetInfo
extends SvnRemoteOperationRunner<SvnInfo, SvnGetInfo> {
    @Override
    public boolean isApplicable(SvnGetInfo operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (super.isApplicable(operation, wcGeneration)) {
            return true;
        }
        SVNRevision revision = operation.getRevision();
        return !revision.isLocal();
    }

    @Override
    protected SvnInfo run() throws SVNException {
        SVNLock lock;
        SVNRevision pegRevision;
        SVNDepth depth;
        SVNDirEntry rootEntry;
        String repositoryUUID;
        SVNURL repositoryRootUrl;
        long revNum;
        SVNURL url;
        SVNRepository repository;
        block28: {
            SvnTarget infoTarget = ((SvnGetInfo)this.getOperation()).getFirstTarget();
            Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(infoTarget, ((SvnGetInfo)this.getOperation()).getRevision(), infoTarget.getResolvedPegRevision(), null);
            repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
            url = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
            revNum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
            repositoryRootUrl = repository.getRepositoryRoot(true);
            repositoryUUID = repository.getRepositoryUUID(true);
            repositoryInfo.release();
            SVNURL parentURL = url.removePathTail();
            String baseName = SVNPathUtil.tail(url.getPath());
            rootEntry = null;
            depth = ((SvnGetInfo)this.getOperation()).getDepth();
            pegRevision = infoTarget.getResolvedPegRevision();
            try {
                rootEntry = repository.info("", revNum);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                    SVNNodeKind urlKind;
                    if (url.equals(repositoryRootUrl)) {
                        if (depth.compareTo(SVNDepth.EMPTY) > 0) {
                            SVNLock[] locks = null;
                            if (pegRevision == SVNRevision.HEAD) {
                                try {
                                    locks = repository.getLocks("");
                                }
                                catch (SVNException svne) {
                                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                                    if (code == SVNErrorCode.RA_NOT_IMPLEMENTED || code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                                        locks = new SVNLock[]{};
                                    }
                                    throw svne;
                                }
                            } else {
                                locks = new SVNLock[]{};
                            }
                            locks = locks == null ? new SVNLock[]{} : locks;
                            HashMap<String, SVNLock> locksMap = new HashMap<String, SVNLock>();
                            for (int i = 0; i < locks.length; ++i) {
                                SVNLock lock2 = locks[i];
                                locksMap.put(lock2.getPath(), lock2);
                            }
                            this.pushDirInfo(repository, SVNRevision.create(revNum), "", repository.getRepositoryRoot(true), repositoryUUID, url, locksMap, depth);
                            return (SvnInfo)((SvnGetInfo)this.getOperation()).first();
                        }
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Server does not support retrieving information about the repository root");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if ((urlKind = repository.checkPath("", revNum)) == SVNNodeKind.NONE) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", url, new Long(revNum));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    SVNRepository parentRepository = this.getRepositoryAccess().createRepository(parentURL, null, false);
                    Collection<SVNDirEntry> dirEntries = parentRepository.getDir("", revNum, null, 57, (Collection)null);
                    for (SVNDirEntry dirEntry : dirEntries) {
                        if (!baseName.equals(dirEntry.getName())) continue;
                        rootEntry = dirEntry;
                        break;
                    }
                    if (rootEntry == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", url, new Long(revNum));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                throw e;
            }
            if (rootEntry == null || rootEntry.getKind() == SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", url, new Long(revNum));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            lock = null;
            if (rootEntry.getKind() == SVNNodeKind.FILE) {
                try {
                    Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(null, SvnTarget.fromURL(url), SVNRevision.create(revNum), SVNRevision.HEAD, SVNRevision.UNDEFINED);
                    if (locations == null || !locations.hasValue(SvnRepositoryAccess.LocationsInfo.startUrl)) break block28;
                    SVNURL headURL = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                    locations.release();
                    if (!headURL.equals(url)) break block28;
                    try {
                        lock = repository.getLock("");
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                            throw e;
                        }
                    }
                }
                catch (SVNException e) {
                    SVNErrorCode code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block28;
                    throw e;
                }
            }
        }
        SvnInfo info = this.creatSvnInfoForEntry(repositoryRootUrl, repositoryUUID, rootEntry, url, revNum, lock);
        ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromURL(url), info);
        if (depth.compareTo(SVNDepth.EMPTY) > 0 && rootEntry.getKind() == SVNNodeKind.DIR) {
            SVNLock[] locks = null;
            if (pegRevision == SVNRevision.HEAD) {
                try {
                    locks = repository.getLocks("");
                }
                catch (SVNException svne) {
                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.RA_NOT_IMPLEMENTED || code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                        locks = new SVNLock[]{};
                    }
                    throw svne;
                }
            } else {
                locks = new SVNLock[]{};
            }
            locks = locks == null ? new SVNLock[]{} : locks;
            HashMap<String, SVNLock> locksMap = new HashMap<String, SVNLock>();
            for (int i = 0; i < locks.length; ++i) {
                lock = locks[i];
                locksMap.put(lock.getPath(), lock);
            }
            this.pushDirInfo(repository, SVNRevision.create(revNum), "", repository.getRepositoryRoot(true), repositoryUUID, url, locksMap, depth);
        }
        return (SvnInfo)((SvnGetInfo)this.getOperation()).first();
    }

    private void pushDirInfo(SVNRepository repos, SVNRevision rev, String dir, SVNURL root, String uuid, SVNURL url, Map<String, SVNLock> locks, SVNDepth depth) throws SVNException {
        Collection<SVNDirEntry> children = repos.getDir(dir, rev.getNumber(), null, 59, new ArrayList());
        for (SVNDirEntry child : children) {
            SVNURL childURL = url.appendPath(child.getName(), false);
            String path = SVNPathUtil.append(dir, child.getName());
            String fsPath = "/" + SVNPathUtil.getRelativePath(root.toDecodedString(), childURL.toDecodedString());
            SVNLock lock = locks.get(fsPath);
            if (depth.compareTo(SVNDepth.IMMEDIATES) >= 0 || depth == SVNDepth.FILES && child.getKind() == SVNNodeKind.FILE) {
                SvnInfo info = this.creatSvnInfoForEntry(root, uuid, child, childURL, rev.getNumber(), lock);
                ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromURL(childURL), info);
            }
            if (depth != SVNDepth.INFINITY || child.getKind() != SVNNodeKind.DIR) continue;
            this.pushDirInfo(repos, rev, path, root, uuid, childURL, locks, depth);
        }
    }

    private SvnInfo creatSvnInfoForEntry(SVNURL root, String uuid, SVNDirEntry entry, SVNURL entryURL, long revision, SVNLock lock) {
        SvnInfo info = new SvnInfo();
        info.setKind(entry.getKind());
        info.setLastChangedAuthor(entry.getAuthor());
        info.setLastChangedDate(SVNDate.fromDate(entry.getDate()));
        info.setLastChangedRevision(entry.getRevision());
        info.setLock(lock);
        info.setRepositoryRootURL(root);
        info.setRepositoryUuid(uuid);
        info.setSize(entry.getSize());
        info.setUrl(entryURL);
        info.setRevision(revision);
        return info;
    }
}

