/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.patch;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import afu.org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.IOException;

public class SvnDiffHunk
implements Comparable<SvnDiffHunk> {
    private SvnPatch patch;
    private SVNPatchFileStream patchFileStream;
    private Range diffTextRange;
    private Range originalTextRange;
    private Range modifiedTextRange;
    private int originalStart;
    private int originalLength;
    private int modifiedStart;
    private int modifiedLength;
    private int leadingContext;
    private int trailingContext;

    public void resetDiffText() {
        this.diffTextRange.current = this.diffTextRange.start;
    }

    public void resetOriginalText() {
        if (this.patch.isReverse()) {
            this.modifiedTextRange.current = this.modifiedTextRange.start;
        } else {
            this.originalTextRange.current = this.originalTextRange.start;
        }
    }

    public void resetModifiedText() {
        if (this.patch.isReverse()) {
            this.originalTextRange.current = this.originalTextRange.start;
        } else {
            this.modifiedTextRange.current = this.modifiedTextRange.start;
        }
    }

    public int getDirectedOriginalStart() {
        return this.patch.isReverse() ? this.modifiedStart : this.originalStart;
    }

    public int getDirectedOriginalLength() {
        return this.patch.isReverse() ? this.modifiedLength : this.originalLength;
    }

    public int getDirectedModifiedStart() {
        return this.patch.isReverse() ? this.originalStart : this.modifiedStart;
    }

    public int getDirectedModifiedLength() {
        return this.patch.isReverse() ? this.originalLength : this.modifiedLength;
    }

    public int getLeadingContext() {
        return this.leadingContext;
    }

    public int getTrailingContext() {
        return this.trailingContext;
    }

    public void setOriginalStart(int originalStart) {
        this.originalStart = originalStart;
    }

    public void setOriginalLength(int originalLength) {
        this.originalLength = originalLength;
    }

    public void setModifiedStart(int modifiedStart) {
        this.modifiedStart = modifiedStart;
    }

    public void setModifiedLength(int modifiedLength) {
        this.modifiedLength = modifiedLength;
    }

    public void setDiffTextRange(Range diffTextRange) {
        this.diffTextRange = diffTextRange;
    }

    public void setOriginalTextRange(Range originalTextRange) {
        this.originalTextRange = originalTextRange;
    }

    public void setModifiedTextRange(Range modifiedTextRange) {
        this.modifiedTextRange = modifiedTextRange;
    }

    private int getOriginalStart() {
        return this.originalStart;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    private int getModifiedStart() {
        return this.modifiedStart;
    }

    public int getModifiedLength() {
        return this.modifiedLength;
    }

    public void setLeadingContext(int leadingContext) {
        this.leadingContext = leadingContext;
    }

    public void setTrailingContext(int trailingContext) {
        this.trailingContext = trailingContext;
    }

    public void setPatch(SvnPatch patch) {
        this.patch = patch;
    }

    public String readLineDiffText(String[] eolStr, boolean[] eof) throws IOException, SVNException {
        if (this.diffTextRange.current >= this.diffTextRange.end) {
            eof[0] = true;
            if (eolStr != null) {
                eolStr[0] = null;
            }
            return "";
        }
        long pos = this.patchFileStream.getSeekPosition();
        this.patchFileStream.setSeekPosition(this.diffTextRange.current);
        long maxLen = this.diffTextRange.end - this.diffTextRange.current;
        String line = this.readLine(this.patchFileStream, eolStr, eof);
        this.diffTextRange.current = 0L;
        this.diffTextRange.current = this.patchFileStream.getSeekPosition();
        this.patchFileStream.setSeekPosition(pos);
        if (this.patch.isReverse()) {
            if (line.startsWith("+")) {
                line = "-" + line.substring("+".length());
            } else if (line.startsWith("-")) {
                line = "+" + line.substring("-".length());
            }
        }
        return line;
    }

    public String readLineOriginalText(String[] eolStr, boolean[] eof) throws SVNException {
        return this.readLineOriginalOrModified(this.patch.isReverse() ? this.modifiedTextRange : this.originalTextRange, eolStr, eof, this.patch.isReverse() ? (char)'-' : '+');
    }

    public String readLineModifiedText(String[] eolStr, boolean[] eof) throws SVNException {
        return this.readLineOriginalOrModified(this.patch.isReverse() ? this.originalTextRange : this.modifiedTextRange, eolStr, eof, this.patch.isReverse() ? (char)'+' : '-');
    }

    private String readLineOriginalOrModified(Range range, String[] eolStr, boolean[] eof, char forbidden) throws SVNException {
        try {
            String str;
            boolean filtered;
            if (range.current >= range.end) {
                eof[0] = true;
                if (eolStr != null) {
                    eolStr[0] = null;
                }
                return "";
            }
            long pos = this.patchFileStream.getSeekPosition();
            this.patchFileStream.setSeekPosition(range.current);
            do {
                long maxLen = range.end - range.current;
                String oldEol = null;
                if (maxLen < 0L && eolStr != null) {
                    oldEol = eolStr[0];
                }
                str = this.readLine(this.patchFileStream, eolStr, eof);
                if (maxLen >= 0L && (long)str.length() >= maxLen) {
                    str = str.substring(0, (int)maxLen);
                    if (eolStr != null && eolStr[0] != null && !str.endsWith("\r") && !str.endsWith("\n")) {
                        eolStr[0] = null;
                    }
                    if (eof != null) {
                        eof[0] = maxLen == 0L;
                    }
                } else if (maxLen < 0L && eolStr != null) {
                    eolStr[0] = oldEol;
                }
                range.current = this.patchFileStream.getSeekPosition();
                boolean bl = filtered = str.length() > 0 && (str.charAt(0) == forbidden || str.charAt(0) == '\\');
            } while (filtered && !eof[0]);
            String result = filtered ? "" : (str.startsWith("+") || str.startsWith("-") || str.startsWith(" ") ? str.substring(1) : str);
            this.patchFileStream.setSeekPosition(pos);
            return result;
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
            return null;
        }
    }

    private String readLine(SVNPatchFileStream patchFileStream, String[] eolStr, boolean[] eof) throws IOException, SVNException {
        StringBuffer lineBuffer = new StringBuffer();
        StringBuffer eolStrBuffer = new StringBuffer();
        if (eof != null) {
            eof[0] = patchFileStream.readLineWithEol(lineBuffer, eolStrBuffer);
        }
        if (eolStr != null) {
            eolStr[0] = eolStrBuffer.length() == 0 ? null : eolStrBuffer.toString();
        }
        return lineBuffer.toString();
    }

    @Override
    public int compareTo(SvnDiffHunk diffHunk) {
        if (this.getOriginalStart() < diffHunk.getOriginalStart()) {
            return -1;
        }
        if (this.getOriginalStart() > diffHunk.getOriginalStart()) {
            return 1;
        }
        return 0;
    }

    public void setPatchFileStream(SVNPatchFileStream patchFileStream) {
        this.patchFileStream = patchFileStream;
    }

    public void decreaseOriginalLength() {
        --this.originalLength;
    }

    public void decreaseModifiedLength() {
        --this.modifiedLength;
    }

    static class Range {
        private long start;
        private long end;
        private long current;

        public Range(long start, long end, long current) {
            this.start = start;
            this.end = end;
            this.current = current;
        }
    }
}

