/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgLockUtil;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import afu.org.tmatesoft.svn.core.io.ISVNLockHandler;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc2.SvnUnlock;

public class SvnNgUnlock
extends SvnNgOperationRunner<SVNLock, SvnUnlock> {
    @Override
    protected SVNLock run(SVNWCContext context) throws SVNException {
        final SVNHashMap entriesMap = new SVNHashMap();
        SVNHashMap pathsRevisionsMap = new SVNHashMap();
        SvnNgRepositoryAccess wcAccess = this.getRepositoryAccess();
        SVNURL topURL = SvnNgLockUtil.collectLockInfo(this, this.getWcContext(), wcAccess, ((SvnUnlock)this.getOperation()).getTargets(), entriesMap, pathsRevisionsMap, false, ((SvnUnlock)this.getOperation()).isBreakLock());
        SVNRepository repository = this.getRepositoryAccess().createRepository(topURL, null, true);
        final SVNURL rootURL = repository.getRepositoryRoot(true);
        repository.unlock(pathsRevisionsMap, ((SvnUnlock)this.getOperation()).isBreakLock(), new ISVNLockHandler(){

            @Override
            public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            }

            @Override
            public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                SVNURL fullURL = rootURL.appendPath(path, false);
                SvnNgLockUtil.LockInfo lockInfo = (SvnNgLockUtil.LockInfo)entriesMap.get(fullURL);
                SVNEventAction action = null;
                if (error == null || error != null && error.getErrorCode() != SVNErrorCode.FS_LOCK_OWNER_MISMATCH) {
                    SvnNgUnlock.this.getWcContext().getDb().removeLock(lockInfo.getFile());
                    if (SvnNgUnlock.this.getWcContext().getProperty(lockInfo.getFile(), "svn:needs-lock") != null) {
                        SVNFileUtil.setReadonly(lockInfo.getFile(), true);
                    }
                    action = SVNEventAction.UNLOCKED;
                }
                if (error != null) {
                    action = SVNEventAction.UNLOCK_FAILED;
                }
                if (action != null) {
                    SvnNgUnlock.this.handleEvent(SVNEventFactory.createLockEvent(lockInfo.getFile(), action, lock, error), -1.0);
                }
            }
        });
        return (SVNLock)((SvnUnlock)this.getOperation()).first();
    }
}

