/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnLocalOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import afu.org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import afu.org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import afu.org.tmatesoft.svn.core.wc2.SvnOperation;
import java.io.File;
import java.util.Collection;

public abstract class SvnNgOperationRunner<V, T extends SvnOperation<V>>
extends SvnLocalOperationRunner<V, T> {
    private SvnNgRepositoryAccess repositoryAccess;

    @Override
    protected V run() throws SVNException {
        return this.run(this.getWcContext());
    }

    protected boolean matchesChangelist(File target) {
        return this.getWcContext().matchesChangelist(target, ((SvnOperation)this.getOperation()).getApplicableChangelists());
    }

    protected SvnNgRepositoryAccess getRepositoryAccess() throws SVNException {
        if (this.repositoryAccess == null) {
            this.repositoryAccess = new SvnNgRepositoryAccess((ISvnOperationOptionsProvider)this.getOperation(), this.getWcContext());
        }
        return this.repositoryAccess;
    }

    protected void setRepositoryAccess(SvnNgRepositoryAccess repositoryAccess) {
        this.repositoryAccess = repositoryAccess;
    }

    @Override
    protected abstract V run(SVNWCContext var1) throws SVNException;

    @Override
    public void reset(SvnWcGeneration wcGeneration) {
        super.reset(wcGeneration);
        this.repositoryAccess = null;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.V17;
    }

    protected void deleteDeleteFiles(SVNCommitter17 committer, ISvnCommitParameters parameters) {
        if (parameters == null) {
            return;
        }
        Collection<File> deletedPaths = committer.getDeletedPaths();
        for (File deletedPath : deletedPaths) {
            boolean delete = false;
            if (deletedPath.isFile()) {
                delete = parameters.onFileDeletion(deletedPath);
            } else if (deletedPath.isDirectory()) {
                delete = parameters.onDirectoryDeletion(deletedPath);
            }
            if (!delete) continue;
            SVNFileUtil.deleteAll(deletedPath, true);
        }
    }
}

