/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNMergeRange;
import afu.org.tmatesoft.svn.core.SVNMergeRangeList;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import afu.org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileType;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgReposToWcCopy;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import afu.org.tmatesoft.svn.core.wc.SVNConflictAction;
import afu.org.tmatesoft.svn.core.wc.SVNConflictChoice;
import afu.org.tmatesoft.svn.core.wc.SVNConflictDescription;
import afu.org.tmatesoft.svn.core.wc.SVNConflictReason;
import afu.org.tmatesoft.svn.core.wc.SVNConflictResult;
import afu.org.tmatesoft.svn.core.wc.SVNDiffOptions;
import afu.org.tmatesoft.svn.core.wc.SVNOperation;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import afu.org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class SvnNgMergeCallback
implements ISvnDiffCallback {
    private Collection<File> conflictedPaths;
    private SvnNgMergeDriver driver;

    public SvnNgMergeCallback(SvnNgMergeDriver driver) {
        this.driver = driver;
    }

    public Collection<File> getConflictedPaths() {
        return this.conflictedPaths;
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult result, File path, long revision) throws SVNException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(SvnDiffCallbackResult result, final File path, File tmpFile1, File tmpFile2, long rev1, long rev2, String mimetype1, String mimeType2, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.UNKNOWN);
        if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
            result.contentState = os.obstructionState;
            if (os.obstructionState == SVNStatusType.MISSING) {
                result.propState = SVNStatusType.MISSING;
            }
            return;
        }
        SVNNodeKind wcKind = os.kind;
        boolean isDeleted = os.deleted;
        if (wcKind != SVNNodeKind.FILE || isDeleted) {
            SVNDepth parentDepth;
            if (wcKind == SVNNodeKind.NONE && (parentDepth = this.getContext().getNodeDepth(SVNFileUtil.getParentFile(path))) != SVNDepth.UNKNOWN && parentDepth.compareTo(SVNDepth.FILES) < 0) {
                result.contentState = SVNStatusType.MISSING;
                result.propState = SVNStatusType.MISSING;
                return;
            }
            this.treeConflict(path, SVNNodeKind.FILE, SVNConflictAction.EDIT, SVNConflictReason.MISSING);
            result.treeConflicted = true;
            result.contentState = SVNStatusType.MISSING;
            result.propState = SVNStatusType.MISSING;
            return;
        }
        if (!propChanges.isEmpty()) {
            SVNWCContext.MergePropertiesInfo mergeOutcome = this.mergePropChanges(path, propChanges, originalProperties);
            SVNStatusType sVNStatusType = result.propState = mergeOutcome != null ? mergeOutcome.mergeOutcome : null;
            if (mergeOutcome != null && mergeOutcome.treeConflicted) {
                result.treeConflicted = true;
                return;
            }
        } else {
            result.propState = SVNStatusType.UNCHANGED;
        }
        if (this.isRecordOnly()) {
            result.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        if (tmpFile1 != null) {
            boolean hasLocalMods = this.getContext().isTextModified(path, false);
            String targetLabel = ".working";
            String leftLabel = ".merge-left.r" + rev1;
            String rightLabel = ".merge-right.r" + rev2;
            SVNConflictVersion[] cvs = this.makeConflictVersions(path, SVNNodeKind.FILE);
            ISVNOptions opts = this.getContext().getOptions();
            final ISVNConflictHandler[] conflictHandler = new ISVNConflictHandler[1];
            if (opts instanceof DefaultSVNOptions) {
                conflictHandler[0] = ((DefaultSVNOptions)opts).getConflictResolver();
                ((DefaultSVNOptions)opts).setConflictHandler(new ISVNConflictHandler(){

                    @Override
                    public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
                        SVNConflictResult result;
                        SVNConflictResult sVNConflictResult = result = conflictHandler[0] == null ? new SVNConflictResult(SVNConflictChoice.POSTPONE, null) : conflictHandler[0].handleConflict(conflictDescription);
                        if (result != null && result.getConflictChoice() == SVNConflictChoice.POSTPONE) {
                            if (SvnNgMergeCallback.this.conflictedPaths == null) {
                                SvnNgMergeCallback.this.conflictedPaths = new HashSet();
                            }
                            SvnNgMergeCallback.this.conflictedPaths.add(path);
                        }
                        return result;
                    }
                });
            }
            try {
                SVNWCContext.MergeInfo mergeOutcome = this.getContext().mergeText(tmpFile1, tmpFile2, path, leftLabel, rightLabel, targetLabel, cvs[0], cvs[1], this.isDryRun(), this.getDiffOptions(), propChanges);
                result.contentState = mergeOutcome.mergeOutcome == SVNStatusType.CONFLICTED ? SVNStatusType.CONFLICTED : (hasLocalMods && mergeOutcome.mergeOutcome != SVNStatusType.UNCHANGED ? SVNStatusType.MERGED : (mergeOutcome.mergeOutcome == SVNStatusType.MERGED ? SVNStatusType.CHANGED : (mergeOutcome.mergeOutcome == SVNStatusType.NO_MERGE ? SVNStatusType.MISSING : SVNStatusType.UNCHANGED)));
            }
            finally {
                if (opts instanceof DefaultSVNOptions) {
                    ((DefaultSVNOptions)opts).setConflictHandler(conflictHandler[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, long rev1, long rev2, String mimeType1, String mimeType2, File copyFromPath, long copyFromRevision, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        block22: {
            SVNNodeKind kind;
            block21: {
                if (this.isRecordOnly()) {
                    result.contentState = SVNStatusType.UNCHANGED;
                    result.propState = SVNStatusType.UNCHANGED;
                    return;
                }
                result.propState = SVNStatusType.UNKNOWN;
                SVNProperties fileProps = new SVNProperties(originalProperties);
                for (String propName : propChanges.nameSet()) {
                    if (SVNProperty.isWorkingCopyProperty(propName) || !this.isSameRepos() && !SVNProperty.isRegularProperty(propName) || !this.isSameRepos() && "svn:mergeinfo".equals(propName)) continue;
                    if (propChanges.getSVNPropertyValue(propName) != null) {
                        fileProps.put(propName, propChanges.getSVNPropertyValue(propName));
                        continue;
                    }
                    fileProps.remove(propName);
                }
                SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.UNKNOWN);
                if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
                    if (this.isDryRun() && this.getAddedPath() != null && SVNWCUtils.isChild(this.getAddedPath(), path)) {
                        result.contentState = SVNStatusType.CHANGED;
                        if (!fileProps.isEmpty()) {
                            result.propState = SVNStatusType.CHANGED;
                        }
                    } else {
                        result.contentState = os.obstructionState;
                    }
                    return;
                }
                kind = SVNFileType.getNodeKind(SVNFileType.getType(path));
                if (kind != SVNNodeKind.NONE) break block21;
                if (!this.isDryRun()) {
                    InputStream newContents;
                    InputStream newBaseContents;
                    block20: {
                        SVNURL copyFromUrl = null;
                        long copyFromRev = -1L;
                        newBaseContents = null;
                        newContents = null;
                        try {
                            SVNProperties newProps;
                            SVNProperties newBaseProps;
                            if (this.isSameRepos()) {
                                String child = SVNWCUtils.getPathAsChild(this.getTargetPath(), path);
                                copyFromUrl = child != null ? this.getSource2URL().appendPath(child, false) : this.getSource2URL();
                                copyFromRev = rev2;
                                this.checkReposMatch(path, copyFromUrl);
                                newBaseContents = SVNFileUtil.openFileForReading(rightFile);
                                newContents = null;
                                newBaseProps = fileProps;
                                newProps = null;
                            } else {
                                newBaseProps = new SVNProperties();
                                newProps = fileProps;
                                newBaseContents = SVNFileUtil.DUMMY_IN;
                                newContents = SVNFileUtil.openFileForReading(rightFile);
                            }
                            SVNTreeConflictDescription tc = this.getContext().getTreeConflict(path);
                            if (tc != null) {
                                this.treeConflictOnAdd(path, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                                result.treeConflicted = true;
                                break block20;
                            }
                            SvnNgReposToWcCopy.addFileToWc(this.getContext(), path, newBaseContents, newContents, newBaseProps, newProps, copyFromUrl, copyFromRev);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(newBaseContents);
                            SVNFileUtil.closeFile(newContents);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile(newBaseContents);
                    SVNFileUtil.closeFile(newContents);
                }
                result.contentState = SVNStatusType.CHANGED;
                if (!fileProps.isEmpty()) {
                    result.propState = SVNStatusType.CHANGED;
                }
                break block22;
            }
            if (kind == SVNNodeKind.DIR) {
                this.treeConflictOnAdd(path, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
                result.treeConflicted = true;
                SVNNodeKind wcKind = this.getContext().readKind(path, false);
                result.contentState = wcKind != SVNNodeKind.NONE && this.driver.isDryRunDeletion(path) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
            } else if (kind == SVNNodeKind.FILE) {
                if (this.driver.isDryRunDeletion(path)) {
                    result.contentState = SVNStatusType.CHANGED;
                } else {
                    this.treeConflictOnAdd(path, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                    result.treeConflicted = true;
                }
            } else {
                result.contentState = SVNStatusType.UNKNOWN;
            }
        }
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, String mimeType1, String mimeType2, SVNProperties originalProperties) throws SVNException {
        if (this.isDryRun()) {
            if (this.getDryRunDeletions() == null) {
                this.setDryRunDeletions(new HashSet<File>());
            }
            this.getDryRunDeletions().add(path);
        }
        if (this.isRecordOnly()) {
            result.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.UNKNOWN);
        if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
            result.contentState = os.obstructionState;
            return;
        }
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(path));
        if (kind == SVNNodeKind.FILE) {
            boolean same = this.compareFiles(leftFile, originalProperties, path);
            if (same || this.isForce() || this.isRecordOnly()) {
                if (!this.isDryRun()) {
                    SvnNgRemove.delete(this.getContext(), path, null, false, true, null);
                }
                result.contentState = SVNStatusType.CHANGED;
            } else {
                this.treeConflict(path, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
                result.treeConflicted = true;
                result.contentState = SVNStatusType.OBSTRUCTED;
            }
        } else if (kind == SVNNodeKind.DIR) {
            this.treeConflict(path, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.OBSTRUCTED);
            result.treeConflicted = true;
            result.contentState = SVNStatusType.OBSTRUCTED;
        } else if (kind == SVNNodeKind.NONE) {
            this.treeConflict(path, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            result.treeConflicted = true;
            result.contentState = SVNStatusType.MISSING;
        } else {
            result.contentState = SVNStatusType.UNKNOWN;
        }
    }

    private void setDryRunDeletions(Collection<File> set) {
        this.driver.dryRunDeletions = set;
    }

    private void setDryRunAddtions(Collection<File> set) {
        this.driver.dryRunAdded = set;
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult result, File path) throws SVNException {
        boolean isVersioned;
        if (this.isRecordOnly()) {
            result.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.UNKNOWN);
        boolean bl = isVersioned = os.kind == SVNNodeKind.DIR || os.kind == SVNNodeKind.FILE;
        if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
            result.contentState = os.obstructionState;
            return;
        }
        if (os.deleted) {
            os.kind = SVNNodeKind.NONE;
        }
        if (this.isDryRun()) {
            if (this.getDryRunDeletions() == null) {
                this.setDryRunDeletions(new HashSet<File>());
            }
            this.getDryRunDeletions().add(path);
        }
        if (os.kind == SVNNodeKind.DIR) {
            if (isVersioned && !os.deleted) {
                try {
                    if (!this.isForce()) {
                        SvnNgRemove.checkCanDelete(this.driver.operation.getOperationFactory(), this.getContext(), path);
                    }
                    if (!this.isDryRun()) {
                        SvnNgRemove.delete(this.getContext(), path, null, false, false, null);
                    }
                    result.contentState = SVNStatusType.CHANGED;
                }
                catch (SVNException e) {
                    this.treeConflict(path, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
                    result.treeConflicted = true;
                    result.contentState = SVNStatusType.CONFLICTED;
                }
            } else {
                this.treeConflict(path, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
                result.treeConflicted = true;
            }
        } else if (os.kind == SVNNodeKind.FILE) {
            result.contentState = SVNStatusType.OBSTRUCTED;
        } else if (os.kind == SVNNodeKind.NONE) {
            this.treeConflict(path, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            result.treeConflicted = true;
            result.contentState = SVNStatusType.MISSING;
        } else {
            result.contentState = SVNStatusType.UNKNOWN;
        }
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult result, File path, long revision) throws SVNException {
        SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.UNKNOWN);
        if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
            result.skipChildren = true;
            return;
        }
        if (os.kind != SVNNodeKind.DIR || os.deleted) {
            SVNDepth parentDepth;
            if (os.kind == SVNNodeKind.NONE && (parentDepth = this.getContext().getNodeDepth(SVNFileUtil.getParentFile(path))) != SVNDepth.UNKNOWN && parentDepth.compareTo(SVNDepth.IMMEDIATES) < 0) {
                result.skipChildren = true;
                return;
            }
            if (os.kind == SVNNodeKind.FILE) {
                this.treeConflict(path, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.REPLACED);
                result.treeConflicted = true;
            } else if (os.deleted || os.kind == SVNNodeKind.NONE) {
                this.treeConflict(path, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.DELETED);
                result.treeConflicted = true;
            }
        }
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult result, File path, long revision, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNWCContext.SVNWCNodeReposInfo reposInfo;
        SVNFileType diskKind;
        boolean isVersioned;
        if (this.isRecordOnly()) {
            result.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        File parentPath = SVNFileUtil.getParentFile(path);
        String child = SVNWCUtils.getPathAsChild(this.getTargetPath(), path);
        SVNURL copyFromUrl = null;
        long copyFromRev = -1L;
        if (this.isSameRepos()) {
            copyFromUrl = this.getSource2URL().appendPath(child, false);
            copyFromRev = revision;
            this.checkReposMatch(parentPath, copyFromUrl);
        }
        SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.UNKNOWN);
        boolean bl = isVersioned = os.kind == SVNNodeKind.DIR || os.kind == SVNNodeKind.FILE;
        if (os.obstructionState == SVNStatusType.OBSTRUCTED && (os.deleted || os.kind == SVNNodeKind.NONE) && (diskKind = SVNFileType.getType(path)) == SVNFileType.DIRECTORY) {
            os.obstructionState = SVNStatusType.INAPPLICABLE;
            os.kind = SVNNodeKind.DIR;
        }
        if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
            result.contentState = this.isDryRun() && this.getAddedPath() != null && SVNWCUtils.isChild(this.getAddedPath(), path) ? SVNStatusType.CHANGED : os.obstructionState;
            return;
        }
        if (os.deleted) {
            os.kind = SVNNodeKind.NONE;
        }
        if (os.kind == SVNNodeKind.NONE) {
            if (this.isDryRun()) {
                if (this.getDryRunAdditions() == null) {
                    this.setDryRunAddtions(new HashSet<File>());
                }
                this.getDryRunAdditions().add(path);
                this.setAddedPath(path);
            } else {
                path.mkdir();
                if (copyFromUrl != null) {
                    reposInfo = this.getContext().getNodeReposInfo(parentPath);
                    File reposRelPath = new File(SVNURLUtil.getRelativeURL(reposInfo.reposRootUrl, copyFromUrl, false));
                    this.getContext().getDb().opCopyDir(path, new SVNProperties(), copyFromRev, new SVNDate(0L, 0), null, reposRelPath, reposInfo.reposRootUrl, reposInfo.reposUuid, copyFromRev, null, false, SVNDepth.INFINITY, null, null);
                } else {
                    this.getContext().getDb().opAddDirectory(path, null, null);
                }
            }
            result.contentState = SVNStatusType.CHANGED;
        } else if (os.kind == SVNNodeKind.DIR) {
            if (!isVersioned || os.deleted) {
                if (!this.isDryRun()) {
                    if (copyFromUrl != null) {
                        reposInfo = this.getContext().getNodeReposInfo(parentPath);
                        File reposRelPath = new File(SVNURLUtil.getRelativeURL(reposInfo.reposRootUrl, copyFromUrl, false));
                        this.getContext().getDb().opCopyDir(path, new SVNProperties(), copyFromRev, new SVNDate(0L, 0), null, reposRelPath, reposInfo.reposRootUrl, reposInfo.reposUuid, copyFromRev, null, false, SVNDepth.INFINITY, null, null);
                    } else {
                        this.getContext().getDb().opAddDirectory(path, null, null);
                    }
                } else {
                    this.setAddedPath(path);
                }
                result.contentState = SVNStatusType.CHANGED;
            } else if (this.driver.isDryRunDeletion(path)) {
                result.contentState = SVNStatusType.CHANGED;
            } else {
                this.treeConflictOnAdd(path, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                result.treeConflicted = true;
                result.contentState = SVNStatusType.OBSTRUCTED;
            }
        } else if (os.kind == SVNNodeKind.FILE) {
            if (this.isDryRun()) {
                this.setAddedPath(null);
            }
            if (isVersioned && this.driver.isDryRunDeletion(path)) {
                result.contentState = SVNStatusType.CHANGED;
            } else {
                this.treeConflictOnAdd(path, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
                result.treeConflicted = true;
                result.contentState = SVNStatusType.OBSTRUCTED;
            }
        } else {
            if (this.isDryRun()) {
                this.setAddedPath(null);
            }
            result.contentState = SVNStatusType.UNKNOWN;
        }
    }

    @Override
    public void dirPropsChanged(SvnDiffCallbackResult result, File path, boolean isAdded, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        SvnNgMergeDriver.ObstructionState os = this.driver.performObstructionCheck(path, SVNNodeKind.DIR);
        if (os.obstructionState != SVNStatusType.INAPPLICABLE) {
            result.propState = os.obstructionState;
            return;
        }
        if (isAdded && this.isDryRun() && this.driver.isDryRunAddition(path)) {
            return;
        }
        SVNWCContext.MergePropertiesInfo info = this.mergePropChanges(path, propChanges, originalProperties);
        result.treeConflicted = info != null ? info.treeConflicted : false;
        result.propState = info != null ? info.mergeOutcome : null;
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult result, File path, boolean isAdded) throws SVNException {
        if (this.isDryRun() && this.getDryRunDeletions() != null) {
            this.getDryRunDeletions().clear();
        }
    }

    private void checkReposMatch(File path, SVNURL url) throws SVNException {
        if (!SVNURLUtil.isAncestor(this.getReposRootURL(), url)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Url ''{0}'' of ''{1}'' is not in repository ''{2}''", url, path, this.getReposRootURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private SVNWCContext.MergePropertiesInfo mergePropChanges(File localAbsPath, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        SVNProperties props = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(propChanges, props, null, null);
        if (this.isRecordOnly() && !props.isEmpty()) {
            SVNProperties mergeinfoProps = new SVNProperties();
            if (props.containsName("svn:mergeinfo")) {
                mergeinfoProps.put("svn:mergeinfo", props.getStringValue("svn:mergeinfo"));
            }
            props = mergeinfoProps;
        }
        SVNWCContext.MergePropertiesInfo mergeOutcome = null;
        if (!props.isEmpty()) {
            if (this.getSource1Rev() < this.getSource2Rev() || !this.areSourcesAncestral()) {
                props = this.filterSelfReferentialMergeInfo(props, localAbsPath, this.isHonorMergeInfo(), this.isSameRepos(), this.isReintegrateMerge(), this.getRepos2());
            }
            SVNException err = null;
            try {
                mergeOutcome = this.getContext().mergeProperties(localAbsPath, null, null, originalProperties, props, this.isDryRun(), this.getContext().getOptions().getConflictResolver());
            }
            catch (SVNException e) {
                err = e;
            }
            if (!this.isDryRun()) {
                for (String propName : props.nameSet()) {
                    if (!"svn:mergeinfo".equals(propName)) continue;
                    SVNProperties pristineProps = this.getContext().getPristineProps(localAbsPath);
                    boolean hasPristineMergeInfo = false;
                    if (pristineProps != null && pristineProps.containsName("svn:mergeinfo")) {
                        hasPristineMergeInfo = true;
                    }
                    if (!hasPristineMergeInfo && props.getSVNPropertyValue(propName) != null) {
                        this.addPathWithAddedMergeInfo(localAbsPath);
                        continue;
                    }
                    if (!hasPristineMergeInfo || props.getSVNPropertyValue(propName) != null) continue;
                    this.addPathWithDeletedMergeInfo(localAbsPath);
                }
            }
            if (err != null && (err.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || err.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_UNEXPECTED_STATUS)) {
                if (mergeOutcome != null) {
                    mergeOutcome.mergeOutcome = SVNStatusType.MISSING;
                    mergeOutcome.treeConflicted = true;
                }
            } else if (err != null) {
                throw err;
            }
        }
        return mergeOutcome;
    }

    private void addPathWithAddedMergeInfo(File localAbsPath) {
        if (this.driver.pathsWithNewMergeInfo == null) {
            this.driver.pathsWithNewMergeInfo = new HashSet<File>();
        }
        this.driver.pathsWithNewMergeInfo.add(localAbsPath);
    }

    private void addPathWithDeletedMergeInfo(File localAbsPath) {
        if (this.driver.pathsWithDeletedMergeInfo == null) {
            this.driver.pathsWithDeletedMergeInfo = new HashSet<File>();
        }
        this.driver.pathsWithDeletedMergeInfo.add(localAbsPath);
    }

    private SVNProperties filterSelfReferentialMergeInfo(SVNProperties props, File localAbsPath, boolean honorMergeInfo, boolean sameRepos, boolean reintegrateMerge, SVNRepository repos) throws SVNException {
        if (!sameRepos) {
            return SvnNgMergeCallback.omitMergeInfoChanges(props);
        }
        if (!honorMergeInfo && !reintegrateMerge) {
            return props;
        }
        boolean isAdded = this.getContext().isNodeAdded(localAbsPath);
        if (isAdded) {
            return props;
        }
        long baseRevision = this.getContext().getNodeBaseRev(localAbsPath);
        SVNProperties adjustedProps = new SVNProperties();
        for (String propName : props.nameSet()) {
            if (!"svn:mergeinfo".equals(propName) || props.getSVNPropertyValue(propName) == null || "".equals(props.getSVNPropertyValue(propName))) {
                adjustedProps.put(propName, props.getSVNPropertyValue(propName));
                continue;
            }
            SVNURL targetUrl = this.getContext().getUrlFromPath(localAbsPath);
            SVNURL oldUrl = repos.getLocation();
            repos.setLocation(targetUrl, false);
            String mi = props.getStringValue(propName);
            Map<String, SVNMergeRangeList> mergeinfo = null;
            Map<String, SVNMergeRangeList> filteredYoungerMergeinfo = null;
            Map<String, SVNMergeRangeList> filteredMergeinfo = null;
            try {
                mergeinfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mi), null);
            }
            catch (SVNException e) {
                adjustedProps.put(propName, props.getSVNPropertyValue(propName));
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    repos.setLocation(oldUrl, false);
                    continue;
                }
                throw e;
            }
            Map<String, SVNMergeRangeList>[] splitted = this.splitMergeInfoOnRevision(mergeinfo, baseRevision);
            Map<String, SVNMergeRangeList> youngerMergeInfo = splitted[0];
            mergeinfo = splitted[1];
            if (youngerMergeInfo != null) {
                SVNURL mergeSourceRootUrl = repos.getRepositoryRoot(true);
                for (String sourcePath : youngerMergeInfo.keySet()) {
                    SVNMergeRangeList rangeList = youngerMergeInfo.get(sourcePath);
                    SVNMergeRange[] ranges = rangeList.getRanges();
                    ArrayList<SVNMergeRange> adjustedRanges = new ArrayList<SVNMergeRange>();
                    SVNURL mergeSourceURL = mergeSourceRootUrl.appendPath(sourcePath, false);
                    for (int i = 0; i < ranges.length; ++i) {
                        SVNMergeRange range = ranges[i];
                        Structure<SvnRepositoryAccess.LocationsInfo> locations = null;
                        try {
                            locations = new SvnNgRepositoryAccess(null, this.getContext()).getLocations(repos, SvnTarget.fromURL(targetUrl), SVNRevision.create(baseRevision), SVNRevision.create(range.getStartRevision() + 1L), SVNRevision.UNDEFINED);
                            SVNURL startURL = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                            if (!mergeSourceURL.equals(startURL)) {
                                adjustedRanges.add(range);
                            }
                            locations.release();
                            continue;
                        }
                        catch (SVNException svne) {
                            SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                            if (code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || code == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.FS_NO_SUCH_REVISION) {
                                adjustedRanges.add(range);
                                continue;
                            }
                            throw svne;
                        }
                    }
                    if (adjustedRanges.isEmpty()) continue;
                    if (filteredYoungerMergeinfo == null) {
                        filteredYoungerMergeinfo = new TreeMap<String, SVNMergeRangeList>();
                    }
                    SVNMergeRangeList adjustedRangeList = SVNMergeRangeList.fromCollection(adjustedRanges);
                    filteredYoungerMergeinfo.put(sourcePath, adjustedRangeList);
                }
            }
            if (mergeinfo != null && !mergeinfo.isEmpty()) {
                Map<String, SVNMergeRangeList> implicitMergeInfo = this.getRepositoryAccess().getHistoryAsMergeInfo(this.getRepos2(), SvnTarget.fromFile(localAbsPath), baseRevision, -1L);
                filteredMergeinfo = SVNMergeInfoUtil.removeMergeInfo(implicitMergeInfo, mergeinfo, true);
            }
            if (oldUrl != null) {
                repos.setLocation(oldUrl, false);
            }
            if (filteredMergeinfo != null && filteredYoungerMergeinfo != null) {
                filteredMergeinfo = SVNMergeInfoUtil.mergeMergeInfos(filteredMergeinfo, filteredYoungerMergeinfo);
            } else if (filteredYoungerMergeinfo != null) {
                filteredMergeinfo = filteredYoungerMergeinfo;
            }
            if (filteredMergeinfo == null || filteredMergeinfo.isEmpty()) continue;
            String filteredMergeInfoStr = SVNMergeInfoUtil.formatMergeInfoToString(filteredMergeinfo, null);
            adjustedProps.put("svn:mergeinfo", filteredMergeInfoStr);
        }
        return adjustedProps;
    }

    private Map<String, SVNMergeRangeList>[] splitMergeInfoOnRevision(Map<String, SVNMergeRangeList> mergeinfo, long revision) {
        TreeMap<String, SVNMergeRangeList> youngerMergeinfo = null;
        block0: for (String path : new HashSet<String>(mergeinfo.keySet())) {
            SVNMergeRangeList rl = mergeinfo.get(path);
            for (int i = 0; i < rl.getSize(); ++i) {
                SVNMergeRange r = rl.getRanges()[i];
                if (r.getEndRevision() <= revision) continue;
                SVNMergeRangeList youngerRl = new SVNMergeRangeList(new SVNMergeRange[0]);
                for (int j = 0; j < rl.getSize(); ++j) {
                    SVNMergeRange r2 = rl.getRanges()[j];
                    SVNMergeRange youngerRange = r2.dup();
                    if (i == j && r.getStartRevision() + 1L <= revision) {
                        youngerRange.setStartRevision(revision);
                        r.setEndRevision(revision);
                    }
                    youngerRl.pushRange(youngerRange.getStartRevision(), youngerRange.getEndRevision(), youngerRange.isInheritable());
                }
                if (youngerMergeinfo == null) {
                    youngerMergeinfo = new TreeMap<String, SVNMergeRangeList>();
                }
                youngerMergeinfo.put(path, youngerRl);
                mergeinfo = SVNMergeInfoUtil.removeMergeInfo(youngerMergeinfo, mergeinfo, true);
                continue block0;
            }
        }
        Map[] result = new Map[]{youngerMergeinfo, mergeinfo};
        return result;
    }

    protected static SVNProperties omitMergeInfoChanges(SVNProperties props) {
        SVNProperties result = new SVNProperties();
        for (String name : props.nameSet()) {
            if ("svn:mergeinfo".equals(name)) continue;
            SVNPropertyValue pv = props.getSVNPropertyValue(name);
            result.put(name, pv);
        }
        return result;
    }

    private boolean isHonorMergeInfo() {
        return this.driver.isHonorMergeInfo();
    }

    private SVNConflictVersion[] makeConflictVersions(File target, SVNNodeKind kind) throws SVNException {
        SVNURL rightUrl;
        SVNURL leftUrl;
        SVNURL srcReposUrl = this.getRepos1().getRepositoryRoot(true);
        String child = SVNWCUtils.getPathAsChild(this.getTargetPath(), target);
        if (child != null) {
            leftUrl = this.getSource1URL().appendPath(child, false);
            rightUrl = this.getSource2URL().appendPath(child, false);
        } else {
            leftUrl = this.getSource1URL();
            rightUrl = this.getSource2URL();
        }
        String leftPath = SVNWCUtils.isChild(srcReposUrl, leftUrl);
        String rightPath = SVNWCUtils.isChild(srcReposUrl, rightUrl);
        SVNConflictVersion lv = new SVNConflictVersion(srcReposUrl, leftPath, this.getSource1Rev(), kind);
        SVNConflictVersion rv = new SVNConflictVersion(srcReposUrl, rightPath, this.getSource2Rev(), kind);
        return new SVNConflictVersion[]{lv, rv};
    }

    private void treeConflictOnAdd(File path, SVNNodeKind kind, SVNConflictAction action, SVNConflictReason reason) throws SVNException {
        if (this.isRecordOnly() || this.isDryRun()) {
            return;
        }
        SVNTreeConflictDescription tc = this.makeTreeConflict(path, kind, action, reason);
        SVNTreeConflictDescription existingTc = this.getContext().getTreeConflict(path);
        if (existingTc == null) {
            this.getContext().getDb().opSetTreeConflict(path, tc);
            if (this.conflictedPaths == null) {
                this.conflictedPaths = new HashSet<File>();
            }
            this.conflictedPaths.add(path);
        } else if (existingTc.getConflictAction() == SVNConflictAction.DELETE && tc.getConflictAction() == SVNConflictAction.ADD) {
            existingTc.setConflictAction(SVNConflictAction.REPLACE);
            this.getContext().getDb().opSetTreeConflict(path, existingTc);
        }
    }

    private SVNTreeConflictDescription makeTreeConflict(File path, SVNNodeKind kind, SVNConflictAction action, SVNConflictReason reason) throws SVNException {
        SVNConflictVersion[] cvs = this.makeConflictVersions(path, kind);
        SVNTreeConflictDescription tc = new SVNTreeConflictDescription(path, kind, action, reason, SVNOperation.MERGE, cvs[0], cvs[1]);
        return tc;
    }

    private void treeConflict(File path, SVNNodeKind kind, SVNConflictAction action, SVNConflictReason reason) throws SVNException {
        if (this.isRecordOnly() || this.isDryRun()) {
            return;
        }
        SVNTreeConflictDescription tc = this.getContext().getTreeConflict(path);
        if (tc == null) {
            tc = this.makeTreeConflict(path, kind, action, reason);
            this.getContext().getDb().opSetTreeConflict(path, tc);
            if (this.conflictedPaths == null) {
                this.conflictedPaths = new HashSet<File>();
            }
            this.conflictedPaths.add(path);
        }
    }

    private boolean compareProps(SVNProperties p1, SVNProperties p2) throws SVNException {
        if (p1 == null || p2 == null) {
            return p1 == p2;
        }
        SVNProperties diff = p1.compareTo(p2);
        for (String propName : diff.nameSet()) {
            if (!SVNProperty.isRegularProperty(propName) || "svn:mergeinfo".equals(propName)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareFiles(File oldPath, SVNProperties oldProps, File minePath) throws SVNException {
        SVNProperties workingProperties = this.getContext().getActualProps(minePath);
        boolean same = this.compareProps(oldProps, workingProperties);
        if (same) {
            InputStream is = null;
            InputStream old = null;
            try {
                is = workingProperties != null && workingProperties.getStringValue("svn:special") != null ? SVNFileUtil.readSymlink(minePath) : this.getContext().getTranslatedStream(minePath, minePath, true, false);
                old = SVNFileUtil.openFileForReading(oldPath);
                same = SVNFileUtil.compare(is, old);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(old);
                throw throwable;
            }
            SVNFileUtil.closeFile(is);
            SVNFileUtil.closeFile(old);
        }
        return same;
    }

    private SVNWCContext getContext() {
        return this.driver.context;
    }

    private boolean isReintegrateMerge() {
        return this.driver.reintegrateMerge;
    }

    private boolean isRecordOnly() {
        return this.driver.recordOnly;
    }

    private boolean isDryRun() {
        return this.driver.dryRun;
    }

    private boolean isForce() {
        return this.driver.forceDelete;
    }

    private boolean isSameRepos() {
        return this.driver.sameRepos;
    }

    private SVNDiffOptions getDiffOptions() {
        return this.driver.diffOptions;
    }

    private File getAddedPath() {
        return this.driver.addedPath;
    }

    private void setAddedPath(File path) {
        this.driver.addedPath = path;
    }

    private boolean areSourcesAncestral() {
        return this.driver.sourcesAncestral;
    }

    private File getTargetPath() {
        return this.driver.targetAbsPath;
    }

    private SVNRepository getRepos1() {
        return this.driver.repos1;
    }

    private SVNRepository getRepos2() {
        return this.driver.repos2;
    }

    private SVNURL getReposRootURL() {
        return this.driver.reposRootUrl;
    }

    private SvnRepositoryAccess getRepositoryAccess() {
        return this.driver.repositoryAccess;
    }

    private SVNURL getSource1URL() {
        return this.driver.mergeSource.url1;
    }

    private SVNURL getSource2URL() {
        return this.driver.mergeSource.url2;
    }

    private long getSource1Rev() {
        return this.driver.mergeSource.rev1;
    }

    private long getSource2Rev() {
        return this.driver.mergeSource.rev2;
    }

    private Collection<File> getDryRunDeletions() {
        return this.driver.dryRunDeletions;
    }

    private Collection<File> getDryRunAdditions() {
        return this.driver.dryRunAdded;
    }
}

