/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc17.db.statement;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import afu.org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import java.util.HashSet;
import java.util.Set;

public class SVNWCDbSelectMinMaxRevisions
extends SVNSqlJetSelectStatement {
    private long minRevision = -1L;
    private long maxRevision = -1L;
    private long minChangedRevision = -1L;
    private long maxChangedRevision = -1L;
    private Set<ISVNWCDb.SVNWCDbStatus> expectedPresence = new HashSet<ISVNWCDb.SVNWCDbStatus>(2);

    public SVNWCDbSelectMinMaxRevisions(SVNSqlJetDb sDb) throws SVNException {
        super(sDb, SVNWCDbSchema.NODES);
        this.expectedPresence.add(ISVNWCDb.SVNWCDbStatus.Normal);
        this.expectedPresence.add(ISVNWCDb.SVNWCDbStatus.Incomplete);
    }

    @Override
    public void reset() throws SVNException {
        super.reset();
        this.maxChangedRevision = -1L;
        this.minChangedRevision = -1L;
        this.maxRevision = -1L;
        this.minRevision = -1L;
    }

    public long getMinRevision() {
        return this.minRevision;
    }

    public long getMaxRevision() {
        return this.maxRevision;
    }

    public long getMinChangedRevision() {
        return this.minChangedRevision;
    }

    public long getMaxChangedRevision() {
        return this.maxChangedRevision;
    }

    @Override
    public boolean next() throws SVNException {
        boolean next = false;
        while (super.next()) {
            next = true;
            long revision = this.getColumnLong(SVNWCDbSchema.NODES__Fields.revision);
            if (this.minRevision == -1L || revision < this.minRevision) {
                this.minRevision = revision;
            }
            if (this.maxRevision == -1L || revision > this.maxRevision) {
                this.maxRevision = revision;
            }
            long changedRevision = this.getColumnLong(SVNWCDbSchema.NODES__Fields.changed_revision);
            if (this.minChangedRevision == -1L || changedRevision < this.minChangedRevision) {
                this.minChangedRevision = changedRevision;
            }
            if (this.maxChangedRevision != -1L && changedRevision <= this.maxChangedRevision) continue;
            this.maxChangedRevision = changedRevision;
        }
        return next;
    }

    @Override
    protected String getPathScope() {
        return (String)this.getBind(2);
    }

    @Override
    protected boolean isStrictiDescendant() {
        return false;
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        return this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) == 0L && this.expectedPresence.contains((Object)SvnWcDbStatementUtil.getColumnPresence(this)) && this.isColumnNull(SVNWCDbSchema.NODES__Fields.file_external);
    }

    @Override
    protected Object[] getWhere() throws SVNException {
        return new Object[]{this.getBind(1)};
    }
}

