/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc17;

import afu.de.regnis.q.sequence.line.QSequenceLineRAFileData;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.internal.util.SVNSkel;
import afu.org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import afu.org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import afu.org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import afu.org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import afu.org.tmatesoft.svn.core.wc.SVNDiffOptions;
import afu.org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import afu.org.tmatesoft.svn.core.wc.SVNMergeResult;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import afu.org.tmatesoft.svn.core.wc2.ISvnMerger;
import afu.org.tmatesoft.svn.core.wc2.SvnMergeResult;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class DefaultSvnMerger
implements ISvnMerger {
    private final SVNWCContext context;
    private SVNSkel workItems;

    public DefaultSvnMerger(SVNWCContext context) {
        this.context = context;
    }

    public SVNSkel getWorkItems() {
        return this.workItems;
    }

    @Override
    public SVNMergeResult mergeText(SVNMergeFileSet files, boolean dryRun, SVNDiffOptions options) throws SVNException {
        return null;
    }

    @Override
    public SVNMergeResult mergeProperties(String localPath, SVNProperties workingProperties, SVNProperties baseProperties, SVNProperties serverBaseProps, SVNProperties propDiff, SVNAdminArea adminArea, SVNLog log, boolean baseMerge, boolean dryRun) throws SVNException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SvnMergeResult mergeText(ISvnMerger baseMerger, File resultFile, File targetAbspath, File detranslatedTargetAbspath, File leftAbspath, File rightAbspath, String targetLabel, String leftLabel, String rightLabel, SVNDiffOptions options, SVNDiffConflictChoiceStyle style) throws SVNException {
        SVNWCContext.ConflictMarkersInfo markersInfo = this.context.initConflictMarkers(targetLabel, leftLabel, rightLabel);
        String targetMarker = markersInfo.targetMarker;
        String leftMarker = markersInfo.leftMarker;
        String rightMarker = markersInfo.rightMarker;
        FSMergerBySequence merger = new FSMergerBySequence(targetMarker.getBytes(), SVNWCContext.CONFLICT_SEPARATOR, rightMarker.getBytes(), leftMarker.getBytes());
        int mergeResult = 0;
        RandomAccessFile localIS = null;
        RandomAccessFile latestIS = null;
        RandomAccessFile baseIS = null;
        OutputStream result = null;
        try {
            result = SVNFileUtil.openFileForWriting(resultFile);
            localIS = new RandomAccessFile(detranslatedTargetAbspath, "r");
            latestIS = new RandomAccessFile(rightAbspath, "r");
            baseIS = new RandomAccessFile(leftAbspath, "r");
            QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
            QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
            QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
            mergeResult = merger.merge(baseData, localData, latestData, options, result, style);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(result);
                SVNFileUtil.closeFile(localIS);
                SVNFileUtil.closeFile(baseIS);
                SVNFileUtil.closeFile(latestIS);
                throw throwable;
            }
            SVNFileUtil.closeFile(result);
            SVNFileUtil.closeFile(localIS);
            SVNFileUtil.closeFile(baseIS);
            SVNFileUtil.closeFile(latestIS);
        }
        SVNFileUtil.closeFile(result);
        SVNFileUtil.closeFile(localIS);
        SVNFileUtil.closeFile(baseIS);
        SVNFileUtil.closeFile(latestIS);
        if (mergeResult == 2) {
            return SvnMergeResult.create(SVNStatusType.CONFLICTED);
        }
        return SvnMergeResult.create(SVNStatusType.MERGED);
    }

    @Override
    public SvnMergeResult mergeProperties(ISvnMerger baseMerger, File localAbsPath, SVNNodeKind kind, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion, SVNProperties serverBaseProperties, SVNProperties pristineProperties, SVNProperties actualProperties, SVNProperties propChanges, boolean baseMerge, boolean dryRun, ISVNConflictHandler conflictResolver) throws SVNException {
        SVNWCContext.MergePropertiesInfo mergePropertiesInfo = new SVNWCContext.MergePropertiesInfo();
        mergePropertiesInfo = this.context.mergeProperties3(mergePropertiesInfo, localAbsPath, serverBaseProperties, pristineProperties, actualProperties, propChanges);
        SvnMergeResult result = new SvnMergeResult(mergePropertiesInfo.mergeOutcome);
        if (dryRun) {
            return SvnMergeResult.create(mergePropertiesInfo.mergeOutcome);
        }
        result.setActualProperties(mergePropertiesInfo.newActualProperties);
        result.setBaseProperties(mergePropertiesInfo.newBaseProperties);
        SVNSkel conflictSkel = mergePropertiesInfo.conflictSkel;
        SVNSkel workItems = null;
        if (conflictSkel != null) {
            SvnWcDbConflicts.conflictSkelOpMerge(conflictSkel, leftVersion, rightVersion);
            SVNSkel workItem = SvnWcDbConflicts.createConflictMarkers(this.context.getDb(), localAbsPath, conflictSkel);
            workItems = SVNWCContext.wqMerge(workItems, workItem);
        }
        this.workItems = workItems;
        result.setConflictSkel(conflictSkel);
        return result;
    }
}

