/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc.patch;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.patch.SVNPatch;
import afu.org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import java.io.IOException;
import java.util.Comparator;

public class SVNPatchHunk {
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            SVNPatchHunk ha = (SVNPatchHunk)a;
            SVNPatchHunk hb = (SVNPatchHunk)b;
            if (ha.original.start < hb.original.start) {
                return -1;
            }
            if (ha.original.start > hb.original.start) {
                return 1;
            }
            return 0;
        }
    };
    private static final SVNPatchFileStream.SVNPatchFileLineFilter original_line_filter = new SVNPatchFileStream.SVNPatchFileLineFilter(){

        @Override
        public boolean lineFilter(String line) {
            return SVNPatchHunk.getChar(line, 0) == '+' || SVNPatchHunk.getChar(line, 0) == '\\';
        }
    };
    private static final SVNPatchFileStream.SVNPatchFileLineFilter modified_line_filter = new SVNPatchFileStream.SVNPatchFileLineFilter(){

        @Override
        public boolean lineFilter(String line) {
            return SVNPatchHunk.getChar(line, 0) == '-' || SVNPatchHunk.getChar(line, 0) == '\\';
        }
    };
    private static final SVNPatchFileStream.SVNPatchFileLineTransformer remove_leading_char_transformer = new SVNPatchFileStream.SVNPatchFileLineTransformer(){

        @Override
        public String lineTransformer(String line) {
            if (SVNPatchHunk.getChar(line, 0) == '+' || SVNPatchHunk.getChar(line, 0) == '-' || SVNPatchHunk.getChar(line, 0) == ' ') {
                return line.substring(1);
            }
            return line;
        }
    };
    private SVNPatchFileStream diffText;
    private SVNPatchFileStream originalText;
    private SVNPatchFileStream modifiedText;
    private SVNPatchHunkRange original = new SVNPatchHunkRange();
    private SVNPatchHunkRange modified = new SVNPatchHunkRange();
    private long leadingContext;
    private long trailingContext;

    public SVNPatchFileStream getDiffText() {
        return this.diffText;
    }

    public SVNPatchFileStream getOriginalText() {
        return this.originalText;
    }

    public SVNPatchFileStream getModifiedText() {
        return this.modifiedText;
    }

    public SVNPatchHunkRange getOriginal() {
        return this.original;
    }

    public SVNPatchHunkRange getModified() {
        return this.modified;
    }

    public long getLeadingContext() {
        return this.leadingContext;
    }

    public long getTrailingContext() {
        return this.trailingContext;
    }

    public void close() throws IOException {
        if (this.originalText != null) {
            this.originalText.close();
        }
        if (this.modifiedText != null) {
            this.modifiedText.close();
        }
        if (this.diffText != null) {
            this.diffText.close();
        }
    }

    public static SVNPatchHunk parseNextHunk(SVNPatch patch) throws IOException, SVNException {
        long last_line;
        boolean eof;
        if (patch.getPatchFile().isEOF()) {
            return null;
        }
        boolean in_hunk = false;
        boolean hunk_seen = false;
        long leading_context = 0L;
        long trailing_context = 0L;
        boolean changed_line_seen = false;
        long start = 0L;
        long end = 0L;
        long original_lines = 0L;
        SVNPatchHunk hunk = new SVNPatchHunk();
        long pos = patch.getPatchFile().getSeekPosition();
        StringBuffer lineBuf = new StringBuffer();
        do {
            last_line = pos;
            lineBuf.setLength(0);
            eof = patch.getPatchFile().readLine(lineBuf);
            String line = lineBuf.toString();
            if (!eof) {
                pos = patch.getPatchFile().getSeekPosition();
            }
            if (SVNPatchHunk.getChar(line, 0) == '\\') continue;
            if (in_hunk) {
                if (!hunk_seen) {
                    start = last_line;
                }
                char c = SVNPatchHunk.getChar(line, 0);
                if (original_lines > 0L && (c == ' ' || !eof && line.length() == 0)) {
                    hunk_seen = true;
                    --original_lines;
                    if (changed_line_seen) {
                        ++trailing_context;
                        continue;
                    }
                    ++leading_context;
                    continue;
                }
                if (c == '+' || c == '-') {
                    hunk_seen = true;
                    changed_line_seen = true;
                    if (trailing_context > 0L) {
                        trailing_context = 0L;
                    }
                    if (original_lines <= 0L || c != '-') continue;
                    --original_lines;
                    continue;
                }
                in_hunk = false;
                end = last_line;
                break;
            }
            if (line.startsWith("@@")) {
                in_hunk = SVNPatchHunk.parseHunkHeader(line, hunk);
                if (!in_hunk) continue;
                original_lines = hunk.original.length;
                continue;
            }
            if (line.startsWith("--- ")) break;
        } while (!eof);
        if (!eof) {
            patch.getPatchFile().setSeekPosition(last_line);
        }
        if (!hunk_seen || start >= end) {
            return null;
        }
        SVNPatchFileStream diff_text = SVNPatchFileStream.openRangeReadOnly(patch.getPath(), start, end);
        SVNPatchFileStream original_text = SVNPatchFileStream.openRangeReadOnly(patch.getPath(), start, end);
        original_text.setLineFilter(original_line_filter);
        original_text.setLineTransformer(remove_leading_char_transformer);
        SVNPatchFileStream modified_text = SVNPatchFileStream.openRangeReadOnly(patch.getPath(), start, end);
        modified_text.setLineFilter(modified_line_filter);
        modified_text.setLineTransformer(remove_leading_char_transformer);
        hunk.diffText = diff_text;
        hunk.originalText = original_text;
        hunk.modifiedText = modified_text;
        hunk.leadingContext = leading_context;
        hunk.trailingContext = trailing_context;
        return hunk;
    }

    private static char getChar(String line, int i) {
        if (line != null && line.length() > 0 && i < line.length()) {
            return line.charAt(i);
        }
        return '\u0000';
    }

    private static boolean parseHunkHeader(String header, SVNPatchHunk hunk) {
        int p = "@@".length();
        if (p >= header.length() || header.charAt(p) != ' ') {
            return false;
        }
        if (++p >= header.length() || header.charAt(p) != '-') {
            return false;
        }
        StringBuffer range = new StringBuffer(31);
        ++p;
        while (p < header.length() && header.charAt(p) != ' ') {
            range.append(header.charAt(p));
            ++p;
        }
        if (p >= header.length() || header.charAt(p) != ' ') {
            return false;
        }
        if (!SVNPatchHunk.parseRange(hunk.original, range)) {
            return false;
        }
        range.setLength(0);
        if (++p >= header.length() || header.charAt(p) != '+') {
            return false;
        }
        ++p;
        while (p < header.length() && header.charAt(p) != ' ') {
            range.append(header.charAt(p));
            ++p;
        }
        if (p >= header.length() || header.charAt(p) != ' ') {
            return false;
        }
        if (++p >= header.length() || !header.startsWith("@@", p)) {
            return false;
        }
        return SVNPatchHunk.parseRange(hunk.modified, range);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseRange(SVNPatchHunkRange hunkRange, StringBuffer range) {
        Integer offset;
        if (range.length() == 0) {
            return false;
        }
        int comma = range.indexOf(",");
        if (comma >= 0) {
            if (comma + 1 >= range.length()) return false;
            offset = SVNPatchHunk.parseOffset(range.substring(comma + 1));
            if (offset == null) {
                return false;
            }
            hunkRange.length = offset;
            range.setLength(comma);
        } else {
            hunkRange.length = 1;
        }
        offset = SVNPatchHunk.parseOffset(range.toString());
        if (offset == null) {
            return false;
        }
        hunkRange.start = offset;
        return true;
    }

    private static Integer parseOffset(String number) {
        if (number != null) {
            try {
                return Integer.valueOf(number);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static class SVNPatchHunkRange {
        private int start;
        private int length;

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }
    }
}

