/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.SVNCommitInfo;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileType;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import afu.org.tmatesoft.svn.core.io.ISVNEditor;
import afu.org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import afu.org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNStatus;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class SVNRemoteStatusEditor
extends SVNStatusEditor
implements ISVNEditor,
ISVNStatusHandler {
    private boolean myIsRootOpen;
    private SVNStatus myAnchorStatus;
    private DirectoryInfo myDirectoryInfo;
    private FileInfo myFileInfo;

    public SVNRemoteStatusEditor(ISVNOptions options, SVNWCAccess wcAccess, SVNAdminAreaInfo info, boolean noIgnore, boolean reportAll, SVNDepth depth, ISVNStatusHandler handler) throws SVNException {
        super(options, wcAccess, info, noIgnore, reportAll, depth, handler);
        this.myAnchorStatus = this.createStatus(info.getAnchor().getRoot());
    }

    @Override
    public void setRepositoryInfo(SVNURL root, Map repositoryLocks) {
        super.setRepositoryInfo(root, repositoryLocks);
        if (this.myAnchorStatus.getRepositoryRootURL() == null) {
            this.myAnchorStatus.setRepositoryRootURL(this.myRepositoryRoot);
        }
        if (this.myAnchorStatus.getURL() != null && this.myAnchorStatus.getRepositoryRootURL() != null) {
            this.myAnchorStatus.setRepositoryRelativePath(SVNURLUtil.getRelativeURL(this.myAnchorStatus.getRepositoryRootURL(), this.myAnchorStatus.getURL(), false));
        }
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myDirectoryInfo = new DirectoryInfo(null, null);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        String name;
        File dirPath;
        File file = this.getAnchor().getFile(path);
        SVNEntry entry = this.getWCAccess().getVersionedEntry(file, false);
        if (entry.getKind() == SVNNodeKind.DIR) {
            dirPath = file;
            name = "";
        } else {
            dirPath = file.getParentFile();
            name = file.getName();
        }
        SVNAdminArea dir = null;
        try {
            dir = this.getWCAccess().retrieve(dirPath);
        }
        catch (SVNException e) {
            SVNFileType type = SVNFileType.getType(file);
            if (type == SVNFileType.NONE && e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                return;
            }
            throw e;
        }
        if (dir.getEntry(name, false) != null) {
            this.tweakStatusHash(this.myDirectoryInfo, this.myDirectoryInfo, file, SVNStatusType.STATUS_DELETED, SVNStatusType.STATUS_NONE, null, SVNRevision.create(revision));
            SVNStatus status = (SVNStatus)this.myDirectoryInfo.myChildrenStatuses.get(file);
            if (status != null) {
                status.setRemoteStatus(null, null, null, dir.getEntry(name, false).getKind());
            }
        }
        if (this.myDirectoryInfo.myParent != null && !this.hasTarget()) {
            this.tweakStatusHash(this.myDirectoryInfo.myParent, this.myDirectoryInfo, this.myDirectoryInfo.myPath, SVNStatusType.STATUS_MODIFIED, SVNStatusType.STATUS_NONE, null, null);
        } else if (!this.hasTarget() && this.myDirectoryInfo.myParent == null) {
            this.myDirectoryInfo.myIsContentsChanged = true;
        }
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myDirectoryInfo = new DirectoryInfo(path, this.myDirectoryInfo);
        this.myDirectoryInfo.myIsAdded = true;
        this.myDirectoryInfo.myParent.myIsContentsChanged = true;
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        this.myDirectoryInfo = new DirectoryInfo(path, this.myDirectoryInfo);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            this.myDirectoryInfo.myIsPropertiesChanged = true;
        }
        if ("svn:entry:committed-rev".equals(name) && value != null) {
            try {
                long number = Long.parseLong(value.getString());
                this.myDirectoryInfo.myRemoteRevision = SVNRevision.create(number);
            }
            catch (NumberFormatException nfe) {
                this.myDirectoryInfo.myRemoteRevision = SVNRevision.UNDEFINED;
            }
        } else if ("svn:entry:committed-date".equals(name) && value != null) {
            this.myDirectoryInfo.myRemoteDate = SVNDate.parseDate(value.getString());
        } else if ("svn:entry:last-author".equals(name) && value != null) {
            this.myDirectoryInfo.myRemoteAuthor = value.getString();
        }
    }

    @Override
    public void closeDir() throws SVNException {
        DirectoryInfo parent = this.myDirectoryInfo.myParent;
        if (this.myDirectoryInfo.myIsAdded || this.myDirectoryInfo.myIsPropertiesChanged || this.myDirectoryInfo.myIsContentsChanged || this.myDirectoryInfo.myRemoteRevision != null && this.myDirectoryInfo.myRemoteRevision != SVNRevision.UNDEFINED) {
            SVNStatusType propertiesStatus;
            SVNStatusType contentsStatus;
            if (this.myDirectoryInfo.myIsAdded) {
                contentsStatus = SVNStatusType.STATUS_ADDED;
                propertiesStatus = this.myDirectoryInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NONE;
            } else {
                contentsStatus = this.myDirectoryInfo.myIsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
                SVNStatusType sVNStatusType = propertiesStatus = this.myDirectoryInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            }
            if (parent != null) {
                this.tweakStatusHash(parent, this.myDirectoryInfo, this.myDirectoryInfo.myPath, contentsStatus, propertiesStatus, null, null);
            }
        }
        if (parent != null && this.myDirectoryInfo.myDepth != SVNDepth.EXCLUDE) {
            boolean wasDeleted = false;
            SVNStatus dirStatus = (SVNStatus)parent.myChildrenStatuses.get(this.myDirectoryInfo.myPath);
            if (dirStatus != null && (dirStatus.getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED || dirStatus.getRemoteContentsStatus() == SVNStatusType.STATUS_REPLACED)) {
                wasDeleted = true;
            }
            this.handleStatusHash(dirStatus != null ? dirStatus.getEntry() : null, this.myDirectoryInfo.myChildrenStatuses, wasDeleted, this.myDirectoryInfo.myDepth);
            if (this.isSendableStatus(dirStatus)) {
                this.getDefaultHandler().handleStatus(dirStatus);
            }
            parent.myChildrenStatuses.remove(this.myDirectoryInfo.myPath);
        } else if (parent == null) {
            if (this.hasTarget()) {
                File targetPath = this.getAnchor().getFile(this.getAdminAreaInfo().getTargetName());
                SVNStatus tgtStatus = (SVNStatus)this.myDirectoryInfo.myChildrenStatuses.get(targetPath);
                if (tgtStatus != null) {
                    if (tgtStatus.getKind() == SVNNodeKind.DIR) {
                        SVNAdminArea dir = this.getWCAccess().retrieve(targetPath);
                        this.getDirStatus(null, dir, null, this.getDepth(), this.isReportAll(), this.isNoIgnore(), null, true, this.getDefaultHandler());
                    }
                    if (this.isSendableStatus(tgtStatus)) {
                        this.getDefaultHandler().handleStatus(tgtStatus);
                    }
                }
            } else {
                this.handleStatusHash(this.myAnchorStatus.getEntry(), this.myDirectoryInfo.myChildrenStatuses, false, this.getDepth());
                if (this.myDirectoryInfo != null && this.myDirectoryInfo.myParent == null) {
                    this.tweakAnchorStatus(this.myDirectoryInfo);
                }
                if (this.isSendableStatus(this.myAnchorStatus)) {
                    this.getDefaultHandler().handleStatus(this.myAnchorStatus);
                }
            }
        }
        this.myDirectoryInfo = this.myDirectoryInfo.myParent;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myFileInfo = new FileInfo(this.myDirectoryInfo, path, true);
        this.myDirectoryInfo.myIsContentsChanged = true;
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        this.myFileInfo = new FileInfo(this.myDirectoryInfo, path, false);
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (!name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            this.myFileInfo.myIsPropertiesChanged = true;
        }
        if ("svn:entry:committed-rev".equals(name) && value != null) {
            try {
                long number = Long.parseLong(value.getString());
                this.myFileInfo.myRemoteRevision = SVNRevision.create(number);
            }
            catch (NumberFormatException nfe) {
                this.myFileInfo.myRemoteRevision = SVNRevision.UNDEFINED;
            }
        } else if ("svn:entry:committed-date".equals(name) && value != null) {
            this.myFileInfo.myRemoteDate = SVNDate.parseDate(value.getString());
        } else if ("svn:entry:last-author".equals(name) && value != null) {
            this.myFileInfo.myRemoteAuthor = value.getString();
        }
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myFileInfo.myIsContentsChanged = true;
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        SVNStatusType propertiesStatus;
        SVNStatusType contentsStatus;
        if (!(this.myFileInfo.myIsAdded || this.myFileInfo.myIsPropertiesChanged || this.myFileInfo.myIsContentsChanged)) {
            return;
        }
        SVNLock remoteLock = null;
        if (this.myFileInfo.myIsAdded) {
            contentsStatus = SVNStatusType.STATUS_ADDED;
            propertiesStatus = this.myFileInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NONE;
        } else {
            contentsStatus = this.myFileInfo.myIsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            propertiesStatus = this.myFileInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
        }
        remoteLock = this.getLock(this.myFileInfo.myURL);
        this.tweakStatusHash(this.myFileInfo, this.myFileInfo.myPath, contentsStatus, propertiesStatus, remoteLock);
        this.myFileInfo = null;
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return null;
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myIsRootOpen) {
            this.cleanup();
        } else {
            super.closeEdit();
        }
        return new SVNCommitInfo(this.getTargetRevision(), null, null);
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    private void handleStatusHash(SVNEntry dirEntry, Map hash, boolean deleted, SVNDepth depth) throws SVNException {
        ISVNStatusHandler handler = deleted ? this : this.getDefaultHandler();
        for (File path : hash.keySet()) {
            SVNStatus status = (SVNStatus)hash.get(path);
            if (status.getContentsStatus() != SVNStatusType.STATUS_OBSTRUCTED && status.getContentsStatus() != SVNStatusType.STATUS_MISSING && status.getEntry() != null && status.getKind() == SVNNodeKind.DIR && (depth == SVNDepth.UNKNOWN || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY)) {
                SVNAdminArea dir = this.getWCAccess().retrieve(path);
                SVNDepth depthMinusOne = depth;
                if (depthMinusOne == SVNDepth.IMMEDIATES) {
                    depthMinusOne = SVNDepth.EMPTY;
                }
                this.getDirStatus(dirEntry, dir, null, depthMinusOne, this.isReportAll(), this.isNoIgnore(), null, true, handler);
            }
            if (deleted) {
                status.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
            }
            if (!this.isSendableStatus(status)) continue;
            handler.handleStatus(status);
        }
    }

    private void tweakStatusHash(FileInfo fileInfo, File path, SVNStatusType text, SVNStatusType props, SVNLock lock) throws SVNException {
        Map hash = fileInfo.myParent.myChildrenStatuses;
        SVNStatus status = (SVNStatus)hash.get(fileInfo.myPath);
        if (status == null) {
            if (text != SVNStatusType.STATUS_ADDED) {
                return;
            }
            status = this.createStatus(path);
            hash.put(fileInfo.myPath, status);
        }
        if (text == SVNStatusType.STATUS_ADDED && status.getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED) {
            text = SVNStatusType.STATUS_REPLACED;
        }
        status.setRemoteStatus(fileInfo.myURL, text, props, lock, fileInfo.myRemoteKind, fileInfo.myRemoteRevision, fileInfo.myRemoteDate, fileInfo.myRemoteAuthor);
        status.setRepositoryRootURL(this.myRepositoryRoot);
        if (status.getRemoteURL() != null) {
            status.setRepositoryRelativePath(SVNURLUtil.getRelativeURL(this.myRepositoryRoot, status.getRemoteURL(), false));
        }
    }

    private void tweakStatusHash(DirectoryInfo dirInfo, DirectoryInfo childDir, File path, SVNStatusType text, SVNStatusType props, SVNLock lock, SVNRevision revision) throws SVNException {
        Map hash = dirInfo.myChildrenStatuses;
        SVNStatus status = (SVNStatus)hash.get(path);
        if (status == null) {
            if (text != SVNStatusType.STATUS_ADDED) {
                return;
            }
            status = this.createStatus(path);
            hash.put(path, status);
        }
        if (text == SVNStatusType.STATUS_ADDED && status.getRemoteContentsStatus() == SVNStatusType.STATUS_DELETED) {
            text = SVNStatusType.STATUS_REPLACED;
        }
        if (text == SVNStatusType.STATUS_DELETED) {
            SVNURL remoteURL = dirInfo.myURL;
            if (childDir != null) {
                if (childDir.myURL != null) {
                    remoteURL = childDir.myURL.appendPath(SVNFileUtil.getFileName(path), false);
                }
            } else if (dirInfo.myURL != null) {
                remoteURL = dirInfo.myURL.appendPath(SVNFileUtil.getFileName(path), false);
            }
            if (revision == SVNRevision.UNDEFINED) {
                revision = dirInfo.myRemoteRevision;
            }
            status.setRemoteStatus(remoteURL, text, props, lock, SVNNodeKind.NONE, revision, null, null);
        } else if (childDir == null) {
            status.setRemoteStatus(dirInfo.myURL, text, props, lock, dirInfo.myRemoteKind, dirInfo.myRemoteRevision, dirInfo.myRemoteDate, dirInfo.myRemoteAuthor);
        } else {
            status.setRemoteStatus(childDir.myURL, text, props, lock, childDir.myRemoteKind, childDir.myRemoteRevision, childDir.myRemoteDate, childDir.myRemoteAuthor);
        }
        status.setRepositoryRootURL(this.myRepositoryRoot);
        if (status.getRemoteURL() != null) {
            status.setRepositoryRelativePath(SVNURLUtil.getRelativeURL(this.myRepositoryRoot, status.getRemoteURL(), false));
        }
    }

    private void tweakAnchorStatus(DirectoryInfo anchorInfo) {
        if (anchorInfo != null && (anchorInfo.myIsContentsChanged || anchorInfo.myIsPropertiesChanged)) {
            SVNStatusType text = anchorInfo.myIsContentsChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            SVNStatusType props = anchorInfo.myIsPropertiesChanged ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NONE;
            this.myAnchorStatus.setRemoteStatus(this.myDirectoryInfo.myURL, text, props, null, SVNNodeKind.DIR, this.myDirectoryInfo.myRemoteRevision, this.myDirectoryInfo.myRemoteDate, this.myDirectoryInfo.myRemoteAuthor);
        }
    }

    private boolean isSendableStatus(SVNStatus status) {
        if (status == null) {
            return false;
        }
        if (status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE) {
            return true;
        }
        if (status.getRemoteLock() != null) {
            return true;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_IGNORED && !this.isNoIgnore()) {
            return false;
        }
        if (this.isReportAll()) {
            return true;
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            return true;
        }
        if (status.getContentsStatus() != SVNStatusType.STATUS_NONE && status.getContentsStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        if (status.getPropertiesStatus() != SVNStatusType.STATUS_NONE && status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL) {
            return true;
        }
        if (status.getTreeConflict() != null) {
            return true;
        }
        return status.isLocked() || status.isSwitched() || status.getLocalLock() != null || status.getChangelistName() != null || status.isFileExternal();
    }

    private SVNStatus createStatus(File path) throws SVNException {
        SVNAdminArea parentDir;
        SVNEntry entry = this.getWCAccess().getEntry(path, false);
        SVNEntry parentEntry = null;
        if (entry != null && (parentDir = this.getWCAccess().getAdminArea(path.getParentFile())) != null) {
            parentEntry = this.getWCAccess().getEntry(path.getParentFile(), false);
        }
        return this.assembleStatus(path, entry != null ? this.getWCAccess().probeRetrieve(path) : null, entry, parentEntry, SVNNodeKind.UNKNOWN, false, true, false);
    }

    @Override
    public void handleStatus(SVNStatus status) throws SVNException {
        status.setRemoteStatus(SVNStatusType.STATUS_DELETED, null, null, null);
        this.getDefaultHandler().handleStatus(status);
    }

    private class FileInfo {
        public DirectoryInfo myParent;
        public File myPath;
        public String myName;
        public SVNURL myURL;
        public boolean myIsAdded;
        public boolean myIsContentsChanged;
        public boolean myIsPropertiesChanged;
        public SVNRevision myRemoteRevision;
        public Date myRemoteDate;
        public String myRemoteAuthor;
        public SVNNodeKind myRemoteKind;

        public FileInfo(DirectoryInfo parent, String path, boolean added) throws SVNException {
            this.myPath = SVNRemoteStatusEditor.this.getAnchor().getFile(path);
            this.myName = this.myPath.getName();
            this.myParent = parent;
            this.myURL = this.myParent.computeURL().appendPath(this.myName, false);
            this.myRemoteRevision = SVNRevision.UNDEFINED;
            this.myRemoteKind = SVNNodeKind.FILE;
            this.myIsAdded = added;
        }
    }

    private class DirectoryInfo
    implements ISVNStatusHandler {
        public File myPath;
        public String myName;
        public SVNURL myURL;
        public DirectoryInfo myParent;
        public SVNDepth myDepth;
        public SVNRevision myRemoteRevision;
        public Date myRemoteDate;
        public String myRemoteAuthor;
        public SVNNodeKind myRemoteKind;
        public boolean myIsAdded;
        public boolean myIsPropertiesChanged;
        public boolean myIsContentsChanged;
        public Map myChildrenStatuses;

        public DirectoryInfo(String path, DirectoryInfo parent) throws SVNException {
            SVNAdminArea dir;
            SVNStatusType textStatus;
            this.myParent = parent;
            this.myPath = this.myParent != null ? SVNRemoteStatusEditor.this.getAnchor().getFile(path) : SVNRemoteStatusEditor.this.getAnchor().getRoot();
            this.myName = path != null ? SVNPathUtil.tail(path) : null;
            this.myChildrenStatuses = new TreeMap();
            this.myURL = this.computeURL();
            this.myRemoteRevision = SVNRevision.UNDEFINED;
            this.myRemoteKind = SVNNodeKind.DIR;
            this.myDepth = this.myParent != null ? (this.myParent.myDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : (this.myParent.myDepth == SVNDepth.FILES || this.myParent.myDepth == SVNDepth.EMPTY ? SVNDepth.EXCLUDE : (this.myParent.myDepth == SVNDepth.UNKNOWN ? SVNDepth.UNKNOWN : SVNDepth.INFINITY))) : SVNRemoteStatusEditor.this.getDepth();
            SVNStatus parentStatus = null;
            parentStatus = this.myParent != null ? (SVNStatus)this.myParent.myChildrenStatuses.get(this.myPath) : SVNRemoteStatusEditor.this.myAnchorStatus;
            if (parentStatus != null && (textStatus = parentStatus.getContentsStatus()) != SVNStatusType.STATUS_UNVERSIONED && textStatus != SVNStatusType.STATUS_MISSING && textStatus != SVNStatusType.STATUS_OBSTRUCTED && textStatus != SVNStatusType.STATUS_EXTERNAL && textStatus != SVNStatusType.STATUS_IGNORED && parentStatus.getKind() == SVNNodeKind.DIR && (this.myDepth == SVNDepth.UNKNOWN || this.myDepth == SVNDepth.FILES || this.myDepth == SVNDepth.IMMEDIATES || this.myDepth == SVNDepth.INFINITY) && (dir = SVNRemoteStatusEditor.this.getWCAccess().getAdminArea(this.myPath)) != null) {
                SVNRemoteStatusEditor.this.getDirStatus(null, dir, null, SVNDepth.IMMEDIATES, true, true, null, true, this);
                SVNStatus thisDirStatus = (SVNStatus)this.myChildrenStatuses.get(this.myPath);
                if (thisDirStatus != null && thisDirStatus.getEntry() != null && (this.myDepth == SVNDepth.UNKNOWN || this.myDepth.compareTo(parentStatus.getEntry().getDepth()) > 0)) {
                    this.myDepth = thisDirStatus.getEntry().getDepth();
                }
            }
        }

        private SVNURL computeURL() throws SVNException {
            if (this.myURL != null) {
                return this.myURL;
            }
            if (this.myName == null) {
                return SVNRemoteStatusEditor.this.myAnchorStatus.getURL();
            }
            SVNStatus status = (SVNStatus)this.myParent.myChildrenStatuses.get(this.myPath);
            if (status != null && status.getEntry() != null && status.getEntry().getSVNURL() != null) {
                return status.getEntry().getSVNURL();
            }
            SVNURL url = this.myParent.computeURL();
            return url != null ? url.appendPath(this.myName, false) : null;
        }

        @Override
        public void handleStatus(SVNStatus status) throws SVNException {
            this.myChildrenStatuses.put(status.getFile(), status);
        }
    }
}

