/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNCommitInfo;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNDirEntry;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import afu.org.tmatesoft.svn.core.SVNMergeRangeList;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import afu.org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import afu.org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import afu.org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import afu.org.tmatesoft.svn.core.internal.wc.SVNExternal;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileType;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import afu.org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import afu.org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import afu.org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import afu.org.tmatesoft.svn.core.io.ISVNEditor;
import afu.org.tmatesoft.svn.core.io.SVNLocationEntry;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import afu.org.tmatesoft.svn.core.wc.ISVNEventHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import afu.org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import afu.org.tmatesoft.svn.core.wc.SVNCommitItem;
import afu.org.tmatesoft.svn.core.wc.SVNCopySource;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNWCUtil;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SVNCopyDriver
extends SVNBasicDelegate {
    private SVNWCAccess myWCAccess;
    private boolean myIsDisableLocalModificationsCopying;

    public void setDisableLocalModificationCopying(boolean disable) {
        this.myIsDisableLocalModificationsCopying = disable;
    }

    protected SVNCopyDriver(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    protected SVNCopyDriver(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    protected void setWCAccess(SVNWCAccess access) {
        this.myWCAccess = access;
    }

    private SVNWCAccess getWCAccess() {
        if (this.myWCAccess == null) {
            return this.createWCAccess();
        }
        return this.myWCAccess;
    }

    private SVNAdminArea probeOpen(SVNWCAccess access, File path, boolean writeLock, int depth) throws SVNException {
        if (access != this.myWCAccess) {
            return access.probeOpen(path, writeLock, depth);
        }
        return this.myWCAccess.probeRetrieve(path);
    }

    private SVNAdminArea open(SVNWCAccess access, File path, boolean writeLock, boolean stealLock, int depth) throws SVNException {
        if (access != this.myWCAccess) {
            return access.open(path, writeLock, stealLock, depth);
        }
        return this.myWCAccess.retrieve(path);
    }

    private void close(SVNWCAccess access) throws SVNException {
        if (access != this.myWCAccess) {
            access.close();
        }
    }

    protected SVNCopySource[] expandCopySources(SVNCopySource[] sources) throws SVNException {
        ArrayList<SVNCopySource> expanded = new ArrayList<SVNCopySource>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            SVNCopySource source = sources[i];
            if (source.isCopyContents() && source.isURL()) {
                SVNRevision startRevision;
                SVNRevision pegRevision = source.getPegRevision();
                if (!pegRevision.isValid()) {
                    pegRevision = SVNRevision.HEAD;
                }
                if (!(startRevision = source.getRevision()).isValid()) {
                    startRevision = pegRevision;
                }
                SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(source.getURL(), null, null, pegRevision, startRevision, SVNRevision.UNDEFINED);
                SVNRepository repository = this.createRepository(locations[0].getURL(), null, null, true);
                long revision = locations[0].getRevisionNumber();
                ArrayList entries = new ArrayList();
                repository.getDir("", revision, null, 0, entries);
                for (SVNDirEntry entry : entries) {
                    expanded.add(new SVNCopySource(SVNRevision.UNDEFINED, source.getRevision(), entry.getURL()));
                }
                continue;
            }
            expanded.add(source);
        }
        return expanded.toArray(new SVNCopySource[expanded.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNCommitInfo copyReposToRepos(List copyPairs, boolean makeParents, boolean isMove, String message, SVNProperties revprops, ISVNCommitHandler commitHandler) throws SVNException {
        String url;
        int i;
        SVNNodeKind kind;
        CopyPair pair;
        ArrayList<CopyPathInfo> pathInfos = new ArrayList<CopyPathInfo>();
        SVNHashMap pathsMap = new SVNHashMap();
        for (int i2 = 0; i2 < copyPairs.size(); ++i2) {
            CopyPathInfo info = new CopyPathInfo();
            pathInfos.add(info);
        }
        String commonURL = ((CopyPair)copyPairs.get((int)0)).mySource;
        String topDstURL = ((CopyPair)copyPairs.get((int)0)).myDst;
        for (int i3 = 1; i3 < copyPairs.size(); ++i3) {
            CopyPair pair2 = (CopyPair)copyPairs.get(i3);
            commonURL = SVNPathUtil.getCommonPathAncestor(commonURL, pair2.mySource);
        }
        commonURL = copyPairs.size() == 1 ? SVNPathUtil.getCommonPathAncestor(commonURL, topDstURL) : SVNPathUtil.getCommonPathAncestor(commonURL, SVNPathUtil.removeTail(topDstURL));
        try {
            SVNURL.parseURIEncoded(commonURL);
        }
        catch (SVNException e) {
            commonURL = null;
        }
        if (commonURL == null) {
            SVNURL url1 = SVNURL.parseURIEncoded(((CopyPair)copyPairs.get((int)0)).mySource);
            SVNURL url2 = SVNURL.parseURIEncoded(((CopyPair)copyPairs.get((int)0)).myDst);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source and dest appear not to be in the same repository (src: ''{0}''; dst: ''{1}'')", url1, url2);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRepository nonTopRepos = null;
        for (int i4 = 0; i4 < copyPairs.size(); ++i4) {
            CopyPair pair3 = (CopyPair)copyPairs.get(i4);
            CopyPathInfo info = (CopyPathInfo)pathInfos.get(i4);
            if (nonTopRepos == null) {
                nonTopRepos = this.createRepository(SVNURL.parseURIEncoded(pair3.mySource), null, null, true);
            }
            if (!pair3.mySource.equals(pair3.myDst)) continue;
            info.isResurrection = true;
        }
        String rootURL = nonTopRepos.getRepositoryRoot(true).toString();
        ArrayList<String> newDirs = new ArrayList<String>();
        SVNURL oldLocation = null;
        if (makeParents) {
            pair = (CopyPair)copyPairs.get(0);
            if (!pair.myDst.equals(rootURL)) {
                oldLocation = nonTopRepos.getLocation();
                nonTopRepos.setLocation(SVNURL.parseURIEncoded(pair.myDst).removePathTail(), false);
                kind = nonTopRepos.checkPath("", -1L);
                while (kind == SVNNodeKind.NONE) {
                    newDirs.add(nonTopRepos.getLocation().toString());
                    nonTopRepos.setLocation(nonTopRepos.getLocation().removePathTail(), false);
                    kind = nonTopRepos.checkPath("", -1L);
                }
            }
        } else if (Boolean.getBoolean("svnkit.compatibleHash")) {
            pair = (CopyPair)copyPairs.get(0);
            if (!pair.myDst.equals(rootURL)) {
                oldLocation = nonTopRepos.getLocation();
                nonTopRepos.setLocation(SVNURL.parseURIEncoded(pair.myDst).removePathTail(), false);
                kind = nonTopRepos.checkPath("", -1L);
                if (kind == SVNNodeKind.NONE) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' path not found", (Object)nonTopRepos.getLocation());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
        if (oldLocation != null) {
            nonTopRepos.setLocation(oldLocation, false);
        }
        for (int i5 = 0; i5 < copyPairs.size(); ++i5) {
            CopyPair pair4 = (CopyPair)copyPairs.get(i5);
            CopyPathInfo info = (CopyPathInfo)pathInfos.get(i5);
            if (pair4.myDst.equals(rootURL) || SVNPathUtil.getPathAsChild(pair4.myDst, pair4.mySource) == null) continue;
            info.isResurrection = true;
        }
        long latestRevision = nonTopRepos.getLatestRevision();
        for (int i6 = 0; i6 < copyPairs.size(); ++i6) {
            SVNErrorMessage err;
            CopyPair pair5 = (CopyPair)copyPairs.get(i6);
            CopyPathInfo info = (CopyPathInfo)pathInfos.get(i6);
            info.mySourceRevisionNumber = pair5.mySourceRevisionNumber = this.getRevisionNumber(pair5.mySourceRevision, nonTopRepos, null);
            SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(SVNURL.parseURIEncoded(pair5.mySource), null, null, pair5.mySourcePegRevision, pair5.mySourceRevision, SVNRevision.UNDEFINED);
            pair5.mySource = locations[0].getURL().toString();
            if (isMove && pair5.mySource.equals(pair5.myDst)) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move URL ''{0}'' into itself", (Object)SVNURL.parseURIEncoded(pair5.mySource));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            nonTopRepos.setLocation(SVNURL.parseURIEncoded(pair5.mySource), false);
            info.mySourceKind = nonTopRepos.checkPath("", pair5.mySourceRevisionNumber);
            if (info.mySourceKind == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist in revision {1}", SVNURL.parseURIEncoded(pair5.mySource), new Long(pair5.mySourceRevisionNumber));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            nonTopRepos.setLocation(SVNURL.parseURIEncoded(pair5.myDst), false);
            SVNNodeKind dstKind = nonTopRepos.checkPath("", latestRevision);
            if (dstKind != SVNNodeKind.NONE) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)pair5.myDst);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            info.mySource = pair5.mySource;
            info.myDstPath = pair5.myDst;
        }
        ArrayList<String> paths = new ArrayList<String>(copyPairs.size() * 2);
        ArrayList<SVNCommitItem> commitItems = new ArrayList<SVNCommitItem>(copyPairs.size() * 2);
        if (makeParents) {
            for (String itemURL : newDirs) {
                SVNCommitItem item = new SVNCommitItem(null, SVNURL.parseURIEncoded(itemURL), null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                commitItems.add(item);
            }
        }
        for (CopyPathInfo info : pathInfos) {
            SVNURL itemURL = SVNURL.parseURIEncoded(info.myDstPath);
            SVNCommitItem item = new SVNCommitItem(null, itemURL, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
            commitItems.add(item);
            pathsMap.put(info.myDstPath, info);
            if (!isMove || info.isResurrection) continue;
            itemURL = SVNURL.parseURIEncoded(info.mySource);
            item = new SVNCommitItem(null, itemURL, null, SVNNodeKind.NONE, null, null, false, true, false, false, false, false);
            commitItems.add(item);
            pathsMap.put(info.mySource, info);
        }
        if (makeParents) {
            for (String dirPath : newDirs) {
                CopyPathInfo info = new CopyPathInfo();
                info.myDstPath = dirPath;
                info.isDirAdded = true;
                paths.add(info.myDstPath);
                pathsMap.put(dirPath, info);
            }
        }
        for (CopyPathInfo info : pathInfos) {
            nonTopRepos.setLocation(SVNURL.parseURIEncoded(info.mySource), false);
            Map mergeInfo = this.calculateTargetMergeInfo(null, null, SVNURL.parseURIEncoded(info.mySource), info.mySourceRevisionNumber, nonTopRepos, false);
            if (mergeInfo != null) {
                info.myMergeInfoProp = SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo, null);
            }
            paths.add(info.myDstPath);
            if (!isMove || info.isResurrection) continue;
            paths.add(info.mySource);
        }
        SVNCommitItem[] commitables = commitItems.toArray(new SVNCommitItem[commitItems.size()]);
        if ((message = commitHandler.getCommitMessage(message, commitables)) == null) {
            return SVNCommitInfo.NULL;
        }
        revprops = commitHandler.getRevisionProperties(message = SVNCommitUtil.validateCommitMessage(message), commitables, revprops == null ? new SVNProperties() : revprops);
        if (revprops == null) {
            return SVNCommitInfo.NULL;
        }
        SVNPropertiesManager.validateRevisionProperties(revprops);
        SVNURL topURL = SVNURL.parseURIEncoded((String)paths.get(0));
        for (i = 1; i < paths.size(); ++i) {
            url = (String)paths.get(i);
            topURL = SVNURLUtil.getCommonURLAncestor(topURL, SVNURL.parseURIEncoded(url));
        }
        if (paths.contains(topURL.toString())) {
            topURL = topURL.removePathTail();
        }
        for (i = 0; i < paths.size(); ++i) {
            url = (String)paths.get(i);
            SVNURL svnURL = SVNURL.parseURIEncoded(url);
            url = SVNPathUtil.getPathAsChild(topURL.getPath(), svnURL.getPath());
            paths.set(i, url);
            CopyPathInfo info = (CopyPathInfo)pathsMap.remove(svnURL.toString());
            if (info == null) continue;
            if (info.mySource != null) {
                info.mySourcePath = this.getPathRelativeToRoot(null, SVNURL.parseURIEncoded(info.mySource), SVNURL.parseURIEncoded(rootURL), null, null);
                info.mySourceRelativePath = this.getPathRelativeToSession(SVNURL.parseURIEncoded(info.mySource), topURL, null);
            }
            pathsMap.put(url, info);
        }
        nonTopRepos.setLocation(topURL, false);
        ISVNEditor commitEditor = nonTopRepos.getCommitEditor(message, null, true, revprops, null);
        CopyCommitPathHandler committer = new CopyCommitPathHandler(pathsMap, isMove);
        SVNCommitInfo result = null;
        try {
            SVNCommitUtil.driveCommitEditor(committer, paths, commitEditor, latestRevision);
            result = commitEditor.closeEdit();
        }
        catch (SVNCancelException cancel) {
            throw cancel;
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        finally {
            if (commitEditor != null && result == null) {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
                }
            }
        }
        if (result != null && result.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, result.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return result != null ? result : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUUIDFromPath(SVNWCAccess wcAccess, File path) throws SVNException {
        SVNEntry entry = wcAccess.getVersionedEntry(path, true);
        String uuid = null;
        if (entry.getUUID() != null) {
            uuid = entry.getUUID();
        } else if (entry.getURL() != null) {
            SVNRepository repos = this.createRepository(entry.getSVNURL(), null, null, false);
            try {
                uuid = repos.getRepositoryUUID(true);
            }
            finally {
                repos.closeSession();
            }
        } else {
            if (wcAccess.isWCRoot(path)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            uuid = this.getUUIDFromPath(wcAccess, path.getParentFile());
        }
        return uuid;
    }

    private static void postCopyCleanup(SVNAdminArea dir) throws SVNException {
        SVNPropertiesManager.deleteWCProperties(dir, null, false);
        SVNFileUtil.setHidden(dir.getAdminDirectory(), true);
        SVNHashMap attributes = new SVNHashMap();
        boolean save = false;
        Iterator entries = dir.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            boolean deleted = entry.isDeleted();
            SVNNodeKind kind = entry.getKind();
            boolean force = false;
            if (entry.getDepth() == SVNDepth.EXCLUDE) continue;
            if (entry.isDeleted()) {
                force = true;
                attributes.put("svn:entry:schedule", "delete");
                attributes.put("svn:entry:deleted", null);
                if (entry.isDirectory()) {
                    attributes.put("svn:entry:kind", "file");
                }
            }
            if (entry.getLockToken() != null) {
                force = true;
                attributes.put("svn:entry:lock-token", null);
                attributes.put("svn:entry:lock-owner", null);
                attributes.put("svn:entry:lock-creation-date", null);
            }
            if (force) {
                dir.modifyEntry(entry.getName(), attributes, false, force);
                save = true;
            }
            if (!deleted && kind == SVNNodeKind.DIR && !dir.getThisDirName().equals(entry.getName())) {
                SVNAdminArea childDir = dir.getWCAccess().retrieve(dir.getFile(entry.getName()));
                SVNCopyDriver.postCopyCleanup(childDir);
            }
            attributes.clear();
        }
        if (save) {
            dir.saveEntries(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNCommitInfo setupCopy(SVNCopySource[] sources, SVNPath dst, boolean isMove, boolean makeParents, String message, SVNProperties revprops, ISVNCommitHandler commitHandler, ISVNCommitParameters commitParameters, ISVNExternalsHandler externalsHandler) throws SVNException {
        SVNErrorMessage err;
        ArrayList<CopyPair> pairs = new ArrayList<CopyPair>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            SVNCopySource source = sources[i];
            if (!source.isURL() || source.getPegRevision() != SVNRevision.BASE && source.getPegRevision() != SVNRevision.COMMITTED && source.getPegRevision() != SVNRevision.PREVIOUS) continue;
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Revision type requires a working copy path, not URL");
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        boolean srcIsURL = sources[0].isURL();
        boolean dstIsURL = dst.isURL();
        if (sources.length > 1) {
            for (int i = 0; i < sources.length; ++i) {
                SVNCopySource source = sources[i];
                CopyPair pair = new CopyPair();
                pair.mySource = source.isURL() ? source.getURL().toString() : source.getFile().getAbsolutePath().replace(File.separatorChar, '/');
                pair.setSourceRevisions(source.getPegRevision(), source.getRevision());
                if (SVNPathUtil.isURL(pair.mySource) != srcIsURL) {
                    SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot mix repository and working copy sources");
                    SVNErrorManager.error(err3, SVNLogType.WC);
                }
                String baseName = source.getName();
                if (srcIsURL && !dstIsURL) {
                    baseName = SVNEncodingUtil.uriDecode(baseName);
                }
                pair.myDst = dstIsURL ? dst.getURL().appendPath(baseName, true).toString() : new File(dst.getFile(), baseName).getAbsolutePath().replace(File.separatorChar, '/');
                pairs.add(pair);
            }
        } else {
            SVNCopySource source = sources[0];
            CopyPair pair = new CopyPair();
            pair.mySource = source.isURL() ? source.getURL().toString() : source.getFile().getAbsolutePath().replace(File.separatorChar, '/');
            pair.setSourceRevisions(source.getPegRevision(), source.getRevision());
            pair.myDst = dstIsURL ? dst.getURL().toString() : dst.getFile().getAbsolutePath().replace(File.separatorChar, '/');
            pairs.add(pair);
        }
        if (!srcIsURL && !dstIsURL) {
            for (CopyPair pair : pairs) {
                String srcPath = pair.mySource;
                String dstPath = pair.myDst;
                if (!SVNPathUtil.isAncestor(srcPath, dstPath)) continue;
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}", srcPath, dstPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (isMove && !srcIsURL) {
            for (CopyPair pair : pairs) {
                SVNWCAccess wcAccess = this.getWCAccess();
                try {
                    File srcFile = new File(pair.mySource);
                    this.probeOpen(wcAccess, srcFile, false, 0);
                    SVNEntry entry = wcAccess.getVersionedEntry(new File(pair.mySource), false);
                    if (entry.getExternalFilePath() == null) continue;
                    SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_MOVE_FILE_EXTERNAL, "Cannot move the file external at ''{0}''; please propedit the svn:externals description that created it", (Object)srcFile);
                    SVNErrorManager.error(err4, SVNLogType.WC);
                }
                finally {
                    this.close(wcAccess);
                }
            }
        }
        if (isMove) {
            if (srcIsURL == dstIsURL) {
                for (CopyPair pair : pairs) {
                    Object p;
                    boolean same;
                    if (!srcIsURL) {
                        File srcPath = new File(pair.mySource);
                        File dstPath = new File(pair.myDst);
                        same = srcPath.equals(dstPath);
                        p = srcPath;
                    } else {
                        SVNURL srcURL = SVNURL.parseURIEncoded(pair.mySource);
                        SVNURL dstURL = SVNURL.parseURIEncoded(pair.myDst);
                        same = srcURL.getPath().equals(dstURL.getPath());
                        p = srcURL;
                    }
                    if (!same) continue;
                    err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move {1} ''{0}'' into itself", p, srcIsURL ? "URL" : "path");
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else {
                SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Moves between the working copy and the repository are not supported");
                SVNErrorManager.error(err5, SVNLogType.WC);
            }
        } else if (!srcIsURL) {
            boolean needReposRevision = false;
            boolean needReposPegRevision = false;
            for (CopyPair pair : pairs) {
                if (pair.mySourceRevision != SVNRevision.UNDEFINED && pair.mySourceRevision != SVNRevision.WORKING) {
                    needReposRevision = true;
                }
                if (pair.mySourcePegRevision != SVNRevision.UNDEFINED && pair.mySourcePegRevision != SVNRevision.WORKING) {
                    needReposPegRevision = true;
                }
                if (!needReposRevision && !needReposPegRevision) continue;
                break;
            }
            if (needReposRevision || needReposPegRevision) {
                for (CopyPair pair : pairs) {
                    SVNWCAccess wcAccess = this.getWCAccess();
                    try {
                        SVNURL url;
                        this.probeOpen(wcAccess, new File(pair.mySource), false, 0);
                        SVNEntry entry = wcAccess.getEntry(new File(pair.mySource), false);
                        SVNURL sVNURL = url = entry.isCopied() ? entry.getCopyFromSVNURL() : entry.getSVNURL();
                        if (url == null) {
                            SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' does not have a URL associated with it", (Object)new File(pair.mySource));
                            SVNErrorManager.error(err6, SVNLogType.WC);
                        }
                        pair.mySource = url.toString();
                        if (!needReposPegRevision || pair.mySourcePegRevision == SVNRevision.BASE) {
                            SVNRevision sVNRevision = pair.mySourcePegRevision = entry.isCopied() ? SVNRevision.create(entry.getCopyFromRevision()) : SVNRevision.create(entry.getRevision());
                        }
                        if (pair.mySourceRevision != SVNRevision.BASE) continue;
                        pair.mySourceRevision = entry.isCopied() ? SVNRevision.create(entry.getCopyFromRevision()) : SVNRevision.create(entry.getRevision());
                    }
                    finally {
                        this.close(wcAccess);
                    }
                }
                srcIsURL = true;
            }
        }
        if (!srcIsURL && !dstIsURL) {
            this.copyWCToWC(pairs, isMove, makeParents);
            return SVNCommitInfo.NULL;
        }
        if (!srcIsURL && dstIsURL) {
            return this.copyWCToRepos(pairs, makeParents, message, revprops, commitHandler, commitParameters, externalsHandler);
        }
        if (srcIsURL && !dstIsURL) {
            this.copyReposToWC(pairs, makeParents);
            return SVNCommitInfo.NULL;
        }
        return this.copyReposToRepos(pairs, makeParents, isMove, message, revprops, commitHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNCommitInfo copyWCToRepos(List copyPairs, boolean makeParents, String message, SVNProperties revprops, ISVNCommitHandler commitHandler, ISVNCommitParameters commitParameters, ISVNExternalsHandler externalsHandler) throws SVNException {
        String topSrc = ((CopyPair)copyPairs.get((int)0)).mySource;
        for (int i = 1; i < copyPairs.size(); ++i) {
            CopyPair pair = (CopyPair)copyPairs.get(i);
            topSrc = SVNPathUtil.getCommonPathAncestor(topSrc, pair.mySource);
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNCommitInfo info = null;
        ISVNEditor commitEditor = null;
        Collection tmpFiles = null;
        try {
            Object pair;
            SVNCommitItem item;
            SVNURL url;
            SVNAdminArea adminArea = wcAccess.probeOpen(new File(topSrc), false, -1);
            wcAccess.setAnchor(adminArea.getRoot());
            String topDstURL = ((CopyPair)copyPairs.get((int)0)).myDst;
            topDstURL = SVNPathUtil.removeTail(topDstURL);
            for (int i = 1; i < copyPairs.size(); ++i) {
                CopyPair pair2 = (CopyPair)copyPairs.get(i);
                topDstURL = SVNPathUtil.getCommonPathAncestor(topDstURL, pair2.myDst);
            }
            SVNRepository repos = this.createRepository(SVNURL.parseURIEncoded(topDstURL), adminArea.getRoot(), wcAccess, true);
            ArrayList<String> newDirs = new ArrayList<String>();
            if (makeParents) {
                String rootURL = topDstURL;
                SVNNodeKind kind = repos.checkPath("", -1L);
                while (kind == SVNNodeKind.NONE) {
                    newDirs.add(rootURL);
                    rootURL = SVNPathUtil.removeTail(rootURL);
                    repos.setLocation(SVNURL.parseURIEncoded(rootURL), false);
                    kind = repos.checkPath("", -1L);
                }
                topDstURL = rootURL;
            }
            for (int i = 0; i < copyPairs.size(); ++i) {
                CopyPair pair3 = (CopyPair)copyPairs.get(i);
                SVNEntry entry = wcAccess.getEntry(new File(pair3.mySource), false);
                pair3.mySourceRevisionNumber = entry.getRevision();
                String dstRelativePath = SVNPathUtil.getPathAsChild(topDstURL, pair3.myDst);
                SVNNodeKind kind = repos.checkPath(dstRelativePath = SVNEncodingUtil.uriDecode(dstRelativePath), -1L);
                if (kind == SVNNodeKind.NONE) continue;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)SVNURL.parseURIEncoded(pair3.myDst));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ArrayList<Object> commitItems = new ArrayList<SVNCommitItem>(copyPairs.size());
            if (makeParents) {
                for (int i = 0; i < newDirs.size(); ++i) {
                    String newDirURL = (String)newDirs.get(i);
                    url = SVNURL.parseURIEncoded(newDirURL);
                    item = new SVNCommitItem(null, url, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                    commitItems.add(item);
                }
            }
            for (int i = 0; i < copyPairs.size(); ++i) {
                pair = (CopyPair)copyPairs.get(i);
                url = SVNURL.parseURIEncoded(((CopyPair)pair).myDst);
                item = new SVNCommitItem(null, url, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                commitItems.add(item);
            }
            SVNCommitItem[] commitables = commitItems.toArray(new SVNCommitItem[commitItems.size()]);
            if ((message = commitHandler.getCommitMessage(message, commitables)) == null) {
                pair = SVNCommitInfo.NULL;
                return pair;
            }
            revprops = commitHandler.getRevisionProperties(message = SVNCommitUtil.validateCommitMessage(message), commitables, revprops == null ? new SVNProperties() : revprops);
            if (revprops == null) {
                pair = SVNCommitInfo.NULL;
                return pair;
            }
            TreeMap allCommitables = new TreeMap(SVNCommitUtil.FILE_COMPARATOR);
            repos.setLocation(repos.getRepositoryRoot(true), false);
            SVNHashMap pathsToExternalsProps = new SVNHashMap();
            for (int i = 0; i < copyPairs.size(); ++i) {
                CopyPair source = (CopyPair)copyPairs.get(i);
                File srcFile = new File(source.mySource);
                SVNEntry entry = wcAccess.getVersionedEntry(srcFile, false);
                SVNAdminArea dirArea = entry.isDirectory() ? wcAccess.retrieve(srcFile) : wcAccess.retrieve(srcFile.getParentFile());
                pathsToExternalsProps.clear();
                HashMap sourceCommittables = new HashMap();
                SVNCommitUtil.harvestCommitables(sourceCommittables, dirArea, srcFile, null, entry, source.myDst, entry.getURL(), true, false, false, null, SVNDepth.INFINITY, false, null, commitParameters, pathsToExternalsProps);
                String basePath = SVNPathUtil.canonicalizePath(wcAccess.getAnchor().getAbsolutePath());
                String sourcePath = SVNPathUtil.canonicalizePath(srcFile.getAbsolutePath());
                String path = SVNPathUtil.getRelativePath(basePath, sourcePath);
                SVNCommitUtil.filterOutFileExternals(Collections.singletonList(path), sourceCommittables, wcAccess);
                allCommitables.putAll(sourceCommittables);
                SVNCommitItem item2 = (SVNCommitItem)allCommitables.get(srcFile);
                SVNURL srcURL = entry.getSVNURL();
                Map<String, SVNMergeRangeList> mergeInfo = this.calculateTargetMergeInfo(srcFile, wcAccess, srcURL, source.mySourceRevisionNumber, repos, false);
                Map wcMergeInfo = SVNPropertiesManager.parseMergeInfo(srcFile, entry, false);
                if (wcMergeInfo != null && mergeInfo != null) {
                    mergeInfo = SVNMergeInfoUtil.mergeMergeInfos(mergeInfo, wcMergeInfo);
                } else if (mergeInfo == null) {
                    mergeInfo = wcMergeInfo;
                }
                if (mergeInfo != null) {
                    String mergeInfoString = SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo, null);
                    this.setCommitItemProperty(item2, "svn:mergeinfo", SVNPropertyValue.create(mergeInfoString));
                }
                if (pathsToExternalsProps.isEmpty()) continue;
                LinkedList<String> newExternals = new LinkedList<String>();
                for (File localPath : pathsToExternalsProps.keySet()) {
                    String externalsPropString = (String)pathsToExternalsProps.get(localPath);
                    SVNExternal[] externals = SVNExternal.parseExternals(localPath.getAbsolutePath(), externalsPropString);
                    boolean introduceVirtualExternalChange = false;
                    newExternals.clear();
                    for (int k = 0; k < externals.length; ++k) {
                        SVNRevision[] revs;
                        File externalWC = new File(localPath, externals[k].getPath());
                        SVNEntry externalEntry = null;
                        SVNRevision externalsWCRevision = SVNRevision.UNDEFINED;
                        try {
                            wcAccess.open(externalWC, false, 0);
                            externalEntry = wcAccess.getEntry(externalWC, false);
                        }
                        catch (SVNException svne) {
                            if (svne instanceof SVNCancelException) {
                                throw svne;
                            }
                        }
                        finally {
                            wcAccess.closeAdminArea(externalWC);
                        }
                        if (externalEntry == null) {
                            externalEntry = wcAccess.getEntry(externalWC, false);
                        }
                        if (externalEntry != null && (externalEntry.isThisDir() || externalEntry.getExternalFilePath() != null)) {
                            externalsWCRevision = SVNRevision.create(externalEntry.getRevision());
                        }
                        SVNEntry ownerEntry = wcAccess.getEntry(localPath, false);
                        SVNURL ownerURL = null;
                        if (ownerEntry != null) {
                            ownerURL = ownerEntry.getSVNURL();
                        }
                        if (ownerURL == null) continue;
                        SVNURL resolvedURL = externals[k].resolveURL(repos.getRepositoryRoot(true), ownerURL);
                        String unresolvedURL = externals[k].getUnresolvedUrl();
                        if (unresolvedURL != null && !SVNPathUtil.isURL(unresolvedURL) && unresolvedURL.startsWith("../")) {
                            unresolvedURL = SVNURLUtil.getRelativeURL(repos.getRepositoryRoot(true), resolvedURL, true);
                            unresolvedURL = unresolvedURL.startsWith("/") ? "^" + unresolvedURL : "^/" + unresolvedURL;
                        }
                        if ((revs = externalsHandler.handleExternal(externalWC, resolvedURL, externals[k].getRevision(), externals[k].getPegRevision(), externals[k].getRawValue(), externalsWCRevision)) != null && revs[0].equals(externals[k].getRevision())) {
                            newExternals.add(externals[k].getRawValue());
                            continue;
                        }
                        if (revs == null) continue;
                        SVNExternal newExternal = new SVNExternal(externals[k].getPath(), unresolvedURL, revs[1], revs[0], true, externals[k].isPegRevisionExplicit(), externals[k].isNewFormat());
                        newExternals.add(newExternal.toString());
                        if (introduceVirtualExternalChange) continue;
                        introduceVirtualExternalChange = true;
                    }
                    if (!introduceVirtualExternalChange) continue;
                    String newExternalsProp = "";
                    for (String external : newExternals) {
                        newExternalsProp = newExternalsProp + external + '\n';
                    }
                    SVNCommitItem itemWithExternalsChanges = (SVNCommitItem)allCommitables.get(localPath);
                    if (itemWithExternalsChanges != null) {
                        this.setCommitItemProperty(itemWithExternalsChanges, "svn:externals", SVNPropertyValue.create(newExternalsProp));
                        continue;
                    }
                    SVNAdminArea childArea = wcAccess.retrieve(localPath);
                    String relativePath = childArea.getRelativePath(dirArea);
                    String itemURL = SVNPathUtil.append(source.myDst, SVNEncodingUtil.uriEncode(relativePath));
                    itemWithExternalsChanges = new SVNCommitItem(localPath, SVNURL.parseURIEncoded(itemURL), null, SVNNodeKind.DIR, null, null, false, false, true, false, false, false);
                    this.setCommitItemProperty(itemWithExternalsChanges, "svn:externals", SVNPropertyValue.create(newExternalsProp));
                    allCommitables.put(localPath, itemWithExternalsChanges);
                }
            }
            commitItems = new ArrayList(allCommitables.values());
            if (this.myIsDisableLocalModificationsCopying) {
                ArrayList<SVNCommitItem> harmlessItems = new ArrayList<SVNCommitItem>();
                for (int i = 0; i < commitItems.size(); ++i) {
                    SVNURL expectedURL;
                    SVNEntry entry;
                    SVNURL copyFromURL;
                    SVNCommitItem item3 = (SVNCommitItem)commitItems.get(i);
                    if (item3.isDeleted() || item3.isAdded() && (!item3.isCopied() || (copyFromURL = item3.getCopyFromURL()) == null || (entry = wcAccess.getEntry(item3.getFile(), false)) == null || !copyFromURL.equals(expectedURL = entry.getSVNURL()))) continue;
                    this.setCommitItemFlags(item3, false, false);
                    harmlessItems.add(item3);
                }
                commitItems = harmlessItems;
            }
            if (makeParents) {
                for (int i = 0; i < newDirs.size(); ++i) {
                    String newDirURL = (String)newDirs.get(i);
                    SVNURL url2 = SVNURL.parseURIEncoded(newDirURL);
                    SVNCommitItem item4 = new SVNCommitItem(null, url2, null, SVNNodeKind.NONE, null, null, true, false, false, false, false, false);
                    commitItems.add(item4);
                }
            }
            commitables = commitItems.toArray(new SVNCommitItem[commitItems.size()]);
            for (int i = 0; i < commitables.length; ++i) {
                this.setCommitItemAccess(commitables[i], wcAccess);
            }
            allCommitables = new TreeMap();
            SVNURL url3 = SVNCommitUtil.translateCommitables(commitables, allCommitables);
            repos = this.createRepository(url3, null, null, true);
            SVNCommitMediator mediator = new SVNCommitMediator(allCommitables);
            tmpFiles = mediator.getTmpFiles();
            message = SVNCommitUtil.validateCommitMessage(message);
            SVNURL rootURL = repos.getRepositoryRoot(true);
            SVNPropertiesManager.validateRevisionProperties(revprops);
            commitEditor = repos.getCommitEditor(message, null, true, revprops, mediator);
            info = SVNCommitter.commit(tmpFiles, allCommitables, rootURL.getPath(), commitEditor);
            commitEditor = null;
        }
        catch (SVNCancelException cancel) {
            throw cancel;
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        finally {
            if (tmpFiles != null) {
                for (File file : tmpFiles) {
                    SVNFileUtil.deleteFile(file);
                }
            }
            if (commitEditor != null && info == null) {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, e);
                }
            }
            if (wcAccess != null) {
                wcAccess.close();
            }
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, null, null, null), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReposToWC(List copyPairs, boolean makeParents) throws SVNException {
        for (CopyPair pair : copyPairs) {
            SVNBasicDelegate.SVNRepositoryLocation[] locations = this.getLocations(SVNURL.parseURIEncoded(pair.mySource), null, null, pair.mySourcePegRevision, pair.mySourceRevision, SVNRevision.UNDEFINED);
            String actualURL = locations[0].getURL().toString();
            String originalSource = pair.mySource;
            pair.mySource = actualURL;
            pair.myOriginalSource = originalSource;
        }
        String topDst = ((CopyPair)copyPairs.get((int)0)).myDst;
        if (copyPairs.size() > 1) {
            topDst = SVNPathUtil.removeTail(topDst);
        }
        String topSrc = ((CopyPair)copyPairs.get((int)0)).mySource;
        for (int i = 1; i < copyPairs.size(); ++i) {
            CopyPair pair = (CopyPair)copyPairs.get(i);
            topSrc = SVNPathUtil.getCommonPathAncestor(topSrc, pair.mySource);
        }
        if (copyPairs.size() == 1) {
            topSrc = SVNPathUtil.removeTail(topSrc);
        }
        SVNRepository topSrcRepos = this.createRepository(SVNURL.parseURIEncoded(topSrc), null, null, false);
        try {
            SVNErrorMessage err;
            for (CopyPair pair : copyPairs) {
                pair.mySourceRevisionNumber = this.getRevisionNumber(pair.mySourceRevision, topSrcRepos, null);
            }
            String reposPath = topSrcRepos.getLocation().toString();
            for (CopyPair pair : copyPairs) {
                String relativePath = SVNPathUtil.getPathAsChild(reposPath, pair.mySource);
                SVNNodeKind kind = topSrcRepos.checkPath(relativePath = SVNEncodingUtil.uriDecode(relativePath), pair.mySourceRevisionNumber);
                if (kind == SVNNodeKind.NONE) {
                    err = pair.mySourceRevisionNumber >= 0L ? SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in revision {1}", SVNURL.parseURIEncoded(pair.mySource), new Long(pair.mySourceRevisionNumber)) : SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' not found in head revision", (Object)SVNURL.parseURIEncoded(pair.mySource));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                pair.mySourceKind = kind;
                SVNFileType dstType = SVNFileType.getType(new File(pair.myDst));
                if (dstType != SVNFileType.NONE) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)new File(pair.myDst));
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                String dstParent = SVNPathUtil.removeTail(pair.myDst);
                SVNFileType dstParentFileType = SVNFileType.getType(new File(dstParent));
                if (makeParents && dstParentFileType == SVNFileType.NONE) {
                    this.addLocalParents(new File(dstParent), this.getEventDispatcher());
                    continue;
                }
                if (dstParentFileType == SVNFileType.DIRECTORY) continue;
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Path ''{0}'' is not a directory", (Object)dstParent);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            SVNWCAccess dstAccess = this.getWCAccess();
            try {
                String dstUUID;
                String srcUUID;
                block25: {
                    block24: {
                        this.probeOpen(dstAccess, new File(topDst), true, 0);
                        for (CopyPair pair : copyPairs) {
                            SVNEntry dstEntry = dstAccess.getEntry(new File(pair.myDst), true);
                            if (dstEntry == null) continue;
                            if (dstEntry.getDepth() == SVNDepth.EXCLUDE || dstEntry.isAbsent()) {
                                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)new File(pair.myDst));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                            if (dstEntry.isDirectory() || dstEntry.isScheduledForDeletion() || dstEntry.isDeleted()) continue;
                            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Entry for ''{0}'' exists (though the working file is missing)", (Object)new File(pair.myDst));
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                        srcUUID = null;
                        dstUUID = null;
                        try {
                            srcUUID = topSrcRepos.getRepositoryUUID(true);
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) break block24;
                            throw e;
                        }
                    }
                    String dstParent = topDst;
                    if (copyPairs.size() == 1) {
                        dstParent = SVNPathUtil.removeTail(topDst);
                    }
                    try {
                        dstUUID = this.getUUIDFromPath(dstAccess, new File(dstParent));
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NO_REPOS_UUID) break block25;
                        throw e;
                    }
                }
                boolean sameRepos = false;
                if (srcUUID != null) {
                    sameRepos = srcUUID.equals(dstUUID);
                }
                for (CopyPair pair : copyPairs) {
                    this.copyReposToWC(pair, sameRepos, topSrcRepos, dstAccess);
                }
            }
            finally {
                this.close(dstAccess);
            }
        }
        finally {
            topSrcRepos.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReposToWC(CopyPair pair, boolean sameRepositories, SVNRepository topSrcRepos, SVNWCAccess dstAccess) throws SVNException {
        long srcRevNum = pair.mySourceRevisionNumber;
        if (pair.mySourceKind == SVNNodeKind.DIR) {
            String srcURL = pair.myOriginalSource;
            SVNURL url = SVNURL.parseURIEncoded(srcURL);
            SVNUpdateClient16 updateClient = new SVNUpdateClient16(this.getRepositoryPool(), this.getOptions());
            updateClient.setEventHandler(this.getEventDispatcher());
            File dstFile = new File(pair.myDst);
            SVNRevision srcRevision = pair.mySourceRevision;
            SVNRevision srcPegRevision = pair.mySourcePegRevision;
            updateClient.doCheckout(url, dstFile, srcPegRevision, srcRevision, SVNDepth.INFINITY, false);
            if (sameRepositories) {
                url = SVNURL.parseURIEncoded(pair.mySource);
                SVNAdminArea dstArea = dstAccess.open(dstFile, true, -1);
                SVNEntry dstRootEntry = dstArea.getEntry(dstArea.getThisDirName(), false);
                if (srcRevision == SVNRevision.HEAD) {
                    srcRevNum = dstRootEntry.getRevision();
                }
                SVNAdminArea dir = dstAccess.getAdminArea(dstFile.getParentFile());
                SVNWCManager.add(dstFile, dir, url, srcRevNum, SVNDepth.INFINITY);
                Map srcMergeInfo = this.calculateTargetMergeInfo(null, null, url, srcRevNum, topSrcRepos, false);
                this.extendWCMergeInfo(dstFile, dstRootEntry, srcMergeInfo, dstAccess);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source URL ''{0}'' is from foreign repository; leaving it as a disjoint WC", (Object)url);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else if (pair.mySourceKind == SVNNodeKind.FILE) {
            String srcURL = pair.mySource;
            SVNURL url = SVNURL.parseURIEncoded(srcURL);
            File dst = new File(pair.myDst);
            SVNAdminArea dir = dstAccess.getAdminArea(dst.getParentFile());
            File tmpFile = SVNAdminUtil.createTmpFile(dir);
            String path = this.getPathRelativeToRoot(null, url, null, null, topSrcRepos);
            SVNProperties props = new SVNProperties();
            OutputStream os = null;
            long revision = -1L;
            try {
                os = SVNFileUtil.openFileForWriting(tmpFile);
                revision = topSrcRepos.getFile(path, srcRevNum, props, new SVNCancellableOutputStream(os, this));
                props = SVNMergeDriver.filterProperties(props, true, false, false, true);
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            if (srcRevNum < 0L) {
                srcRevNum = revision;
            }
            SVNWCManager.addRepositoryFile(dir, dst.getName(), null, tmpFile, props, null, sameRepositories ? pair.mySource : null, sameRepositories ? srcRevNum : -1L);
            SVNEntry entry = dstAccess.getEntry(dst, false);
            Map mergeInfo = this.calculateTargetMergeInfo(null, null, url, srcRevNum, topSrcRepos, false);
            this.extendWCMergeInfo(dst, entry, mergeInfo, dstAccess);
            SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
            dstAccess.handleEvent(event);
            this.sleepForTimeStamp();
        }
    }

    private void copyWCToWC(List copyPairs, boolean isMove, boolean makeParents) throws SVNException {
        for (CopyPair pair : copyPairs) {
            SVNFileType dstFileType;
            SVNErrorMessage err;
            File source = new File(pair.mySource);
            SVNFileType srcFileType = SVNFileType.getType(source);
            if (srcFileType == SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)source);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (isMove && SVNWCUtil.isWorkingCopyRoot(source)) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move ''{0}'' as it is the root of the working copy", (Object)source);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((dstFileType = SVNFileType.getType(new File(pair.myDst))) != SVNFileType.NONE) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)new File(pair.myDst));
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            File dstParent = new File(SVNPathUtil.removeTail(pair.myDst));
            pair.myBaseName = SVNPathUtil.tail(pair.myDst);
            SVNFileType dstParentFileType = SVNFileType.getType(dstParent);
            if (makeParents && dstParentFileType == SVNFileType.NONE) {
                this.addLocalParents(dstParent, this.getEventDispatcher());
                continue;
            }
            if (dstParentFileType == SVNFileType.DIRECTORY) continue;
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "Path ''{0}'' is not a directory", (Object)dstParent);
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        if (isMove) {
            this.moveWCToWC(copyPairs);
        } else {
            this.copyWCToWC(copyPairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDisjointWCToWC(File nestedWC) throws SVNException {
        File nestedWCParent;
        SVNFileType nestedWCType = SVNFileType.getType(nestedWC);
        if (nestedWCType != SVNFileType.DIRECTORY) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This kind of copy can be run on a root of a disjoint wc directory only");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((nestedWCParent = (nestedWC = new File(nestedWC.getAbsolutePath().replace(File.separatorChar, '/'))).getParentFile()) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "{0} seems to be not a disjoint wc since it has no parent", (Object)nestedWC);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNWCAccess parentWCAccess = this.createWCAccess();
        SVNWCAccess nestedWCAccess = this.createWCAccess();
        try {
            SVNErrorMessage err;
            SVNURL parentReposRoot;
            String parentPath;
            SVNURL nestedWCReposRoot;
            String nestedWCPath;
            SVNErrorMessage err2;
            SVNAdminArea parentArea = parentWCAccess.open(nestedWCParent, true, 0);
            SVNEntry srcEntryInParent = parentWCAccess.getEntry(nestedWC, false);
            if (srcEntryInParent != null) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Entry ''{0}'' already exists in parent directory", (Object)nestedWC.getName());
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            SVNAdminArea nestedArea = nestedWCAccess.open(nestedWC, false, -1);
            SVNEntry nestedWCThisEntry = nestedWCAccess.getVersionedEntry(nestedWC, false);
            SVNEntry parentThisEntry = parentWCAccess.getVersionedEntry(nestedWCParent, false);
            if (nestedWCThisEntry.getRepositoryRoot() != null && parentThisEntry.getRepositoryRoot() != null && !nestedWCThisEntry.getRepositoryRoot().equals(parentThisEntry.getRepositoryRoot())) {
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", nestedWCParent, nestedWCThisEntry.getRepositoryRootURL(), parentThisEntry.getRepositoryRootURL());
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (parentThisEntry.isScheduledForDeletion()) {
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)nestedWCParent);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (nestedWCThisEntry.isScheduledForDeletion()) {
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'', as it is scheduled for deletion", (Object)nestedWC);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (SVNPathUtil.isAncestor(nestedWCPath = this.getPathRelativeToRoot(nestedWC, null, nestedWCReposRoot = this.getReposRoot(nestedWC, null, SVNRevision.WORKING, nestedArea, nestedWCAccess), nestedWCAccess, null), parentPath = this.getPathRelativeToRoot(nestedWCParent, null, parentReposRoot = this.getReposRoot(nestedWCParent, null, SVNRevision.WORKING, parentArea, parentWCAccess), parentWCAccess, null))) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}", nestedWCPath, parentPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (nestedWCThisEntry.isScheduledForAddition() && !nestedWCThisEntry.isCopied() || nestedWCThisEntry.getURL() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)nestedWC);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            this.copyDisjointDir(nestedWC, parentWCAccess, nestedWCParent);
            parentWCAccess.probeTry(nestedWC, true, -1);
        }
        finally {
            parentWCAccess.close();
            nestedWCAccess.close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDisjointDir(File nestedWC, SVNWCAccess parentAccess, File nestedWCParent) throws SVNException {
        SVNWCClient16 wcClient = new SVNWCClient16((ISVNAuthenticationManager)null, null);
        wcClient.setEventHandler(this.getEventDispatcher());
        wcClient.doCleanup(nestedWC);
        SVNWCAccess nestedWCAccess = this.createWCAccess();
        String copyFromURL = null;
        long copyFromRevision = -1L;
        try {
            SVNAdminArea dir = nestedWCAccess.open(nestedWC, true, -1);
            SVNEntry nestedWCThisEntry = nestedWCAccess.getVersionedEntry(nestedWC, false);
            SVNCopyDriver.postCopyCleanup(dir);
            if (nestedWCThisEntry.isCopied()) {
                if (nestedWCThisEntry.getCopyFromURL() != null) {
                    copyFromURL = nestedWCThisEntry.getCopyFromURL();
                    copyFromRevision = nestedWCThisEntry.getCopyFromRevision();
                }
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:url", copyFromURL);
                dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            } else {
                copyFromURL = nestedWCThisEntry.getURL();
                copyFromRevision = nestedWCThisEntry.getRevision();
            }
        }
        finally {
            nestedWCAccess.close();
        }
        SVNWCManager.add(nestedWC, parentAccess.getAdminArea(nestedWCParent), SVNURL.parseURIEncoded(copyFromURL), copyFromRevision, SVNDepth.INFINITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyWCToWC(List pairs) throws SVNException {
        String dstParentPath = null;
        for (CopyPair pair : pairs) {
            String dstPath = pair.myDst;
            if (dstParentPath == null) {
                dstParentPath = SVNPathUtil.removeTail(pair.myDst);
            }
            dstParentPath = SVNPathUtil.getCommonPathAncestor(dstParentPath, dstPath);
        }
        SVNWCAccess dstAccess = this.getWCAccess();
        try {
            this.open(dstAccess, new File(dstParentPath), true, false, 0);
            for (CopyPair pair : pairs) {
                this.checkCancelled();
                SVNWCAccess srcAccess = null;
                try {
                    File sourceFile = new File(pair.mySource);
                    this.copyFiles(sourceFile, new File(dstParentPath), dstAccess, pair.myBaseName, false);
                }
                finally {
                    if (srcAccess == null || srcAccess == dstAccess) continue;
                    this.close(srcAccess);
                }
            }
        }
        finally {
            this.close(dstAccess);
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveWCToWC(List pairs) throws SVNException {
        for (CopyPair pair : pairs) {
            this.checkCancelled();
            File srcParent = new File(SVNPathUtil.removeTail(pair.mySource));
            File dstParent = new File(SVNPathUtil.removeTail(pair.myDst));
            File sourceFile = new File(pair.mySource);
            SVNFileType srcType = SVNFileType.getType(sourceFile);
            SVNWCAccess srcAccess = this.createWCAccess();
            SVNWCAccess dstAccess = null;
            try {
                srcAccess.open(srcParent, true, srcType == SVNFileType.DIRECTORY ? -1 : 0);
                if (srcParent.equals(dstParent)) {
                    dstAccess = srcAccess;
                } else {
                    String srcParentPath = srcParent.getAbsolutePath().replace(File.separatorChar, '/');
                    srcParentPath = SVNPathUtil.validateFilePath(srcParentPath);
                    String dstParentPath = dstParent.getAbsolutePath().replace(File.separatorChar, '/');
                    dstParentPath = SVNPathUtil.validateFilePath(dstParentPath);
                    if (srcType == SVNFileType.DIRECTORY && SVNPathUtil.isAncestor(srcParentPath, dstParentPath)) {
                        dstAccess = srcAccess;
                        if (dstAccess.getAdminArea(dstParent) == null) {
                            dstAccess.open(dstParent, true, 0);
                        }
                    } else {
                        dstAccess = this.createWCAccess();
                        dstAccess.open(dstParent, true, 0);
                    }
                }
                this.copyFiles(sourceFile, dstParent, dstAccess, pair.myBaseName, true);
                SVNWCManager.delete(srcAccess, srcAccess.getAdminArea(srcParent), sourceFile, true, true);
            }
            finally {
                if (dstAccess != null && dstAccess != srcAccess) {
                    dstAccess.close();
                }
                srcAccess.close();
            }
        }
        this.sleepForTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFiles(File src, File dstParent, SVNWCAccess dstAccess, String dstName, boolean move) throws SVNException {
        SVNWCAccess srcAccess = this.getWCAccess();
        try {
            SVNFileType srcType;
            SVNErrorMessage err;
            this.probeOpen(srcAccess, src, false, -1);
            SVNEntry dstEntry = dstAccess.getVersionedEntry(dstParent, false);
            SVNEntry srcEntry = srcAccess.getVersionedEntry(src, false);
            if (srcEntry.getRepositoryRoot() != null && dstEntry.getRepositoryRoot() != null && !srcEntry.getRepositoryRoot().equals(dstEntry.getRepositoryRoot())) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", dstParent, srcEntry.getRepositoryRootURL(), dstEntry.getRepositoryRootURL());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dstEntry.isScheduledForDeletion()) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)dstParent);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((srcType = SVNFileType.getType(src)) == SVNFileType.FILE || srcType == SVNFileType.SYMLINK) {
                if (srcEntry.isScheduledForAddition() && (!srcEntry.isCopied() || srcEntry.getCopyFromURL() == null)) {
                    this.copyAddedFileAdm(src, srcAccess, dstAccess, dstParent, dstName, true);
                } else {
                    this.copyFileAdm(src, srcAccess, dstParent, dstAccess, dstName, move);
                }
            } else if (srcType == SVNFileType.DIRECTORY) {
                if (srcEntry.isScheduledForAddition() && (!srcEntry.isCopied() || srcEntry.getCopyFromURL() == null)) {
                    this.copyAddedDirAdm(src, srcAccess, dstParent, dstAccess, dstName, true);
                } else {
                    this.copyDirAdm(src, srcAccess, dstAccess, dstParent, dstName);
                }
            }
        }
        finally {
            this.close(srcAccess);
        }
    }

    private void copyFileAdm(File src, SVNWCAccess srcAccess, File dstParent, SVNWCAccess dstAccess, String dstName, boolean move) throws SVNException {
        long copyFromRevision;
        String copyFromURL;
        SVNEntry srcEntry;
        SVNEntry dstEntry;
        File dst = new File(dstParent, dstName);
        SVNFileType dstType = SVNFileType.getType(dst);
        if (dstType != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already exists and is in the way", (Object)dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((dstEntry = dstAccess.getEntry(dst, false)) != null && !dstEntry.isScheduledForDeletion()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", (Object)dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((srcEntry = srcAccess.getVersionedEntry(src, false)).isScheduledForAddition() && !srcEntry.isCopied() || srcEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNAdminArea srcDir = srcAccess.getAdminArea(src.getParentFile());
        if (srcEntry.isCopied()) {
            SVNLocationEntry location = this.determineCopyFromInfo(src, srcAccess, srcEntry, dstEntry);
            copyFromURL = location.getPath();
            copyFromRevision = location.getRevision();
        } else {
            copyFromURL = srcEntry.getURL();
            copyFromRevision = srcEntry.getRevision();
        }
        String changelistName = srcEntry.getChangelistName();
        File srcBaseFile = new File(src.getParentFile(), SVNAdminUtil.getTextBasePath(src.getName(), false));
        File dstBaseFile = new File(dstParent, SVNAdminUtil.getTextBasePath(dstName, true));
        SVNFileUtil.copyFile(srcBaseFile, dstBaseFile, false);
        SVNVersionedProperties srcBaseProps = srcDir.getBaseProperties(src.getName());
        SVNVersionedProperties srcWorkingProps = srcDir.getProperties(src.getName());
        SVNAdminArea dstDir = dstAccess.getAdminArea(dstParent);
        if (srcWorkingProps.getPropertyValue("svn:special") != null) {
            SVNWCManager.addRepositoryFile(dstDir, dstName, null, srcBaseFile, srcBaseProps.asMap(), srcWorkingProps.asMap(), copyFromURL, copyFromRevision);
            String sourceLinkTarget = SVNFileUtil.getSymlinkName(src);
            String targetLinkTarget = SVNFileUtil.getSymlinkName(dst);
            if (sourceLinkTarget != null && !sourceLinkTarget.equals(targetLinkTarget)) {
                SVNFileUtil.deleteFile(dst);
                SVNFileUtil.createSymlink(dst, sourceLinkTarget);
            }
        } else {
            File tmpWCFile = SVNAdminUtil.createTmpFile(dstDir);
            SVNFileUtil.copyFile(src, tmpWCFile, false);
            SVNWCManager.addRepositoryFile(dstDir, dstName, tmpWCFile, null, srcBaseProps.asMap(), srcWorkingProps.asMap(), copyFromURL, copyFromRevision);
        }
        if (changelistName != null && move && (dstEntry = dstAccess.getEntry(dst, false)) != null) {
            SVNLog log = dstDir.getLog();
            SVNProperties command = new SVNProperties();
            command.put(SVNProperty.shortPropertyName("svn:entry:changelist"), changelistName);
            log.logChangedEntryProperties(dstName, command);
            log.save();
            dstDir.runLogs();
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
        dstAccess.handleEvent(event);
    }

    private void copyAddedFileAdm(File src, SVNWCAccess srcAccess, SVNWCAccess dstAccess, File dstParent, String dstName, boolean isAdded) throws SVNException {
        File dst = new File(dstParent, dstName);
        SVNFileType srcType = SVNFileType.getType(src);
        if (srcType == SVNFileType.SYMLINK) {
            String linkName = SVNFileUtil.getSymlinkName(src);
            SVNFileUtil.createSymlink(dst, linkName);
        } else {
            SVNFileUtil.copyFile(src, dst, false);
        }
        if (isAdded) {
            SVNWCManager.add(dst, dstAccess.getAdminArea(dstParent), null, -1L, SVNDepth.INFINITY);
            this.copyProps(src, dst, srcAccess, dstAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDirAdm(File src, SVNWCAccess srcAccess, SVNWCAccess dstAccess, File dstParent, String dstName) throws SVNException {
        File dst = new File(dstParent, dstName);
        SVNEntry srcEntry = srcAccess.getVersionedEntry(src, false);
        if (srcEntry.isScheduledForAddition() && !srcEntry.isCopied() || srcEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNFileUtil.copyDirectory(src, dst, true, this.getEventDispatcher());
        SVNWCClient16 wcClient = new SVNWCClient16((ISVNAuthenticationManager)null, null);
        wcClient.setEventHandler(this.getEventDispatcher());
        wcClient.doCleanup(dst);
        SVNWCAccess tgtAccess = this.getWCAccess();
        String copyFromURL = null;
        long copyFromRevision = -1L;
        try {
            SVNAdminArea dir = this.open(tgtAccess, dst, true, false, -1);
            SVNCopyDriver.postCopyCleanup(dir);
            if (srcEntry.isCopied()) {
                SVNEntry dstEntry = dstAccess.getEntry(dst, false);
                SVNLocationEntry info = this.determineCopyFromInfo(src, srcAccess, srcEntry, dstEntry);
                copyFromURL = info.getPath();
                copyFromRevision = info.getRevision();
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:url", copyFromURL);
                dir.modifyEntry(dir.getThisDirName(), attributes, true, false);
            } else {
                copyFromURL = srcEntry.getURL();
                copyFromRevision = srcEntry.getRevision();
            }
        }
        finally {
            this.close(tgtAccess);
        }
        SVNWCManager.add(dst, dstAccess.getAdminArea(dstParent), SVNURL.parseURIEncoded(copyFromURL), copyFromRevision, SVNDepth.INFINITY);
    }

    private void copyAddedDirAdm(File src, SVNWCAccess srcAccess, File dstParent, SVNWCAccess dstParentAccess, String dstName, boolean isAdded) throws SVNException {
        File dst = new File(dstParent, dstName);
        if (!isAdded) {
            SVNFileUtil.copyDirectory(src, dst, true, this.getEventDispatcher());
        } else {
            this.checkCancelled();
            dst.mkdirs();
            SVNWCManager.add(dst, dstParentAccess.getAdminArea(dstParent), null, -1L, SVNDepth.INFINITY);
            this.copyProps(src, dst, srcAccess, dstParentAccess);
            SVNAdminArea srcChildArea = srcAccess.retrieve(src);
            File[] entries = SVNFileListUtil.listFiles(src);
            for (int i = 0; entries != null && i < entries.length; ++i) {
                this.checkCancelled();
                File fsEntry = entries[i];
                String name = fsEntry.getName();
                if (SVNFileUtil.getAdminDirectoryName().equals(name)) continue;
                SVNEntry entry = srcChildArea.getEntry(name, true);
                if (fsEntry.isDirectory()) {
                    this.copyAddedDirAdm(fsEntry, srcAccess, dst, dstParentAccess, name, entry != null);
                    continue;
                }
                if (!fsEntry.isFile()) continue;
                this.copyAddedFileAdm(fsEntry, srcAccess, dstParentAccess, dst, name, entry != null);
            }
        }
    }

    private void copyProps(File src, File dst, SVNWCAccess srcAccess, SVNWCAccess dstAccess) throws SVNException {
        SVNEntry srcEntry = srcAccess.getVersionedEntry(src, false);
        SVNAdminArea srcArea = srcEntry.getAdminArea();
        SVNVersionedProperties srcProps = srcArea.getProperties(srcEntry.getName());
        Collection propNames = srcProps.getPropertyNames(null);
        for (String propName : propNames) {
            SVNPropertyValue propValue = srcProps.getPropertyValue(propName);
            SVNPropertiesManager.setProperty(dstAccess, dst, propName, propValue, false);
        }
    }

    private SVNLocationEntry determineCopyFromInfo(File src, SVNWCAccess srcAccess, SVNEntry srcEntry, SVNEntry dstEntry) throws SVNException {
        long rev;
        String url;
        if (srcEntry.getCopyFromURL() != null) {
            url = srcEntry.getCopyFromURL();
            rev = srcEntry.getCopyFromRevision();
        } else {
            SVNLocationEntry info = this.getCopyFromInfoFromParent(src, srcAccess);
            url = info.getPath();
            rev = info.getRevision();
        }
        if (dstEntry != null && rev == dstEntry.getRevision() && url.equals(dstEntry.getCopyFromURL())) {
            url = null;
            rev = -1L;
        }
        return new SVNLocationEntry(rev, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNLocationEntry getCopyFromInfoFromParent(File file, SVNWCAccess access) throws SVNException {
        File parent = file.getParentFile();
        String rest = file.getName();
        String url = null;
        long rev = -1L;
        while (parent != null && url == null) {
            try {
                SVNEntry entry = access.getVersionedEntry(parent, false);
                url = entry.getCopyFromURL();
                rev = entry.getCopyFromRevision();
            }
            catch (SVNException e) {
                SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
                try {
                    this.probeOpen(wcAccess, parent, false, -1);
                    SVNEntry entry = wcAccess.getVersionedEntry(parent, false);
                    url = entry.getCopyFromURL();
                    rev = entry.getCopyFromRevision();
                }
                finally {
                    this.close(wcAccess);
                }
            }
            if (url != null) {
                url = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(rest));
                continue;
            }
            rest = SVNPathUtil.append(parent.getName(), rest);
            parent = parent.getParentFile();
        }
        return new SVNLocationEntry(rev, url);
    }

    private void addLocalParents(File path, ISVNEventHandler handler) throws SVNException {
        boolean created = path.mkdirs();
        SVNWCClient16 wcClient = new SVNWCClient16((ISVNAuthenticationManager)null, null);
        try {
            wcClient.setEventHandler(handler);
            wcClient.doAdd(path, false, false, true, SVNDepth.EMPTY, true, true);
        }
        catch (SVNException e) {
            if (created) {
                SVNFileUtil.deleteAll(path, true);
            }
            throw e;
        }
    }

    private void extendWCMergeInfo(File path, SVNEntry entry, Map mergeInfo, SVNWCAccess access) throws SVNException {
        Map<String, SVNMergeRangeList> wcMergeInfo = SVNPropertiesManager.parseMergeInfo(path, entry, false);
        if (wcMergeInfo != null && mergeInfo != null) {
            wcMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(wcMergeInfo, mergeInfo);
        } else if (wcMergeInfo == null) {
            wcMergeInfo = mergeInfo;
        }
        SVNPropertiesManager.recordWCMergeInfo(path, wcMergeInfo, access);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map calculateTargetMergeInfo(File srcFile, SVNWCAccess access, SVNURL srcURL, long srcRevision, SVNRepository repository, boolean noReposAccess) throws SVNException {
        boolean isLocallyAdded = false;
        SVNEntry entry = null;
        SVNURL url = null;
        if (access != null) {
            entry = access.getVersionedEntry(srcFile, false);
            if (entry.isScheduledForAddition() && !entry.isCopied()) {
                return null;
            }
            if (entry.getCopyFromURL() != null) {
                url = entry.getCopyFromSVNURL();
                srcRevision = entry.getCopyFromRevision();
            } else if (entry.getURL() != null) {
                url = entry.getSVNURL();
                srcRevision = entry.getRevision();
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry for ''{0}'' has no URL", (Object)srcFile);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else {
            url = srcURL;
        }
        Map targetMergeInfo = null;
        if (isLocallyAdded) return targetMergeInfo;
        if (noReposAccess) return this.getWCMergeInfo(srcFile, entry, null, SVNMergeInfoInheritance.INHERITED, false, new boolean[1]);
        SVNRepository repos = repository;
        if (repos == null) {
            repos = this.createRepository(url, null, false);
        }
        SVNURL oldLocation = null;
        try {
            String mergeInfoPath = this.getPathRelativeToSession(url, null, repos);
            if (mergeInfoPath == null) {
                oldLocation = repos.getLocation();
                repos.setLocation(url, false);
                mergeInfoPath = "";
            }
            targetMergeInfo = this.getReposMergeInfo(repos, mergeInfoPath, srcRevision, SVNMergeInfoInheritance.INHERITED, true);
            if (repository == null) {
                repos.closeSession();
                return targetMergeInfo;
            }
            if (oldLocation == null) return targetMergeInfo;
        }
        catch (Throwable throwable) {
            if (repository == null) {
                repos.closeSession();
                throw throwable;
            } else {
                if (oldLocation == null) throw throwable;
                repos.setLocation(oldLocation, false);
            }
            throw throwable;
        }
        repos.setLocation(oldLocation, false);
        return targetMergeInfo;
    }

    private static class CopyPair {
        public String mySource;
        public String myOriginalSource;
        public SVNNodeKind mySourceKind;
        public SVNRevision mySourceRevision;
        public SVNRevision mySourcePegRevision;
        public long mySourceRevisionNumber;
        public String myBaseName;
        public String myDst;

        private CopyPair() {
        }

        public void setSourceRevisions(SVNRevision pegRevision, SVNRevision revision) {
            if (pegRevision == SVNRevision.UNDEFINED) {
                pegRevision = SVNPathUtil.isURL(this.mySource) ? SVNRevision.HEAD : SVNRevision.WORKING;
            }
            if (revision == SVNRevision.UNDEFINED) {
                revision = pegRevision;
            }
            this.mySourceRevision = revision;
            this.mySourcePegRevision = pegRevision;
        }
    }

    private static class CopyPathInfo {
        public String mySourceRelativePath;
        public boolean isDirAdded;
        public boolean isResurrection;
        public SVNNodeKind mySourceKind;
        public String mySource;
        public String mySourcePath;
        public String myDstPath;
        public String myMergeInfoProp;
        public long mySourceRevisionNumber;

        private CopyPathInfo() {
        }
    }

    private static class CopyCommitPathHandler
    implements ISVNCommitPathHandler {
        private Map myPathInfos;
        private boolean myIsMove;

        public CopyCommitPathHandler(Map pathInfos, boolean isMove) {
            this.myPathInfos = pathInfos;
            this.myIsMove = isMove;
        }

        @Override
        public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
            CopyPathInfo pathInfo = (CopyPathInfo)this.myPathInfos.get(commitPath);
            boolean doAdd = false;
            boolean doDelete = false;
            if (pathInfo.isDirAdded) {
                commitEditor.addDir(commitPath, null, -1L);
                return true;
            }
            if (pathInfo.isResurrection) {
                if (!this.myIsMove) {
                    doAdd = true;
                }
            } else if (this.myIsMove) {
                if (commitPath.equals(pathInfo.mySourceRelativePath)) {
                    doDelete = true;
                } else {
                    doAdd = true;
                }
            } else {
                doAdd = true;
            }
            if (doDelete) {
                commitEditor.deleteEntry(commitPath, -1L);
            }
            boolean closeDir = false;
            if (doAdd) {
                SVNPathUtil.checkPathIsValid(commitPath);
                if (pathInfo.mySourceKind == SVNNodeKind.DIR) {
                    commitEditor.addDir(commitPath, pathInfo.mySourcePath, pathInfo.mySourceRevisionNumber);
                    if (pathInfo.myMergeInfoProp != null) {
                        commitEditor.changeDirProperty("svn:mergeinfo", SVNPropertyValue.create(pathInfo.myMergeInfoProp));
                    }
                    closeDir = true;
                } else {
                    commitEditor.addFile(commitPath, pathInfo.mySourcePath, pathInfo.mySourceRevisionNumber);
                    if (pathInfo.myMergeInfoProp != null) {
                        commitEditor.changeFileProperty(commitPath, "svn:mergeinfo", SVNPropertyValue.create(pathInfo.myMergeInfoProp));
                    }
                    commitEditor.closeFile(commitPath, null);
                }
            }
            return closeDir;
        }
    }
}

