/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SVNLogInputStream
extends InputStream {
    private OutputStream myLog;
    private InputStream myIn;

    public SVNLogInputStream(InputStream in, OutputStream log) {
        this.myIn = in;
        this.myLog = log;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.myIn.skip(n);
    }

    @Override
    public void close() throws IOException {
        try {
            this.myIn.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (this.myLog != null) {
                    this.myLog.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        block5: {
            read = this.myIn.read(b, off, len);
            if (read <= 0) break block5;
            try {
                if (this.myLog != null) {
                    this.myLog.write(b, off, read);
                }
            }
            catch (IOException e) {}
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.myIn.read();
        try {
            if (read >= 0 && this.myLog != null) {
                this.myLog.write(read & 0xFF);
            }
        }
        catch (IOException e) {}
        return read;
    }

    public void flushBuffer() {
        try {
            if (this.myLog != null) {
                this.myLog.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

