/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long myBytesRead = 0L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public long getBytesRead() {
        return this.myBytesRead;
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r > 0) {
            ++this.myBytesRead;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count = super.read(b);
        if (count > 0) {
            this.myBytesRead += (long)count;
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (count > 0) {
            this.myBytesRead += (long)count;
        }
        return count;
    }
}

