/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.svn.ssh;

import afu.com.trilead.ssh2.ServerHostKeyVerifier;
import afu.com.trilead.ssh2.auth.AgentProxy;
import afu.org.tmatesoft.svn.core.internal.io.svn.ssh.SshHost;
import afu.org.tmatesoft.svn.core.internal.io.svn.ssh.SshHostDisposedException;
import afu.org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class SshSessionPool {
    private static final long PURGE_INTERVAL = 10000L;
    private Map<String, SshHost> myPool = new HashMap<String, SshHost>();
    private Timer myTimer = new Timer(true);

    public SshSessionPool() {
        this.myTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = SshSessionPool.this.myPool;
                synchronized (map) {
                    ArrayList hosts = new ArrayList(SshSessionPool.this.myPool.values());
                    for (SshHost host : hosts) {
                        if (host.purge()) {
                            SshSessionPool.this.myPool.remove(host.getKey());
                        }
                        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SSH pool, purged: " + host);
                    }
                }
            }
        }, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<String, SshHost> map = this.myPool;
        synchronized (map) {
            ArrayList<SshHost> hosts = new ArrayList<SshHost>(this.myPool.values());
            for (SshHost host : hosts) {
                try {
                    host.lock();
                    host.setDisposed(true);
                    this.myPool.remove(host.getKey());
                }
                finally {
                    host.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshSession openSession(String host, int port, String userName, char[] privateKey, char[] passphrase, char[] password, AgentProxy agentProxy, ServerHostKeyVerifier verifier, int connectTimeout, int readTimeout) throws IOException {
        SshHost newHost = new SshHost(host, port);
        newHost.setCredentials(userName, privateKey, passphrase, password, agentProxy);
        newHost.setConnectionTimeout(connectTimeout);
        newHost.setHostVerifier(verifier);
        newHost.setReadTimeout(readTimeout);
        SshSession session = null;
        String hostKey = newHost.getKey();
        while (session == null) {
            SshHost sshHost;
            Map<String, SshHost> map = this.myPool;
            synchronized (map) {
                sshHost = this.myPool.get(hostKey);
                if (sshHost == null) {
                    sshHost = newHost;
                    this.myPool.put(hostKey, newHost);
                }
            }
            try {
                session = sshHost.openSession();
                break;
            }
            catch (SshHostDisposedException e) {
                Map<String, SshHost> map2 = this.myPool;
                synchronized (map2) {
                    this.myPool.remove(hostKey);
                }
            }
        }
        return session;
    }
}

