/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.svn.ssh;

import afu.com.trilead.ssh2.Connection;
import afu.com.trilead.ssh2.Session;
import afu.org.tmatesoft.svn.core.internal.io.svn.ssh.SshHost;
import afu.org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import java.io.IOException;

public class SshConnection {
    private Connection myConnection;
    private volatile int mySessionCount;
    private SshHost myHost;
    private long myLastAccessTime;

    public SshConnection(SshHost host, Connection connection) {
        this.myHost = host;
        this.myConnection = connection;
        this.myLastAccessTime = System.currentTimeMillis();
    }

    public SshSession openSession() throws IOException {
        Session session = this.myConnection.openSession();
        if (session != null) {
            ++this.mySessionCount;
            return new SshSession(this, session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(SshSession sshSession) {
        this.myHost.lock();
        try {
            this.myLastAccessTime = System.currentTimeMillis();
            --this.mySessionCount;
        }
        finally {
            this.myHost.unlock();
        }
    }

    public int getSessionsCount() {
        return this.mySessionCount;
    }

    public void close() {
        this.myConnection.close();
        this.mySessionCount = 0;
    }

    public long lastAcccessTime() {
        return this.myLastAccessTime;
    }
}

