/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.svn;

import java.io.UnsupportedEncodingException;
import java.util.Collection;

public class SVNItem {
    public static final int WORD = 0;
    public static final int BYTES = 1;
    public static final int LIST = 2;
    public static final int NUMBER = 3;
    private int myKind;
    private long myNumber = -1L;
    private String myWord;
    private byte[] myLine;
    private Collection myItems;

    public int getKind() {
        return this.myKind;
    }

    public void setKind(int kind) {
        this.myKind = kind;
    }

    public long getNumber() {
        return this.myNumber;
    }

    public void setNumber(long number) {
        this.myNumber = number;
    }

    public String getWord() {
        return this.myWord;
    }

    public void setWord(String word) {
        this.myWord = word;
    }

    public byte[] getBytes() {
        return this.myLine;
    }

    public void setLine(byte[] line) {
        this.myLine = line;
    }

    public Collection getItems() {
        return this.myItems;
    }

    public void setItems(Collection items) {
        this.myItems = items;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.myKind == 0) {
            result.append("W").append(this.myWord);
        } else if (this.myKind == 1) {
            result.append("S").append(this.myLine.length).append(":");
            try {
                result.append(new String(this.myLine, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                result.append(this.myLine);
            }
            result.append(" ");
        } else if (this.myKind == 3) {
            result.append("N").append(this.myNumber);
        } else if (this.myKind == 2) {
            result.append("L(");
            for (SVNItem item : this.myItems) {
                result.append(item.toString());
                result.append(" ");
            }
            result.append(") ");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            if (this.myKind == 0) {
                return this.myWord.equals(o);
            }
            if (this.myKind == 1) {
                return this.myLine.equals(o);
            }
            return false;
        }
        if (o instanceof byte[]) {
            if (this.myKind == 0) {
                return this.myWord.getBytes().equals(o);
            }
            if (this.myKind == 1) {
                return this.myLine.equals(o);
            }
            return false;
        }
        if (o instanceof Long) {
            long value = (Long)o;
            return this.myKind == 3 && this.myNumber == value;
        }
        if (o instanceof Integer) {
            long value = ((Integer)o).longValue();
            return this.myKind == 3 && this.myNumber == value;
        }
        if (o instanceof Collection) {
            return this.myKind == 2 && ((Object)this.myItems).equals(o);
        }
        return super.equals(o);
    }
}

