/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.svn;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.auth.SVNAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import afu.org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public abstract class SVNAuthenticator {
    protected static final String SUCCESS = "success";
    protected static final String FAILURE = "failure";
    protected static final String STEP = "step";
    private SVNConnection myConnection;
    private OutputStream myConnectionOutputStream;
    private InputStream myConnectionInputStream;
    private SVNErrorMessage myLastError;
    private InputStream myPlainInputStream;
    private OutputStream myPlainOutputStream;

    protected SVNAuthenticator(SVNConnection connection) throws SVNException {
        this.myConnection = connection;
        this.myConnectionInputStream = connection.getInputStream();
        this.myConnectionOutputStream = connection.getOutputStream();
        try {
            this.myPlainInputStream = connection.getConnector().getInputStream();
            this.myPlainOutputStream = connection.getConnector().getOutputStream();
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    protected void setOutputStream(OutputStream os) {
        this.myConnection.setOutputStream(os);
    }

    protected void setInputStream(InputStream is) {
        this.myConnection.setInputStream(is);
    }

    protected InputStream getConnectionInputStream() {
        return this.myConnectionInputStream;
    }

    protected OutputStream getConnectionOutputStream() {
        return this.myConnectionOutputStream;
    }

    protected InputStream getPlainInputStream() {
        return this.myPlainInputStream;
    }

    protected OutputStream getPlainOutputStream() {
        return this.myPlainOutputStream;
    }

    protected SVNConnection getConnection() {
        return this.myConnection;
    }

    protected SVNErrorMessage getLastError() {
        return this.myLastError;
    }

    public void dispose() {
    }

    protected void setLastError(SVNErrorMessage err) {
        this.myLastError = err;
    }

    public abstract SVNAuthentication authenticate(List var1, String var2, SVNRepositoryImpl var3) throws SVNException;
}

