/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.svn;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import afu.org.tmatesoft.svn.core.internal.io.svn.SVNPlainConnector;
import afu.org.tmatesoft.svn.core.internal.io.svn.SVNSSHConnector;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.util.SVNLogType;

public interface ISVNConnectorFactory {
    public static final ISVNConnectorFactory DEFAULT = new ISVNConnectorFactory(){

        @Override
        public ISVNConnector createConnector(SVNRepository repository) throws SVNException {
            SVNURL location = repository.getLocation();
            if ("svn+ssh".equals(location.getProtocol())) {
                return new SVNSSHConnector();
            }
            if (location.getProtocol().startsWith("svn+")) {
                ISVNConnector connector;
                String name = location.getProtocol().substring("svn+".length());
                if (repository.getTunnelProvider() != null && (connector = repository.getTunnelProvider().createTunnelConnector(location)) != null) {
                    return connector;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "Cannot find tunnel specification for ''{0}''", (Object)name);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            return new SVNPlainConnector();
        }
    };

    public ISVNConnector createConnector(SVNRepository var1) throws SVNException;
}

