/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs.repcache;

import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetTable;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import afu.org.tmatesoft.sqljet.core.table.SqlJetDb;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSFS;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import afu.org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import afu.org.tmatesoft.svn.core.internal.io.fs.IFSSqlJetTransaction;
import afu.org.tmatesoft.svn.core.internal.io.fs.repcache.FSEmptyRepresentationCacheManager;
import afu.org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheRecord;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;

public class FSRepresentationCacheManager
implements IFSRepresentationCacheManager {
    public static final String REP_CACHE_TABLE = "rep_cache";
    private static final int REP_CACHE_DB_FORMAT = 1;
    private static final String REP_CACHE_DB_SQL = "create table rep_cache (hash text not null primary key,                         revision integer not null,                         offset integer not null,                         size integer not null,                         expanded_size integer not null); ";
    private SqlJetDb myRepCacheDB;
    private ISqlJetTable myTable;
    private FSFS myFSFS;

    public static IFSRepresentationCacheManager openRepresentationCache(FSFS fsfs) throws SVNException {
        FSRepresentationCacheManager cacheObj = new FSRepresentationCacheManager();
        try {
            cacheObj.myRepCacheDB = SqlJetDb.open(fsfs.getRepositoryCacheFile(), true);
            cacheObj.myRepCacheDB.setSafetyLevel(SqlJetSafetyLevel.OFF);
            FSRepresentationCacheManager.checkFormat(cacheObj.myRepCacheDB);
            cacheObj.myTable = cacheObj.myRepCacheDB.getTable(REP_CACHE_TABLE);
        }
        catch (SqlJetException e) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
            return new FSEmptyRepresentationCacheManager();
        }
        return cacheObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRepresentationCache(File path) throws SVNException {
        SqlJetDb db = null;
        try {
            db = SqlJetDb.open(path, true);
            FSRepresentationCacheManager.checkFormat(db);
        }
        catch (SqlJetException e) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.FSFS, e);
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (SqlJetException e) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, e);
                }
            }
        }
    }

    private static void checkFormat(SqlJetDb db) throws SqlJetException {
        db.runWithLock(new ISqlJetRunnableWithLock(){

            @Override
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                int version2 = db.getOptions().getUserVersion();
                if (version2 < 1) {
                    db.getOptions().setAutovacuum(true);
                    db.runWriteTransaction(new ISqlJetTransaction(){

                        @Override
                        public Object run(SqlJetDb db) throws SqlJetException {
                            db.getOptions().setUserVersion(1);
                            db.createTable(FSRepresentationCacheManager.REP_CACHE_DB_SQL);
                            return null;
                        }
                    });
                } else if (version2 > 1) {
                    throw new SqlJetException("Schema format " + version2 + " not recognized");
                }
                return null;
            }
        });
    }

    @Override
    public void insert(FSRepresentation representation, boolean rejectDup) throws SVNException {
        FSRepresentation oldRep;
        if (representation.getSHA1HexDigest() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_CHECKSUM_KIND, "Only SHA1 checksums can be used as keys in the rep_cache table.\n");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((oldRep = this.getRepresentationByHash(representation.getSHA1HexDigest())) != null) {
            if (rejectDup && (oldRep.getRevision() != representation.getRevision() || oldRep.getOffset() != representation.getOffset() || oldRep.getSize() != representation.getSize() || oldRep.getExpandedSize() != representation.getExpandedSize())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Representation key for checksum ''{0}'' exists in filesystem ''{1}'' with a different value ({2},{3},{4},{5}) than what we were about to store ({6},{7},{8},{9})", representation.getSHA1HexDigest(), this.myFSFS.getRepositoryRoot(), String.valueOf(oldRep.getRevision()), String.valueOf(oldRep.getOffset()), String.valueOf(oldRep.getSize()), String.valueOf(oldRep.getExpandedSize()), String.valueOf(representation.getRevision()), String.valueOf(representation.getOffset()), String.valueOf(representation.getSize()), String.valueOf(representation.getExpandedSize()));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            return;
        }
        try {
            this.myTable.insert(representation.getSHA1HexDigest(), new Long(representation.getRevision()), new Long(representation.getOffset()), new Long(representation.getSize()), new Long(representation.getExpandedSize()));
        }
        catch (SqlJetException e) {
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SVNException {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.close();
            }
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            }
            finally {
                this.myTable = null;
                this.myRepCacheDB = null;
                this.myFSFS = null;
            }
        }
    }

    @Override
    public FSRepresentation getRepresentationByHash(String hash) throws SVNException {
        FSRepresentationCacheRecord cache = this.getByHash(hash);
        if (cache != null) {
            FSRepresentation representation = new FSRepresentation();
            representation.setExpandedSize(cache.getExpandedSize());
            representation.setOffset(cache.getOffset());
            representation.setRevision(cache.getRevision());
            representation.setSize(cache.getSize());
            representation.setSHA1HexDigest(cache.getHash());
            return representation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSRepresentationCacheRecord getByHash(String hash) throws SVNException {
        ISqlJetCursor lookup = null;
        try {
            lookup = this.myTable.lookup(this.myTable.getPrimaryKeyIndexName(), hash);
            if (!lookup.eof()) {
                FSRepresentationCacheRecord fSRepresentationCacheRecord = new FSRepresentationCacheRecord(lookup);
                return fSRepresentationCacheRecord;
            }
        }
        catch (SqlJetException e) {
            SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
        }
        finally {
            if (lookup != null) {
                try {
                    lookup.close();
                }
                catch (SqlJetException e) {
                    SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
                }
            }
        }
        return null;
    }

    private static SVNErrorMessage convertError(SqlJetException e) {
        SVNErrorMessage err = SVNErrorMessage.create(FSRepresentationCacheManager.convertErrorCode(e), e.getMessage());
        return err;
    }

    private static SVNErrorCode convertErrorCode(SqlJetException e) {
        SqlJetErrorCode sqlCode = e.getErrorCode();
        if (sqlCode == SqlJetErrorCode.READONLY) {
            return SVNErrorCode.SQLITE_READONLY;
        }
        return SVNErrorCode.SQLITE_ERROR;
    }

    @Override
    public void runWriteTransaction(final IFSSqlJetTransaction transaction) throws SVNException {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.runWriteTransaction(new ISqlJetTransaction(){

                    @Override
                    public Object run(SqlJetDb db) throws SqlJetException {
                        try {
                            transaction.run();
                        }
                        catch (SVNException e) {
                            throw new SqlJetException(e);
                        }
                        return null;
                    }
                });
            }
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            }
        }
    }

    @Override
    public void runReadTransaction(final IFSSqlJetTransaction transaction) throws SVNException {
        if (this.myRepCacheDB != null) {
            try {
                this.myRepCacheDB.runReadTransaction(new ISqlJetTransaction(){

                    @Override
                    public Object run(SqlJetDb db) throws SqlJetException {
                        try {
                            transaction.run();
                        }
                        catch (SVNException e) {
                            throw new SqlJetException(e);
                        }
                        return null;
                    }
                });
            }
            catch (SqlJetException e) {
                SVNErrorManager.error(FSRepresentationCacheManager.convertError(e), SVNLogType.FSFS);
            }
        }
    }
}

