/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSFS;
import afu.org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import afu.org.tmatesoft.svn.core.internal.io.fs.repcache.IFSRepresentationCacheManagerFactory;
import afu.org.tmatesoft.svn.core.internal.wc.SVNClassLoader;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;

public class FSRepresentationCacheUtil {
    private static volatile boolean ourIsAvailable;
    private static final String SQLJET_DB_CLASS_NAME = "afu.org.tmatesoft.sqljet.core.table.SqlJetDb";
    private static final String ANTLR_CLASS_NAME = "afu.org.antlr.runtime.Token";
    private static IFSRepresentationCacheManagerFactory ourRepCacheManagerFactory;

    public static IFSRepresentationCacheManager open(FSFS fsfs) throws SVNException {
        if (!FSRepresentationCacheUtil.isAvailable()) {
            return null;
        }
        if (ourRepCacheManagerFactory != null) {
            return ourRepCacheManagerFactory.openRepresentationCache(fsfs);
        }
        return null;
    }

    public static void create(File path) throws SVNException {
        if (!FSRepresentationCacheUtil.isAvailable()) {
            return;
        }
        if (ourRepCacheManagerFactory != null) {
            ourRepCacheManagerFactory.createRepresentationCache(path);
        }
    }

    private static boolean isAvailable() {
        return ourIsAvailable;
    }

    static {
        block6: {
            Boolean option = Boolean.valueOf(System.getProperty("svnkit.fsfs.repcache", "true"));
            if (option.booleanValue()) {
                try {
                    Class<?> antlrClazz = FSRepresentationCacheUtil.class.getClassLoader().loadClass(ANTLR_CLASS_NAME);
                    if (antlrClazz == null) {
                        ourIsAvailable = false;
                        break block6;
                    }
                    Class<?> clazz = FSRepresentationCacheUtil.class.getClassLoader().loadClass(SQLJET_DB_CLASS_NAME);
                    boolean bl = ourIsAvailable = clazz != null;
                    if (!ourIsAvailable) break block6;
                    ourRepCacheManagerFactory = SVNClassLoader.getFSRepresentationCacheManagerFactory();
                    if (ourRepCacheManagerFactory != null) {
                        ourIsAvailable = true;
                        break block6;
                    }
                    ourIsAvailable = false;
                }
                catch (Throwable e) {
                    ourIsAvailable = false;
                }
            } else {
                ourIsAvailable = false;
            }
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "SQLJET enabled: " + ourIsAvailable);
    }
}

