/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

public class FSRepresentation {
    public static final String REP_DELTA = "DELTA";
    public static final String REP_PLAIN = "PLAIN";
    public static final String REP_TRAILER = "ENDREP";
    private long myRevision;
    private long myOffset;
    private long mySize;
    private long myExpandedSize;
    private String myMD5HexDigest;
    private String mySHA1HexDigest;
    private String myTxnId;
    private String myUniquifier;

    public FSRepresentation(FSRepresentation representation) {
        this.myRevision = representation.myRevision;
        this.myOffset = representation.myOffset;
        this.mySize = representation.mySize;
        this.myExpandedSize = representation.myExpandedSize;
        this.myMD5HexDigest = representation.myMD5HexDigest;
        this.mySHA1HexDigest = representation.mySHA1HexDigest;
        this.myUniquifier = representation.myUniquifier;
        this.myTxnId = representation.myTxnId;
    }

    public FSRepresentation() {
        this.myRevision = -1L;
        this.myOffset = -1L;
        this.mySize = -1L;
        this.myExpandedSize = -1L;
    }

    public void setRevision(long rev) {
        this.myRevision = rev;
    }

    public void setOffset(long offset) {
        this.myOffset = offset;
    }

    public void setSize(long size) {
        this.mySize = size;
    }

    public void setExpandedSize(long expandedSize) {
        this.myExpandedSize = expandedSize;
    }

    public void setMD5HexDigest(String hexDigest) {
        this.myMD5HexDigest = hexDigest;
    }

    public String getSHA1HexDigest() {
        return this.mySHA1HexDigest;
    }

    public void setSHA1HexDigest(String hexDigest) {
        this.mySHA1HexDigest = hexDigest;
    }

    public String getUniquifier() {
        return this.myUniquifier;
    }

    public void setUniquifier(String uniquifier) {
        this.myUniquifier = uniquifier;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public long getSize() {
        return this.mySize;
    }

    public long getExpandedSize() {
        return this.myExpandedSize;
    }

    public String getMD5HexDigest() {
        return this.myMD5HexDigest;
    }

    public static boolean compareRepresentations(FSRepresentation r1, FSRepresentation r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != FSRepresentation.class) {
            return false;
        }
        FSRepresentation rep = (FSRepresentation)obj;
        if (this.myRevision != rep.myRevision) {
            return false;
        }
        if (this.myOffset != rep.myOffset) {
            return false;
        }
        if (this.myUniquifier == rep.myUniquifier) {
            return true;
        }
        if (this.myUniquifier == null || rep.myUniquifier == null) {
            return false;
        }
        return this.myUniquifier.equals(rep.myUniquifier);
    }

    public String getStringRepresentation(int dbFormat) {
        if (dbFormat < 4 || this.mySHA1HexDigest == null || this.myUniquifier == null) {
            return this.myRevision + " " + this.myOffset + " " + this.mySize + " " + this.myExpandedSize + " " + this.myMD5HexDigest;
        }
        return this.myRevision + " " + this.myOffset + " " + this.mySize + " " + this.myExpandedSize + " " + this.myMD5HexDigest + " " + this.mySHA1HexDigest + " " + this.myUniquifier;
    }

    public String getTxnId() {
        return this.myTxnId;
    }

    public void setTxnId(String txnId) {
        this.myTxnId = txnId;
    }

    public boolean isTxn() {
        return this.myTxnId != null;
    }
}

