/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class FSParentPath {
    private FSRevisionNode myRevNode;
    private String myEntryName;
    private FSParentPath myParent;
    private FSCopyInheritance myCopyInheritance;

    public FSParentPath(FSParentPath newParentPath) {
        this.myRevNode = newParentPath.myRevNode;
        this.myEntryName = newParentPath.myEntryName;
        this.myParent = newParentPath.myParent;
        this.myCopyInheritance = newParentPath.myCopyInheritance;
    }

    public FSParentPath(FSRevisionNode newRevNode, String newEntry, FSParentPath newParentPath) {
        this.myRevNode = newRevNode;
        this.myEntryName = newEntry;
        this.myParent = newParentPath;
        this.myCopyInheritance = newRevNode != null ? new FSCopyInheritance(0, newRevNode.getCopyFromPath()) : new FSCopyInheritance(0, null);
    }

    public FSRevisionNode getRevNode() {
        return this.myRevNode;
    }

    public void setRevNode(FSRevisionNode newRevNode) {
        this.myRevNode = newRevNode;
    }

    public String getEntryName() {
        return this.myEntryName;
    }

    public FSParentPath getParent() {
        return this.myParent;
    }

    public int getCopyStyle() {
        return this.myCopyInheritance.getStyle();
    }

    public void setCopyStyle(int newCopyStyle) {
        this.myCopyInheritance.setStyle(newCopyStyle);
    }

    public String getCopySourcePath() {
        return this.myCopyInheritance.getCopySourcePath();
    }

    public void setCopySourcePath(String newCopyPath) {
        this.myCopyInheritance.setCopySourcePath(newCopyPath);
    }

    public void setParentPath(FSRevisionNode newRevNode, String newEntry, FSParentPath newParentPath) {
        this.myRevNode = newRevNode;
        this.myEntryName = newEntry;
        this.myParent = newParentPath;
        this.myCopyInheritance = new FSCopyInheritance(0, null);
    }

    public String getAbsPath() throws SVNException {
        String pathSoFar = "/";
        if (this.myParent != null) {
            pathSoFar = this.myParent.getAbsPath();
        }
        return SVNPathUtil.getAbsolutePath(SVNPathUtil.append(pathSoFar, this.getEntryName()));
    }

    public String getRelativePath(FSParentPath ancestor) {
        String pathSoFar = "";
        for (FSParentPath thisNode = this; thisNode != ancestor; thisNode = thisNode.getParent()) {
            pathSoFar = SVNPathUtil.append(thisNode.getEntryName(), pathSoFar);
        }
        return pathSoFar;
    }
}

