/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSFS;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSID;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.io.SVNLocationEntry;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;

public class FSNodeHistory {
    private SVNLocationEntry myHistoryEntry;
    private SVNLocationEntry mySearchResumeEntry;
    private boolean myIsInteresting;
    private FSFS myFSFS;

    public FSNodeHistory(SVNLocationEntry newHistoryEntry, boolean interesting, SVNLocationEntry newSearchResumeEntry, FSFS owner) {
        this.myHistoryEntry = newHistoryEntry;
        this.mySearchResumeEntry = newSearchResumeEntry;
        this.myIsInteresting = interesting;
        this.myFSFS = owner;
    }

    public SVNLocationEntry getHistoryEntry() {
        return this.myHistoryEntry;
    }

    public static SVNLocationEntry findYoungestCopyroot(File reposRootDir, FSParentPath parPath) throws SVNException {
        SVNLocationEntry parentEntry = null;
        if (parPath.getParent() != null) {
            parentEntry = FSNodeHistory.findYoungestCopyroot(reposRootDir, parPath.getParent());
        }
        SVNLocationEntry myEntry = new SVNLocationEntry(parPath.getRevNode().getCopyRootRevision(), parPath.getRevNode().getCopyRootPath());
        if (parentEntry != null) {
            if (myEntry.getRevision() >= parentEntry.getRevision()) {
                return myEntry;
            }
            return parentEntry;
        }
        return myEntry;
    }

    public static boolean checkAncestryOfPegPath(String fsPath, long pegRev, long futureRev, FSFS owner) throws SVNException {
        FSRevisionRoot root = owner.createRevisionRoot(futureRev);
        FSNodeHistory history = root.getNodeHistory(fsPath);
        fsPath = null;
        SVNLocationEntry currentHistory = null;
        while ((history = history.getPreviousHistory(true)) != null) {
            currentHistory = new SVNLocationEntry(history.getHistoryEntry().getRevision(), history.getHistoryEntry().getPath());
            if (fsPath == null) {
                fsPath = currentHistory.getPath();
            }
            if (currentHistory.getRevision() > pegRev) continue;
        }
        if (fsPath == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error occurred while checking ancestry of peg path");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return history != null && fsPath.equals(currentHistory.getPath());
    }

    private FSNodeHistory historyPrev(boolean crossCopies) throws SVNException {
        String path = this.myHistoryEntry.getPath();
        long revision = this.myHistoryEntry.getRevision();
        boolean reported = this.myIsInteresting;
        if (this.mySearchResumeEntry != null && this.mySearchResumeEntry.getPath() != null && FSRepository.isValidRevision(this.mySearchResumeEntry.getRevision())) {
            reported = false;
            if (!crossCopies) {
                return null;
            }
            path = this.mySearchResumeEntry.getPath();
            revision = this.mySearchResumeEntry.getRevision();
        }
        FSRevisionRoot root = this.myFSFS.createRevisionRoot(revision);
        FSParentPath parentPath = root.openPath(path, true, true);
        FSRevisionNode revNode = parentPath.getRevNode();
        SVNLocationEntry commitEntry = new SVNLocationEntry(revNode.getCreatedRevision(), revNode.getCreatedPath());
        FSNodeHistory prevHist = null;
        if (revision == commitEntry.getRevision()) {
            if (!reported) {
                prevHist = new FSNodeHistory(commitEntry, true, new SVNLocationEntry(-1L, null), this.myFSFS);
                return prevHist;
            }
            FSID predId = revNode.getPredecessorId();
            if (predId == null) {
                return prevHist;
            }
            revNode = this.myFSFS.getRevisionNode(predId);
            commitEntry = new SVNLocationEntry(revNode.getCreatedRevision(), revNode.getCreatedPath());
        }
        SVNLocationEntry copyrootEntry = FSNodeHistory.findYoungestCopyroot(this.myFSFS.getRepositoryRoot(), parentPath);
        SVNLocationEntry srcEntry = new SVNLocationEntry(-1L, null);
        long dstRev = -1L;
        if (copyrootEntry.getRevision() > commitEntry.getRevision()) {
            FSRevisionRoot copyrootRoot = this.myFSFS.createRevisionRoot(copyrootEntry.getRevision());
            revNode = copyrootRoot.getRevisionNode(copyrootEntry.getPath());
            String copyDst = revNode.getCreatedPath();
            String reminder = null;
            reminder = path.equals(copyDst) ? "" : SVNPathUtil.getPathAsChild(copyDst, path);
            if (reminder != null) {
                String copySrc = revNode.getCopyFromPath();
                srcEntry = new SVNLocationEntry(revNode.getCopyFromRevision(), SVNPathUtil.getAbsolutePath(SVNPathUtil.append(copySrc, reminder)));
                dstRev = copyrootEntry.getRevision();
            }
        }
        if (srcEntry.getPath() != null && FSRepository.isValidRevision(srcEntry.getRevision())) {
            boolean retry = false;
            if (dstRev == revision && reported) {
                retry = true;
            }
            return new FSNodeHistory(new SVNLocationEntry(dstRev, path), !retry, new SVNLocationEntry(srcEntry.getRevision(), srcEntry.getPath()), this.myFSFS);
        }
        return new FSNodeHistory(commitEntry, true, new SVNLocationEntry(-1L, null), this.myFSFS);
    }

    public FSNodeHistory getPreviousHistory(boolean crossCopies) throws SVNException {
        if ("/".equals(this.myHistoryEntry.getPath())) {
            if (!this.myIsInteresting) {
                return new FSNodeHistory(new SVNLocationEntry(this.myHistoryEntry.getRevision(), "/"), true, new SVNLocationEntry(-1L, null), this.myFSFS);
            }
            if (this.myHistoryEntry.getRevision() > 0L) {
                return new FSNodeHistory(new SVNLocationEntry(this.myHistoryEntry.getRevision() - 1L, "/"), true, new SVNLocationEntry(-1L, null), this.myFSFS);
            }
        } else {
            FSNodeHistory prevHist = this;
            do {
                if ((prevHist = prevHist.historyPrev(crossCopies)) != null) continue;
                return null;
            } while (!prevHist.myIsInteresting);
            return prevHist;
        }
        return null;
    }
}

