/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.http;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class HTTPBodyInputStream
extends InputStream {
    private File myFile;
    private InputStream myDelegate;

    public HTTPBodyInputStream(File file) {
        this.myFile = file;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getDelegate().read(b);
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.myDelegate != null) {
            try {
                this.getDelegate().close();
            }
            finally {
                this.myDelegate = null;
            }
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.close();
    }

    private InputStream getDelegate() throws IOException {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = SVNFileUtil.openFileForReading(this.myFile, SVNLogType.NETWORK);
            }
            catch (SVNException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e.getMessage());
            }
        }
        return this.myDelegate;
    }
}

