/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.http;

import afu.org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import afu.org.tmatesoft.svn.core.internal.util.SVNBase64;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class HTTPBasicAuthentication
extends HTTPAuthentication {
    private String myCharset;

    public HTTPBasicAuthentication(SVNPasswordAuthentication credentials, String charset) {
        super(credentials);
        this.myCharset = charset;
    }

    protected HTTPBasicAuthentication(String name, char[] password, String charset) {
        super(name, password);
        this.myCharset = charset;
    }

    protected HTTPBasicAuthentication(String charset) {
        this.myCharset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate() {
        if (this.getUserName() == null || this.getPassword() == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        ByteArrayStream bos = new ByteArrayStream();
        try {
            bos.write(SVNEncodingUtil.getBytes(this.getUserName().toCharArray(), this.myCharset));
            bos.write(SVNEncodingUtil.getBytes(new char[]{':'}, this.myCharset));
            bos.write(SVNEncodingUtil.getBytes(this.getPassword(), this.myCharset));
        }
        catch (IOException e) {
            // empty catch block
        }
        result.append("Basic ");
        byte[] bytes = bos.toByteArray();
        try {
            result.append(SVNBase64.byteArrayToBase64(bos.toByteArray()));
        }
        finally {
            SVNEncodingUtil.clearArray(bos.getBuffer());
            SVNEncodingUtil.clearArray(bytes);
        }
        return result.toString();
    }

    @Override
    public String getAuthenticationScheme() {
        return "Basic";
    }

    private static class ByteArrayStream
    extends ByteArrayOutputStream {
        private ByteArrayStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

