/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.http;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import afu.org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPNegotiateAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPApacheNTLMAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPNativeNTLMAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.IHTTPNegotiateAuthenticationFactory;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

abstract class HTTPAuthentication {
    private Map<String, String> myChallengeParameters;
    private String myUserName;
    private char[] myPassword;
    private static final String AUTH_METHODS_PROPERTY = "svnkit.http.methods";
    private static final String OLD_AUTH_METHODS_PROPERTY = "javasvn.http.methods";

    protected HTTPAuthentication(SVNPasswordAuthentication credentials) {
        if (credentials != null) {
            this.myUserName = credentials.getUserName();
            this.myPassword = credentials.getPasswordValue();
        }
    }

    protected HTTPAuthentication(String name, char[] password) {
        this.myUserName = name;
        this.myPassword = password;
    }

    protected HTTPAuthentication() {
    }

    public void setChallengeParameter(String name, String value) {
        Map<String, String> params = this.getChallengeParameters();
        params.put(name, value);
    }

    public String getChallengeParameter(String name) {
        if (this.myChallengeParameters == null) {
            return null;
        }
        return this.myChallengeParameters.get(name);
    }

    protected Map<String, String> getChallengeParameters() {
        if (this.myChallengeParameters == null) {
            this.myChallengeParameters = new TreeMap<String, String>();
        }
        return this.myChallengeParameters;
    }

    public void setCredentials(SVNPasswordAuthentication credentials) {
        if (credentials != null) {
            this.myUserName = credentials.getUserName();
            this.myPassword = credentials.getPasswordValue();
        }
    }

    public String getRawUserName() {
        return this.myUserName;
    }

    public String getUserName() {
        return this.myUserName;
    }

    public char[] getPassword() {
        return this.myPassword;
    }

    public void setUserName(String name) {
        this.myUserName = name;
    }

    public void setPassword(char[] password) {
        this.myPassword = password;
    }

    public static HTTPAuthentication parseAuthParameters(Collection<String> authHeaderValues, HTTPAuthentication prevResponse, String charset, Collection<String> authTypes, ISVNAuthenticationManager authManager, int requestID) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        HTTPAuthentication auth = null;
        String authHeader2 = null;
        authHeaderValues = HTTPAuthentication.sortSchemes(authHeaderValues, authTypes);
        for (String authHeader2 : authHeaderValues) {
            String source = authHeader2.trim();
            int index = source.indexOf(32);
            if (index <= 0 && !"NTLM".equalsIgnoreCase(source.substring(0, index = source.length())) && !"Negotiate".equalsIgnoreCase(source.substring(0, index))) continue;
            String method = source.substring(0, index);
            source = source.substring(index).trim();
            if ("Basic".equalsIgnoreCase(method)) {
                auth = new HTTPBasicAuthentication(charset);
                if (source.indexOf("realm=") < 0) break;
                source = source.substring(source.indexOf("realm=") + "realm=".length());
                if ((source = source.trim()).startsWith("\"")) {
                    source = source.substring(1);
                }
                if (source.endsWith("\"")) {
                    source = source.substring(0, source.length() - 1);
                }
                auth.setChallengeParameter("realm", source);
                break;
            }
            if ("Digest".equalsIgnoreCase(method)) {
                auth = new HTTPDigestAuthentication(charset);
                char[] chars = (source + " ").toCharArray();
                int tokenIndex = 0;
                boolean parsingToken = true;
                String name = null;
                int quotesCount = 0;
                for (int i = 0; i < chars.length; ++i) {
                    if (parsingToken) {
                        if (chars[i] != '=') continue;
                        name = new String(chars, tokenIndex, i - tokenIndex);
                        name = name.trim();
                        tokenIndex = i + 1;
                        parsingToken = false;
                        continue;
                    }
                    if (chars[i] == '\"') {
                        quotesCount = quotesCount > 0 ? 0 : 1;
                        continue;
                    }
                    if (i + 1 < chars.length && (chars[i] != ',' || quotesCount != 0)) continue;
                    String value = new String(chars, tokenIndex, i - tokenIndex);
                    if ((value = value.trim()).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1);
                        value = value.substring(0, value.length() - 1);
                    }
                    auth.setChallengeParameter(name, value);
                    tokenIndex = i + 1;
                    parsingToken = true;
                }
                HTTPDigestAuthentication digestAuth = (HTTPDigestAuthentication)auth;
                digestAuth.init();
                break;
            }
            if ("NTLM".equalsIgnoreCase(method)) {
                HTTPNTLMAuthentication ntlmAuth = null;
                if (source.length() == 0) {
                    String ntlmImpl = System.getProperty("svnkit.http.ntlm", "java:apache");
                    if ("jna".equalsIgnoreCase(ntlmImpl) && (ntlmAuth = HTTPNativeNTLMAuthentication.newInstance(charset)) != null) {
                        ntlmAuth.parseChallenge(null);
                    }
                    if (ntlmAuth == null) {
                        if ("jna".equalsIgnoreCase(ntlmImpl)) {
                            ntlmImpl = "java";
                        }
                        ntlmAuth = "java:apache".equalsIgnoreCase(ntlmImpl) ? HTTPApacheNTLMAuthentication.newInstance(charset, "APACHE") : ("java:jcifs".equalsIgnoreCase(ntlmImpl) ? HTTPApacheNTLMAuthentication.newInstance(charset, "JCIFS") : new HTTPNTLMAuthentication(charset));
                    }
                    ntlmAuth.setType1State();
                } else {
                    ntlmAuth = (HTTPNTLMAuthentication)prevResponse;
                    ntlmAuth.parseChallenge(source);
                    ntlmAuth.setType3State();
                }
                auth = ntlmAuth;
                break;
            }
            if (!"Negotiate".equalsIgnoreCase(method)) continue;
            HTTPNegotiateAuthentication negoAuth = null;
            if (source.length() == 0) {
                if (authManager instanceof IHTTPNegotiateAuthenticationFactory) {
                    negoAuth = ((IHTTPNegotiateAuthenticationFactory)((Object)authManager)).createNegotiateAuthentication(prevResponse instanceof HTTPNegotiateAuthentication ? (HTTPNegotiateAuthentication)prevResponse : null, requestID);
                } else if (DefaultHTTPNegotiateAuthentication.isSupported()) {
                    if (prevResponse instanceof DefaultHTTPNegotiateAuthentication) {
                        negoAuth = new DefaultHTTPNegotiateAuthentication((DefaultHTTPNegotiateAuthentication)prevResponse);
                    } else {
                        negoAuth = new DefaultHTTPNegotiateAuthentication();
                        try {
                            negoAuth.needsLogin();
                        }
                        catch (Throwable th) {
                            negoAuth = null;
                        }
                    }
                }
                if (negoAuth != null) {
                    negoAuth.respondTo(null);
                }
            } else {
                negoAuth = (HTTPNegotiateAuthentication)prevResponse;
                negoAuth.respondTo(source);
            }
            if (negoAuth == null) continue;
            auth = negoAuth;
            break;
        }
        if (auth == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "HTTP authorization method ''{0}'' is not supported", (Object)authHeader2);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (prevResponse != null) {
            auth.setUserName(prevResponse.getRawUserName());
            auth.setPassword(prevResponse.getPassword());
        }
        return auth;
    }

    public static boolean isSchemeSupportedByServer(String scheme, Collection<String> authHeaderValues) throws SVNException {
        if (authHeaderValues == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Missing HTTP authorization method");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        String authHeader2 = null;
        for (String authHeader2 : authHeaderValues) {
            String method;
            String source = authHeader2.trim();
            int index = source.indexOf(32);
            if (index <= 0) {
                index = source.length();
            }
            if (!(method = source.substring(0, index)).equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }

    private static Collection<String> sortSchemes(Collection<String> authHeaders, Collection<String> authTypes) {
        String priorities = System.getProperty(AUTH_METHODS_PROPERTY, System.getProperty(OLD_AUTH_METHODS_PROPERTY));
        final ArrayList<String> schemes = new ArrayList<String>();
        if (authTypes != null && !authTypes.isEmpty()) {
            schemes.addAll(authTypes);
        } else if (priorities != null && !"".equals(priorities.trim())) {
            StringTokenizer tokens = new StringTokenizer(priorities, " ,");
            while (tokens.hasMoreTokens()) {
                String scheme = tokens.nextToken();
                if (schemes.contains(scheme)) continue;
                schemes.add(scheme);
            }
        } else {
            return authHeaders;
        }
        ArrayList<String> ordered = new ArrayList<String>(authHeaders);
        Collections.sort(ordered, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String header1 = o1;
                String header2 = o2;
                String scheme1 = HTTPAuthentication.getSchemeName(header1);
                String scheme2 = HTTPAuthentication.getSchemeName(header2);
                int index1 = schemes.indexOf(scheme1);
                int index2 = schemes.indexOf(scheme2);
                index1 = index1 < 0 ? Integer.MAX_VALUE : index1;
                int n = index2 = index2 < 0 ? Integer.MAX_VALUE : index2;
                if (index1 == index2) {
                    return 0;
                }
                return index1 > index2 ? 1 : -1;
            }
        });
        return ordered;
    }

    private static String getSchemeName(String header) {
        String source = header.trim();
        int index = source.indexOf(32);
        if (index <= 0) {
            index = source.length();
        }
        return source.substring(0, index);
    }

    public abstract String getAuthenticationScheme();

    public abstract String authenticate() throws SVNException;

    protected static byte[] getASCIIBytes(String data) {
        return HTTPAuthentication.getBytes(data, "US-ASCII");
    }

    protected static byte[] getBytes(String data, String charset) {
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data.getBytes();
        }
    }

    protected static byte[] getBytes(char[] data, String charset) {
        return SVNEncodingUtil.getBytes(data, charset);
    }

    public static void clear(byte[] array) {
        SVNEncodingUtil.clearArray(array);
    }

    public static void clear(char[] array) {
        SVNEncodingUtil.clearArray(array);
    }
}

