/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.handlers;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import afu.org.tmatesoft.svn.core.internal.util.SVNBase64;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import afu.org.xml.sax.Attributes;
import afu.org.xml.sax.SAXException;
import afu.org.xml.sax.helpers.DefaultHandler;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class BasicDAVHandler
extends DefaultHandler {
    protected static final Collection SVN_DAV_NAMESPACES_LIST = new LinkedList();
    protected static final Collection SVN_NAMESPACES_LIST = new LinkedList();
    protected static final Collection DAV_NAMESPACES_LIST = new LinkedList();
    private static final Object ROOT;
    private Map myPrefixesMap = new SVNHashMap();
    private List myNamespacesCollection = new LinkedList();
    private String myNamespace;
    private StringBuffer myCDATA;
    private Stack myParent = new Stack();
    private byte[] myDeltaBuffer;

    protected BasicDAVHandler() {
    }

    private void setNamespace(String uri) {
        this.myNamespace = "".equals(uri) ? null : uri;
    }

    protected void init() {
        this.myPrefixesMap.clear();
        this.myNamespacesCollection.clear();
        this.myParent.clear();
        this.myParent.push(ROOT);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.setNamespace(uri);
        DAVElement element = this.getDAVElement(qName, localName, this.myNamespace);
        try {
            this.startElement(this.getParent(), element, attributes);
        }
        catch (SVNException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
            throw new SAXException((Exception)e);
        }
        this.myParent.push(element);
        this.myCDATA = new StringBuffer();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.myParent.pop();
        String namespace = uri != null && !"".equals(uri) ? uri : this.myNamespace;
        DAVElement element = this.getDAVElement(qName, localName, namespace);
        try {
            this.endElement(this.getParent(), element, this.myCDATA);
        }
        catch (SVNException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
            throw new SAXException((Exception)e);
        }
        this.myCDATA = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myCDATA != null) {
            this.myCDATA.append(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        Stack<String> mappings = (Stack<String>)this.myPrefixesMap.get(prefix);
        if (mappings == null) {
            mappings = new Stack<String>();
            this.myPrefixesMap.put(prefix, mappings);
        }
        mappings.push(uri);
        if (!this.myNamespacesCollection.contains(uri)) {
            this.myNamespacesCollection.add(uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Stack mappings = (Stack)this.myPrefixesMap.get(prefix);
        if (mappings != null) {
            mappings.pop();
        }
    }

    protected abstract void startElement(DAVElement var1, DAVElement var2, Attributes var3) throws SVNException;

    protected abstract void endElement(DAVElement var1, DAVElement var2, StringBuffer var3) throws SVNException;

    protected void invalidXML() throws SVNException {
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, "Malformed XML"), SVNLogType.NETWORK);
    }

    protected List getNamespaces() {
        return this.myNamespacesCollection;
    }

    private DAVElement getParent() {
        Object parent = this.myParent.peek();
        if (parent == ROOT) {
            return null;
        }
        return (DAVElement)parent;
    }

    private DAVElement getDAVElement(String qName, String localName, String namespace) {
        if (qName == null || qName.trim().length() == 0) {
            qName = localName;
        }
        String prefix = namespace;
        int index = qName.indexOf(58);
        if (index >= 0) {
            prefix = qName.substring(0, index);
            Stack prefixes = (Stack)this.myPrefixesMap.get(prefix);
            if (prefixes != null && !prefixes.isEmpty()) {
                prefix = (String)prefixes.peek();
            }
            qName = qName.substring(index + 1);
        }
        return DAVElement.getElement(prefix, qName);
    }

    protected SVNPropertyValue createPropertyValue(DAVElement element, String propertyName, StringBuffer cdata, String encoding) throws SVNException {
        byte[] rawValue;
        if ("base64".equalsIgnoreCase(encoding)) {
            return this.createPropertyValueFromBase64(element, propertyName, cdata);
        }
        if (encoding != null && !"".equals(encoding)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_UNKNOWN_ENCODING, "Unknown XML encoding: ''{0}''", (Object)encoding);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (this.useStringProperty(element, propertyName)) {
            return SVNPropertyValue.create(cdata.toString());
        }
        try {
            rawValue = cdata.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            rawValue = cdata.toString().getBytes();
        }
        return SVNPropertyValue.create(propertyName, rawValue);
    }

    protected SVNPropertyValue createPropertyValueFromBase64(DAVElement element, String propertyName, StringBuffer cdata) {
        StringBuffer sb = SVNBase64.normalizeBase64(cdata);
        byte[] buffer = this.allocateBuffer(sb.length());
        int length = SVNBase64.base64ToByteArray(sb, buffer);
        if (this.useStringProperty(element, propertyName)) {
            String str;
            try {
                str = new String(buffer, 0, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                str = new String(buffer, 0, length);
            }
            return SVNPropertyValue.create(str);
        }
        return SVNPropertyValue.create(propertyName, buffer, 0, length);
    }

    private boolean useStringProperty(DAVElement element, String propertyName) {
        String namespace = element == null ? null : element.getNamespace();
        return SVNProperty.isSVNProperty(propertyName) || "http://subversion.tigris.org/xmlns/dav/".equals(namespace) || "http://subversion.tigris.org/xmlns/svn/".equals(namespace) || "svn:".equals(namespace) || "DAV:".equals(namespace);
    }

    protected byte[] allocateBuffer(int length) {
        if (this.myDeltaBuffer == null || this.myDeltaBuffer.length < length) {
            this.myDeltaBuffer = new byte[length * 3 / 2];
        }
        return this.myDeltaBuffer;
    }

    static {
        SVN_DAV_NAMESPACES_LIST.add("svn:");
        SVN_DAV_NAMESPACES_LIST.add("DAV:");
        SVN_NAMESPACES_LIST.add("svn:");
        DAV_NAMESPACES_LIST.add("DAV:");
        ROOT = new Object();
    }
}

