/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav;

import afu.org.tmatesoft.svn.core.SVNCommitInfo;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVResource;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import afu.org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import afu.org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPBodyInputStream;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.io.ISVNEditor;
import afu.org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import afu.org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Stack;

class DAVCommitEditor
implements ISVNEditor {
    private DAVConnection myConnection;
    private SVNURL myLocation;
    private DAVRepository myRepository;
    private Runnable myCloseCallback;
    private String myActivity;
    private Stack myDirsStack;
    private ISVNWorkspaceMediator myCommitMediator;
    private Map myPathsMap;
    private Map myFilesMap;
    private String myBaseChecksum;
    private SVNProperties myRevProps;
    private String myActivityLocation;
    private OutputStream myCurrentDelta = null;
    private File myDeltaFile;
    private boolean myIsAborted;
    private boolean myIsFirstWindow;

    public DAVCommitEditor(DAVRepository repository, DAVConnection connection, String message, ISVNWorkspaceMediator mediator, Runnable closeCallback) {
        this(repository, connection, (SVNProperties)null, mediator, closeCallback);
        this.myRevProps = new SVNProperties();
        if (message != null) {
            this.myRevProps.put("svn:log", message);
        }
    }

    public DAVCommitEditor(DAVRepository repository, DAVConnection connection, SVNProperties revProps, ISVNWorkspaceMediator mediator, Runnable closeCallback) {
        this.myConnection = connection;
        this.myLocation = repository.getLocation();
        this.myRepository = repository;
        this.myCloseCallback = closeCallback;
        this.myCommitMediator = mediator;
        this.myDirsStack = new Stack();
        this.myPathsMap = new SVNHashMap();
        this.myFilesMap = new SVNHashMap();
        this.myRevProps = revProps != null ? revProps : new SVNProperties();
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        String[] activityUrls = this.createActivity();
        this.myActivity = activityUrls[0];
        this.myActivityLocation = activityUrls[1];
        DAVResource root = new DAVResource(this.myCommitMediator, this.myConnection, "", revision);
        root.fetchVersionURL(null, false);
        this.myDirsStack.push(root);
        this.myPathsMap.put(root.getURL(), root.getPath());
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        String url;
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(parentResource, true);
        String wPath = parentResource.getWorkingURL();
        if (this.myDirsStack.size() == 1) {
            wPath = SVNPathUtil.append(parentResource.getWorkingURL(), path);
            url = SVNPathUtil.append(parentResource.getURL(), path);
        } else {
            wPath = SVNPathUtil.append(wPath, SVNPathUtil.tail(path));
            url = SVNPathUtil.append(parentResource.getURL(), SVNPathUtil.tail(path));
        }
        this.myConnection.doDelete(url, wPath, revision);
        if (this.myDirsStack.size() == 1) {
            this.myPathsMap.put(SVNPathUtil.append(parentResource.getURL(), path), path);
        } else {
            this.myPathsMap.put(SVNPathUtil.append(parentResource.getURL(), SVNPathUtil.tail(path)), path);
        }
    }

    @Override
    public void addDir(String path, String copyPath, long copyRevision) throws SVNException {
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(parentResource, true);
        String wPath = parentResource.getWorkingURL();
        DAVResource newDir = new DAVResource(this.myCommitMediator, this.myConnection, path, -1L, copyPath != null);
        newDir.setWorkingURL(SVNPathUtil.append(wPath, SVNPathUtil.tail(path)));
        newDir.setAdded(true);
        this.myDirsStack.push(newDir);
        this.myPathsMap.put(newDir.getURL(), path);
        if (copyPath != null) {
            copyPath = this.myRepository.doGetFullPath(copyPath);
            copyPath = SVNEncodingUtil.uriEncode(copyPath);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.myRepository, copyPath, copyRevision, false, false, null);
            copyPath = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            wPath = this.myLocation.setPath(newDir.getWorkingURL(), true).toString();
            this.myConnection.doCopy(copyPath, wPath, 1);
        } else {
            try {
                this.myConnection.doMakeCollection(newDir.getWorkingURL());
            }
            catch (SVNException e) {
                if (!e.getErrorMessage().getErrorCode().isAuthentication() && e.getErrorMessage().getErrorCode() != SVNErrorCode.CANCELLED) {
                    SVNErrorMessage err = null;
                    try {
                        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.myRepository, newDir.getURL(), -1L, false, false, null);
                        if (info != null) {
                            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)newDir.getURL());
                        }
                    }
                    catch (SVNException inner) {
                        // empty catch block
                    }
                    if (err != null) {
                        SVNErrorManager.error(err, SVNLogType.NETWORK);
                    }
                }
                throw e;
            }
        }
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parent = this.myDirsStack.peek() != null ? (DAVResource)this.myDirsStack.peek() : null;
        DAVResource directory = new DAVResource(this.myCommitMediator, this.myConnection, path, revision, parent != null && parent.isCopy());
        if (parent != null && parent.getVersionURL() == null) {
            directory.setWorkingURL(SVNPathUtil.append(parent.getWorkingURL(), SVNPathUtil.tail(path)));
        } else {
            directory.fetchVersionURL(parent, false);
        }
        this.myDirsStack.push(directory);
        this.myPathsMap.put(directory.getURL(), directory.getPath());
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        DAVResource directory = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(directory, true);
        directory.putProperty(name, value);
        this.myPathsMap.put(directory.getURL(), directory.getPath());
    }

    @Override
    public void closeDir() throws SVNException {
        DAVResource resource = (DAVResource)this.myDirsStack.pop();
        if (resource.getProperties() != null) {
            StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, resource.getProperties());
            this.myConnection.doProppatch(resource.getURL(), resource.getWorkingURL(), request, null, null);
        }
        resource.dispose();
    }

    @Override
    public void addFile(String path, String copyPath, long copyRevision) throws SVNException {
        String originalPath = path;
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(parentResource, true);
        String wPath = parentResource.getWorkingURL();
        DAVResource newFile = new DAVResource(this.myCommitMediator, this.myConnection, path, -1L, copyPath != null);
        newFile.setWorkingURL(SVNPathUtil.append(wPath, SVNPathUtil.tail(path)));
        if (!parentResource.isAdded() && !this.myPathsMap.containsKey(newFile.getURL())) {
            String filePath = SVNPathUtil.append(parentResource.getURL(), SVNPathUtil.tail(path));
            SVNErrorMessage err1 = null;
            SVNErrorMessage err2 = null;
            try {
                DAVUtil.getResourceProperties(this.myConnection, filePath, null, DAVElement.STARTING_PROPERTIES);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() == null) {
                    throw e;
                }
                err1 = e.getErrorMessage();
            }
            try {
                DAVUtil.getResourceProperties(this.myConnection, newFile.getWorkingURL(), null, DAVElement.STARTING_PROPERTIES);
            }
            catch (SVNException e) {
                if (e.getErrorMessage() == null) {
                    throw e;
                }
                err2 = e.getErrorMessage();
            }
            if (err1 == null && err2 == null) {
                err1 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_ALREADY_EXISTS, "File ''{0}'' already exists", (Object)filePath);
                SVNErrorManager.error(err1, SVNLogType.NETWORK);
            } else if (!(err1 != null && err1.getErrorCode() == SVNErrorCode.FS_NOT_FOUND || err2 != null && err2.getErrorCode() == SVNErrorCode.FS_NOT_FOUND)) {
                SVNErrorManager.error(err1, err2, SVNLogType.NETWORK);
            }
        }
        this.myPathsMap.put(newFile.getURL(), newFile.getPath());
        this.myFilesMap.put(originalPath, newFile);
        newFile.setAdded(true);
        if (copyPath != null) {
            copyPath = this.myRepository.doGetFullPath(copyPath);
            copyPath = SVNEncodingUtil.uriEncode(copyPath);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.myRepository, copyPath, copyRevision, false, false, null);
            copyPath = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            wPath = this.myLocation.setPath(newFile.getWorkingURL(), true).toString();
            this.myConnection.doCopy(copyPath, wPath, 0);
        }
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        String originalPath = path;
        path = SVNEncodingUtil.uriEncode(path);
        DAVResource file = new DAVResource(this.myCommitMediator, this.myConnection, path, revision);
        DAVResource parent = (DAVResource)this.myDirsStack.peek();
        if (parent.getVersionURL() == null) {
            file.setWorkingURL(SVNPathUtil.append(parent.getWorkingURL(), SVNPathUtil.tail(path)));
        } else {
            file.fetchVersionURL(parent, false);
        }
        this.checkoutResource(file, true);
        this.myPathsMap.put(file.getURL(), file.getPath());
        this.myFilesMap.put(originalPath, file);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myCurrentDelta = null;
        this.myIsFirstWindow = true;
        this.myDeltaFile = null;
        this.myBaseChecksum = baseChecksum;
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        try {
            if (this.myCurrentDelta == null) {
                this.myDeltaFile = SVNFileUtil.createTempFile("svnkit", ".tmp");
                this.myCurrentDelta = SVNFileUtil.openFileForWriting(this.myDeltaFile);
            }
            diffWindow.writeTo(this.myCurrentDelta, this.myIsFirstWindow);
            this.myIsFirstWindow = false;
            return SVNFileUtil.DUMMY_OUT;
        }
        catch (IOException e) {
            SVNFileUtil.closeFile(this.myCurrentDelta);
            SVNFileUtil.deleteFile(this.myDeltaFile);
            this.myDeltaFile = null;
            this.myCurrentDelta = null;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, e, SVNLogType.NETWORK);
            return null;
        }
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        SVNFileUtil.closeFile(this.myCurrentDelta);
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        DAVResource currentFile = (DAVResource)this.myFilesMap.get(path);
        currentFile.putProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        DAVResource currentFile = (DAVResource)this.myFilesMap.get(path);
        try {
            if (this.myDeltaFile != null) {
                HTTPBodyInputStream combinedData = null;
                try {
                    combinedData = new HTTPBodyInputStream(this.myDeltaFile);
                    this.myConnection.doPutDiff(currentFile.getURL(), currentFile.getWorkingURL(), combinedData, this.myDeltaFile.length(), this.myBaseChecksum, textChecksum);
                }
                catch (SVNException e) {
                    try {
                        HTTPStatus httpStatus = this.myConnection.getLastStatus();
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_REQUEST_FAILED && httpStatus != null) {
                            switch (httpStatus.getCode()) {
                                case 423: {
                                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_LOCKED, "No lock on path ''{0}'' (Status {0} on PUT Request)", new Object[]{currentFile.getWorkingURL(), httpStatus.getCode()});
                                    SVNErrorManager.error(errorMessage, e, SVNLogType.CLIENT);
                                }
                            }
                            throw e;
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(combinedData);
                        SVNFileUtil.deleteFile(this.myDeltaFile);
                        this.myDeltaFile = null;
                        throw throwable;
                    }
                }
                SVNFileUtil.closeFile(combinedData);
                SVNFileUtil.deleteFile(this.myDeltaFile);
                this.myDeltaFile = null;
            }
            if (currentFile.getProperties() != null) {
                StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, currentFile.getProperties());
                this.myConnection.doProppatch(currentFile.getURL(), currentFile.getWorkingURL(), request, null, null);
            }
        }
        finally {
            currentFile.dispose();
            this.myCurrentDelta = null;
            this.myBaseChecksum = null;
            this.myFilesMap.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        try {
            if (!this.myDirsStack.isEmpty()) {
                DAVResource resource = (DAVResource)this.myDirsStack.pop();
                if (resource.getProperties() != null) {
                    StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, resource.getProperties());
                    this.myConnection.doProppatch(resource.getURL(), resource.getWorkingURL(), request, null, null);
                }
                resource.dispose();
            }
            DAVMergeHandler handler = new DAVMergeHandler(this.myCommitMediator, this.myPathsMap);
            this.patchResourceProperties(this.myActivityLocation, this.myRevProps);
            HTTPStatus status = this.myConnection.doMerge(this.myActivity, true, handler);
            if (status.getError() != null) {
                this.myIsAborted = true;
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            SVNCommitInfo sVNCommitInfo = handler.getCommitInfo();
            return sVNCommitInfo;
        }
        finally {
            try {
                this.abortEdit();
            }
            catch (SVNException e) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.DEFAULT, e);
            }
            this.runCloseCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortEdit() throws SVNException {
        if (this.myIsAborted) {
            return;
        }
        this.myIsAborted = true;
        try {
            try {
                if (this.myActivity != null) {
                    this.myConnection.doDelete(this.myActivity);
                }
            }
            finally {
                if (this.myFilesMap != null) {
                    for (DAVResource file : this.myFilesMap.values()) {
                        file.dispose();
                    }
                    this.myFilesMap = null;
                }
                for (DAVResource resource : this.myDirsStack) {
                    resource.dispose();
                }
                this.myDirsStack = null;
            }
        }
        finally {
            this.runCloseCallback();
        }
    }

    private void runCloseCallback() {
        if (this.myCloseCallback != null) {
            this.myCloseCallback.run();
            this.myCloseCallback = null;
        }
    }

    private String[] createActivity() throws SVNException {
        String location;
        String activity = this.myConnection.doMakeActivity(this.myCommitMediator);
        String path = SVNEncodingUtil.uriEncode(this.myLocation.getPath());
        String vcc = DAVUtil.getPropertyValue(this.myConnection, path, null, DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        HTTPStatus status = null;
        for (int i = 0; i < 5; ++i) {
            String head = DAVUtil.getPropertyValue(this.myConnection, vcc, null, DAVElement.CHECKED_IN);
            try {
                status = this.myConnection.doCheckout(activity, null, head, false);
                break;
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.APMOD_BAD_BASELINE && i != 4) continue;
                throw svne;
            }
        }
        if ((location = status.getHeader().getFirstHeaderValue("Location")) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The CHECKOUT response did not contain a 'Location:' header");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (this.myRevProps != null) {
            SVNPropertyValue authorRevisionProperty = this.myRevProps.remove("svn:author");
            this.patchResourceProperties(location, this.myRevProps);
            if (authorRevisionProperty != null) {
                this.myRevProps = new SVNProperties();
                this.myRevProps.put("svn:author", authorRevisionProperty);
            } else {
                this.myRevProps = null;
            }
        }
        return new String[]{activity, location};
    }

    private void patchResourceProperties(String path, SVNProperties properties) throws SVNException {
        if (properties != null && properties.size() > 0) {
            StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, properties);
            try {
                this.myConnection.doProppatch(null, path, request, null, null);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "applying log message to {0}", (Object)path);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        }
    }

    private void checkoutResource(DAVResource resource, boolean allow404) throws SVNException {
        String location;
        if (resource.getWorkingURL() != null) {
            return;
        }
        HTTPStatus status = null;
        try {
            status = this.myConnection.doCheckout(this.myActivity, resource.getURL(), resource.getVersionURL(), allow404);
            if (allow404 && status.getCode() == 404) {
                resource.fetchVersionURL(null, true);
                status = this.myConnection.doCheckout(this.myActivity, resource.getURL(), resource.getVersionURL(), false);
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_CONFLICT) {
                String path = resource.getPath();
                if ("".equals(path)) {
                    path = resource.getURL();
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CONFLICT, "File or directory ''{0}'' is out of date; try updating", (Object)path);
                SVNErrorManager.error(err, e.getErrorMessage(), SVNLogType.NETWORK);
            }
            throw e;
        }
        String string = location = status != null ? status.getHeader().getFirstHeaderValue("Location") : null;
        if (location == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The CHECKOUT response did not contain a 'Location:' header");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        resource.setWorkingURL(location);
    }
}

