/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.db;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import java.util.Map;

public abstract class SVNSqlJetUpdateStatement
extends SVNSqlJetSelectStatement {
    public SVNSqlJetUpdateStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        this(sDb, fromTable, null);
    }

    public SVNSqlJetUpdateStatement(SVNSqlJetDb sDb, Enum<?> fromTable, Enum<?> indexName) throws SVNException {
        super(sDb, fromTable, indexName);
        if (SVNWCDbSchema.NODES == fromTable) {
            SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
            this.addTrigger(trigger);
        }
        this.transactionMode = SqlJetTransactionMode.WRITE;
    }

    public void update(Map<String, Object> values) throws SqlJetException {
        if (this.getCursor() == null) {
            throw new UnsupportedOperationException();
        }
        this.beforeUpdate(this.getCursor(), values);
        this.getCursor().updateByFieldNames(values);
    }

    private void beforeUpdate(ISqlJetCursor cursor, Map<String, Object> values) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.beforeUpdate(cursor, values);
            }
            catch (SqlJetException e) {}
        }
    }

    @Override
    public long exec() throws SVNException {
        long n = 0L;
        try {
            this.statementStarted();
            while (this.next()) {
                Map<String, Object> values = this.getUpdateValues();
                this.update(values);
                ++n;
            }
            this.statementCompleted(null);
        }
        catch (SqlJetException e) {
            this.statementCompleted(e);
            SVNSqlJetDb.createSqlJetError(e);
        }
        return n;
    }

    public abstract Map<String, Object> getUpdateValues() throws SVNException;
}

