/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.db;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetTable;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class SVNSqlJetTableStatement
extends SVNSqlJetStatement {
    protected ISqlJetTable table;
    protected String tableName;
    private Collection<ISVNSqlJetTrigger> triggers;

    public SVNSqlJetTableStatement(SVNSqlJetDb sDb, Enum<?> tableName) throws SVNException {
        this(sDb, tableName.toString());
    }

    public String getTableName() {
        return this.tableName;
    }

    public SVNSqlJetTableStatement(SVNSqlJetDb sDb, String tableName) throws SVNException {
        super(sDb);
        this.tableName = tableName;
        try {
            this.table = sDb.getDb().getTable(tableName);
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
        }
    }

    public void addTrigger(ISVNSqlJetTrigger trigger) {
        if (trigger != null) {
            if (this.triggers == null) {
                this.triggers = new ArrayList<ISVNSqlJetTrigger>();
            }
            this.triggers.add(trigger);
        }
    }

    protected Collection<ISVNSqlJetTrigger> getTriggers() {
        if (this.triggers == null) {
            return Collections.emptyList();
        }
        return this.triggers;
    }

    public ISqlJetTable getTable() {
        return this.table;
    }

    protected void statementStarted() {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.statementStarted(this.sDb.getDb());
            }
            catch (SqlJetException sqlJetException) {}
        }
    }

    protected void statementCompleted(SqlJetException error) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.statementCompleted(this.sDb.getDb(), error);
            }
            catch (SqlJetException e) {}
        }
    }

    @Override
    public void reset() throws SVNException {
        super.reset();
        if (this.triggers != null) {
            this.triggers.clear();
        }
    }
}

