/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.db;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import afu.org.tmatesoft.sqljet.core.table.SqlJetDb;
import afu.org.tmatesoft.sqljet.core.table.SqlJetTimeoutBusyHandler;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.EnumMap;

public class SVNSqlJetDb {
    private static final ISqlJetBusyHandler DEFAULT_BUSY_HANDLER = new SqlJetTimeoutBusyHandler(10000);
    private static boolean logTransactions = "true".equalsIgnoreCase(System.getProperty("svnkit.log.transactions", "false"));
    private static SqlJetPagerJournalMode ourPagerJournalMode = SqlJetPagerJournalMode.DELETE;
    private SqlJetDb db;
    private EnumMap<SVNWCDbStatements, SVNSqlJetStatement> statements;
    private int openCount = 0;
    private SVNSqlJetDb temporaryDb;

    private SVNSqlJetDb(SqlJetDb db) {
        this.db = db;
        this.statements = new EnumMap(SVNWCDbStatements.class);
    }

    public SqlJetDb getDb() {
        return this.db;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public void close() throws SVNException {
        if (this.temporaryDb != null) {
            try {
                this.temporaryDb.close();
            }
            catch (SVNException e) {
                // empty catch block
            }
            this.temporaryDb = null;
        }
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (SqlJetException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    public static void setJournalMode(SqlJetPagerJournalMode journalMode) {
        ourPagerJournalMode = journalMode == null ? SqlJetPagerJournalMode.DELETE : journalMode;
    }

    public static SqlJetPagerJournalMode getJournalMode() {
        return ourPagerJournalMode;
    }

    public static SVNSqlJetDb open(File sdbAbsPath, Mode mode) throws SVNException {
        return SVNSqlJetDb.open(sdbAbsPath, mode, SVNSqlJetDb.getJournalMode());
    }

    public static SVNSqlJetDb open(File sdbAbsPath, Mode mode, SqlJetPagerJournalMode journalMode) throws SVNException {
        if (mode != Mode.RWCreate && !sdbAbsPath.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "File not found ''{0}''", (Object)sdbAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (journalMode == null) {
            journalMode = SVNSqlJetDb.getJournalMode();
        }
        try {
            SqlJetDb db = SqlJetDb.open(sdbAbsPath, mode != Mode.ReadOnly);
            db.setBusyHandler(DEFAULT_BUSY_HANDLER);
            db.setSafetyLevel(SqlJetSafetyLevel.OFF);
            db.setJournalMode(journalMode);
            return new SVNSqlJetDb(db);
        }
        catch (SqlJetException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    public SVNSqlJetDb getTemporaryDb() throws SVNException {
        if (this.temporaryDb == null) {
            try {
                this.temporaryDb = new SVNSqlJetDb(this.getDb().getTemporaryDatabase(false));
            }
            catch (SqlJetException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
                return null;
            }
        }
        return this.temporaryDb;
    }

    public SVNSqlJetStatement getStatement(SVNWCDbStatements statementIndex) throws SVNException {
        assert (statementIndex != null);
        SVNSqlJetStatement stmt = this.statements.get((Object)statementIndex);
        if (stmt == null) {
            stmt = this.prepareStatement(statementIndex);
            this.statements.put(statementIndex, stmt);
        } else if (stmt instanceof SVNSqlJetInsertStatement || stmt instanceof SVNSqlJetUpdateStatement || stmt instanceof SVNSqlJetDeleteStatement) {
            String targetTableName = ((SVNSqlJetTableStatement)stmt).getTableName();
            if (SVNWCDbSchema.NODES.toString().equals(targetTableName)) {
                SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
                ((SVNSqlJetTableStatement)stmt).addTrigger(trigger);
            }
        }
        if (stmt != null && stmt.isNeedsReset()) {
            stmt.reset();
        }
        return stmt;
    }

    private SVNSqlJetStatement prepareStatement(SVNWCDbStatements statementIndex) throws SVNException {
        Class<? extends SVNSqlJetStatement> statementClass = statementIndex.getStatementClass();
        SVNErrorManager.assertionFailure(statementClass != null, String.format("Statement '%s' not defined", statementIndex.toString()), SVNLogType.WC);
        if (statementClass == null) {
            return null;
        }
        try {
            Constructor<? extends SVNSqlJetStatement> constructor = statementClass.getConstructor(SVNSqlJetDb.class);
            SVNSqlJetStatement stmt = constructor.newInstance(this);
            return stmt;
        }
        catch (Exception e) {
            SVNErrorCode errorCode = SVNErrorCode.UNSUPPORTED_FEATURE;
            String message = e.getMessage() != null ? e.getMessage() : errorCode.getDescription();
            SVNErrorMessage err = SVNErrorMessage.create(errorCode, message, new Object[0], 0, e);
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    public void execStatement(SVNWCDbStatements statementIndex) throws SVNException {
        SVNSqlJetStatement statement = this.getStatement(statementIndex);
        if (statement != null) {
            statement.exec();
        }
    }

    public static void createSqlJetError(SqlJetException e) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    public void beginTransaction(SqlJetTransactionMode mode) throws SVNException {
        if (mode != null) {
            ++this.openCount;
            if (SVNSqlJetDb.isLogTransactions()) {
                this.logCall("Being transaction request (" + this.openCount + "): " + (Object)((Object)mode), 5);
            }
            if (this.isNeedStartTransaction(mode)) {
                try {
                    this.db.beginTransaction(mode);
                    if (SVNSqlJetDb.isLogTransactions()) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "transaction started");
                    }
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
            }
        } else {
            SVNErrorManager.assertionFailure(mode != null, "transaction mode is null", SVNLogType.WC);
        }
    }

    private boolean isNeedStartTransaction(SqlJetTransactionMode mode) {
        if (!this.db.isInTransaction()) {
            return true;
        }
        SqlJetTransactionMode dbMode = this.db.getTransactionMode();
        return mode != dbMode && (SqlJetTransactionMode.WRITE == mode || SqlJetTransactionMode.EXCLUSIVE == mode) && SqlJetTransactionMode.READ_ONLY == dbMode;
    }

    public void commit() throws SVNException {
        if (this.openCount > 0) {
            --this.openCount;
            if (SVNSqlJetDb.isLogTransactions()) {
                this.logCall("Commit transaction request (" + this.openCount + ")", 5);
            }
            if (this.openCount == 0) {
                try {
                    this.db.commit();
                    if (SVNSqlJetDb.isLogTransactions()) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "transaction committed");
                    }
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
            }
        } else {
            SVNErrorManager.assertionFailure(this.openCount > 0, "no opened transactions", SVNLogType.WC);
        }
    }

    public void verifyNoWork() {
    }

    public void runTransaction(SVNSqlJetTransaction transaction) throws SVNException {
        this.runTransaction(transaction, SqlJetTransactionMode.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(SVNSqlJetTransaction transaction, SqlJetTransactionMode mode) throws SVNException {
        try {
            this.beginTransaction(mode);
            transaction.transaction(this);
        }
        catch (SqlJetException e) {
            try {
                this.db.rollback();
            }
            catch (SqlJetException e1) {
                e1.initCause(e);
                SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e1);
                SVNErrorManager.error(err1, SVNLogType.DEFAULT);
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        finally {
            this.commit();
        }
    }

    public void rollback() throws SVNException {
        try {
            this.db.rollback();
        }
        catch (SqlJetException e1) {
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e1);
            SVNErrorManager.error(err1, SVNLogType.DEFAULT);
        }
    }

    public boolean hasTable(String tableName) throws SVNException {
        try {
            return tableName != null && this.db.getSchema().getTableNames().contains(tableName);
        }
        catch (SqlJetException e) {
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err1, SVNLogType.DEFAULT);
            return false;
        }
    }

    private void logCall(String message, int count) {
        if (SVNSqlJetDb.isLogTransactions()) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            sb.append(message);
            sb.append(":\n");
            for (int i = 0; i < trace.length && i < count; ++i) {
                sb.append(trace[i].getClassName());
                sb.append('.');
                sb.append(trace[i].getMethodName());
                sb.append(':');
                sb.append(trace[i].getLineNumber());
                sb.append('\n');
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, message.toString());
        }
    }

    private static boolean isLogTransactions() {
        return logTransactions;
    }

    public static enum Mode {
        ReadOnly,
        ReadWrite,
        RWCreate;

    }
}

