/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.wc.SVNPropertyData;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookPropListCommand
extends SVNLookCommand {
    protected SVNLookPropListCommand() {
        super("proplist", new String[]{"plist", "pl"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.VERBOSE);
        options.add(SVNLookOption.REVPROP);
        options.add(SVNLookOption.XML);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        if (!environment.isRevProp() && environment.getFirstArgument() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        SVNLookClient client = environment.getClientManager().getLookClient();
        SVNProperties props = null;
        props = environment.isRevision() ? (environment.isRevProp() ? client.doGetRevisionProperties(environment.getRepositoryFile(), this.getRevisionObject()) : client.doGetProperties(environment.getRepositoryFile(), environment.getFirstArgument(), this.getRevisionObject())) : (environment.isRevProp() ? client.doGetRevisionProperties(environment.getRepositoryFile(), environment.getTransaction()) : client.doGetProperties(environment.getRepositoryFile(), environment.getFirstArgument(), environment.getTransaction()));
        if (props != null) {
            for (String propName : props.nameSet()) {
                SVNPropertyData propData = new SVNPropertyData(propName, props.getSVNPropertyValue(propName), client.getOptions());
                SVNPropertyValue propValue = propData.getValue();
                if (environment.isVerbose()) {
                    environment.getOut().print("  " + propName + " : ");
                    if (propValue.isString()) {
                        environment.getOut().println(propValue.getString());
                        continue;
                    }
                    environment.getOut().println(SVNPropertyValue.getPropertyAsString(propValue));
                    continue;
                }
                environment.getOut().println("  " + propName);
            }
        }
    }
}

