/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLogEntry;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookInfoCommand
extends SVNLookCommand {
    public SVNLookInfoCommand() {
        super("info", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        SVNLogEntry logEntry = null;
        logEntry = environment.isRevision() ? client.doGetInfo(environment.getRepositoryFile(), this.getRevisionObject()) : client.doGetInfo(environment.getRepositoryFile(), environment.getTransaction());
        String author = logEntry.getAuthor() != null ? logEntry.getAuthor() : "";
        String date = logEntry.getDate() != null ? SVNDate.formatCustomDate(logEntry.getDate()) : "";
        String log = logEntry.getMessage() != null ? logEntry.getMessage() : "";
        environment.getOut().println(author);
        environment.getOut().println(date);
        if (log == null || log.length() == 0) {
            environment.getOut().println("0");
        } else {
            environment.getOut().println(String.valueOf(log.length()));
            environment.getOut().println(log);
        }
    }
}

