/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookFileSizeCommand
extends SVNLookCommand {
    public SVNLookFileSizeCommand() {
        super("filesize", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        String path = environment.getFirstArgument();
        if (environment.getFirstArgument() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        SVNLookClient client = environment.getClientManager().getLookClient();
        long fileSize = environment.isRevision() ? client.doGetFileSize(environment.getRepositoryFile(), path, this.getRevisionObject()) : client.doGetFileSize(environment.getRepositoryFile(), path, environment.getTransaction());
        environment.getOut().println(fileSize);
    }
}

