/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnadmin;

import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;

public class SVNAdminRecoverCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    public SVNAdminRecoverCommand() {
        super("recover", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.WAIT);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        client.setEventHandler(this);
        client.doRecover(this.getLocalRepository());
        this.getEnvironment().getOut().println();
        this.getEnvironment().getOut().println("Recovery completed.");
        long youngestRevision = client.getYoungestRevision(this.getLocalRepository());
        String message = "The latest repos revision is {0}.";
        message = MessageFormat.format(message, String.valueOf(youngestRevision));
        this.getEnvironment().getOut().println(message);
    }

    @Override
    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event.getAction() == SVNAdminEventAction.RECOVERY_STARTED) {
            this.getEnvironment().getOut().println("Repository lock acquired.");
            this.getEnvironment().getOut().println("Please wait; recovering the repository may take some time...");
        }
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

