/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnadmin;

import afu.org.tmatesoft.svn.cli.SVNCommandUtil;
import afu.org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import java.util.Collection;
import java.util.LinkedList;

public class SVNAdminListLocksCommand
extends SVNAdminCommand {
    public SVNAdminListLocksCommand() {
        super("lslocks", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    @Override
    public void run() throws SVNException {
        ISVNOptions options = this.getEnvironment().getClientManager().getOptions();
        SVNURL url = SVNURL.fromFile(this.getLocalRepository());
        SVNRepository repository = SVNRepositoryFactory.create(url);
        repository.setCanceller(this.getEnvironment());
        SVNLock[] locks = repository.getLocks("/");
        for (int i = 0; locks != null && i < locks.length; ++i) {
            SVNLock lock = locks[i];
            StringBuffer buffer = new StringBuffer();
            String comment = "(0 lines):";
            if (lock.getComment() != null) {
                int count = SVNCommandUtil.getLinesCount(lock.getComment());
                comment = count != 1 ? count + " lines" : count + " line";
                comment = "(" + comment + "):\n" + lock.getComment();
            }
            String created = lock.getCreationDate() != null ? SVNDate.formatHumanDate(lock.getCreationDate(), options) : "";
            String expires = lock.getExpirationDate() != null ? SVNDate.formatHumanDate(lock.getExpirationDate(), options) : "";
            buffer.append("Path: " + lock.getPath() + "\n");
            buffer.append("UUID Token: " + lock.getID() + "\n");
            buffer.append("Owner: " + lock.getOwner() + "\n");
            buffer.append("Created: " + created + "\n");
            buffer.append("Expires: " + expires + "\n");
            buffer.append("Comment " + comment + "\n\n");
            this.getEnvironment().getOut().print(buffer.toString());
        }
    }
}

