/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNWCClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNUnLockCommand
extends SVNCommand {
    public SVNUnLockCommand() {
        super("unlock", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.FORCE);
        return options;
    }

    @Override
    public void run() throws SVNException {
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
        client.setEventHandler(printer);
        ArrayList<File> paths = new ArrayList<File>();
        ArrayList<SVNURL> urls = new ArrayList<SVNURL>();
        for (String string : targets) {
            SVNPath target = new SVNPath(string);
            if (target.isURL()) {
                urls.add(target.getURL());
                continue;
            }
            paths.add(target.getFile());
        }
        if (!paths.isEmpty()) {
            File[] filesArray = paths.toArray(new File[paths.size()]);
            client.doUnlock(filesArray, this.getSVNEnvironment().isForce());
        }
        if (!urls.isEmpty()) {
            SVNURL[] urlsArray = urls.toArray(new SVNURL[urls.size()]);
            client.doUnlock(urlsArray, this.getSVNEnvironment().isForce());
        }
    }
}

