/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNConflictChoice;
import afu.org.tmatesoft.svn.core.wc.SVNWCClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNResolvedCommand
extends SVNCommand {
    public SVNResolvedCommand() {
        super("resolved", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (!target.isFile()) continue;
            try {
                client.doResolve(target.getFile(), depth, SVNConflictChoice.MERGED);
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                this.getSVNEnvironment().handleWarning(err, new SVNErrorCode[]{err.getErrorCode()}, this.getSVNEnvironment().isQuiet());
            }
        }
    }
}

