/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import afu.org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNConflictChoice;
import afu.org.tmatesoft.svn.core.wc.SVNWCClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNResolveCommand
extends SVNCommand {
    public SVNResolveCommand() {
        super("resolve", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.ACCEPT);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        SVNErrorMessage err;
        SVNConflictAcceptPolicy accept = this.getSVNEnvironment().getResolveAccept();
        SVNConflictChoice choice = null;
        if (accept == SVNConflictAcceptPolicy.WORKING) {
            choice = SVNConflictChoice.MERGED;
        } else if (accept == SVNConflictAcceptPolicy.BASE) {
            choice = SVNConflictChoice.BASE;
        } else if (accept == SVNConflictAcceptPolicy.THEIRS_CONFLICT) {
            choice = SVNConflictChoice.THEIRS_CONFLICT;
        } else if (accept == SVNConflictAcceptPolicy.MINE_CONFLICT) {
            choice = SVNConflictChoice.MINE_CONFLICT;
        } else if (accept == SVNConflictAcceptPolicy.MINE_FULL) {
            choice = SVNConflictChoice.MINE_FULL;
        } else if (accept == SVNConflictAcceptPolicy.THEIRS_FULL) {
            choice = SVNConflictChoice.THEIRS_FULL;
        } else if (accept == null || accept == SVNConflictAcceptPolicy.UNSPECIFIED) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "missing --accept option");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        } else {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "invalid 'accept' ARG");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (!target.isFile()) continue;
            try {
                client.doResolve(target.getFile(), depth, choice);
            }
            catch (SVNException e) {
                SVNErrorMessage err2 = e.getErrorMessage();
                this.getSVNEnvironment().handleWarning(err2, new SVNErrorCode[]{err2.getErrorCode()}, this.getSVNEnvironment().isQuiet());
            }
        }
    }
}

