/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli;

import afu.org.tmatesoft.svn.cli.AbstractSVNCommand;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AbstractSVNOption {
    private String myName;
    private String myAlias;
    private boolean myIsUnary;

    protected AbstractSVNOption(String name, String alias, boolean unary) {
        this.myName = name;
        this.myAlias = alias;
        this.myIsUnary = unary;
    }

    public String getName() {
        return this.myName;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public boolean isUnary() {
        return this.myIsUnary;
    }

    public String getDescription(AbstractSVNCommand context, String programName) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.getResourceBundleName());
        }
        catch (MissingResourceException missing) {
            bundle = null;
        }
        if (bundle != null) {
            String[] stringArray;
            if (context != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = this.getName() + "." + context.getName();
                stringArray2[1] = this.getAlias() + "." + context.getName();
                stringArray2[2] = this.getName();
                stringArray = stringArray2;
                stringArray2[3] = this.getAlias();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.getName();
                stringArray = stringArray3;
                stringArray3[1] = this.getAlias();
            }
            String[] keys = stringArray;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key == null) continue;
                try {
                    return bundle.getString(key);
                }
                catch (MissingResourceException missing) {
                    // empty catch block
                }
            }
        }
        return MessageFormat.format("not supported by ''{0}''", programName);
    }

    protected abstract String getResourceBundleName();

    public String toString() {
        return this.getName();
    }
}

