/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli;

import afu.org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import afu.org.tmatesoft.svn.cli.AbstractSVNOption;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;

public abstract class AbstractSVNCommand {
    private static final Comparator DEFAULT_COMMAND_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            AbstractSVNCommand c1 = (AbstractSVNCommand)o1;
            AbstractSVNCommand c2 = (AbstractSVNCommand)o2;
            return c1.getName().compareTo(c2.getName());
        }
    };
    private static Map ourCommands = new SVNHashMap();
    private String myName;
    private String[] myAliases;
    private Collection myOptions;
    private AbstractSVNCommandEnvironment myEnvironment;
    private Collection myValidOptions;
    private boolean myIsFailed;

    public static void registerCommand(AbstractSVNCommand command) {
        ourCommands.put(command.getName(), command);
        for (int i = 0; i < command.getAliases().length; ++i) {
            ourCommands.put(command.getAliases()[i], command);
        }
    }

    public static AbstractSVNCommand getCommand(String nameOrAlias) {
        return (AbstractSVNCommand)ourCommands.get(nameOrAlias);
    }

    public static Iterator availableCommands(Comparator comparator) {
        comparator = comparator == null ? DEFAULT_COMMAND_COMPARATOR : comparator;
        TreeSet sortedList = new TreeSet(comparator);
        sortedList.addAll(ourCommands.values());
        return sortedList.iterator();
    }

    protected AbstractSVNCommand(String name, String[] aliases) {
        this.myName = name;
        this.myAliases = aliases == null ? new String[]{} : aliases;
        this.myOptions = this.createSupportedOptions();
        if (this.myOptions == null) {
            this.myOptions = new LinkedList();
        }
        this.myValidOptions = new LinkedList(this.myOptions);
        this.myOptions.addAll(this.getGlobalOptions());
    }

    public boolean isFailed() {
        return this.myIsFailed;
    }

    public void setFailed(boolean failed) {
        this.myIsFailed = failed;
    }

    public abstract void run() throws SVNException;

    protected abstract Collection createSupportedOptions();

    protected abstract String getResourceBundleName();

    public String getName() {
        return this.myName;
    }

    public String[] getAliases() {
        return this.myAliases;
    }

    public Collection getSupportedOptions() {
        return this.myOptions;
    }

    public Collection getValidOptions() {
        return this.myValidOptions;
    }

    public abstract Collection getGlobalOptions();

    public void init(AbstractSVNCommandEnvironment env) {
        this.myEnvironment = env;
    }

    protected AbstractSVNCommandEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    public String getDescription() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.getResourceBundleName());
        }
        catch (MissingResourceException missing) {
            missing.printStackTrace();
            bundle = null;
        }
        if (bundle != null) {
            try {
                return bundle.getString(this.getName() + ".description");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format("No description has been found for ''{0}'' command.", this.getName());
    }

    public boolean isAlias(String alias) {
        String[] aliases = this.getAliases();
        for (int i = 0; i < aliases.length; ++i) {
            if (!aliases[i].equals(alias)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptionSupported(AbstractSVNOption option) {
        boolean supported;
        boolean bl = supported = this.getSupportedOptions() != null && this.getSupportedOptions().contains(option);
        if (!supported) {
            return option == SVNOption.HELP || option == SVNOption.QUESTION;
        }
        return supported;
    }
}

